/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.os.NativeHandle;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.Closeable;
import java.io.IOException;

@SystemApi
public class HidlMemory
implements Closeable {
    private final String mName;
    private final long mSize;
    private NativeHandle mHandle;
    private long mNativeContext;

    public HidlMemory(String name, long size, NativeHandle handle) {
        this.mName = name;
        this.mSize = size;
        this.mHandle = handle;
    }

    public HidlMemory dup() throws IOException {
        return new HidlMemory(this.mName, this.mSize, this.mHandle != null ? this.mHandle.dup() : null);
    }

    @Override
    public void close() throws IOException {
        if (this.mHandle != null) {
            this.mHandle.close();
        }
    }

    public NativeHandle releaseHandle() {
        NativeHandle handle = this.mHandle;
        this.mHandle = null;
        return handle;
    }

    public String getName() {
        return this.mName;
    }

    public long getSize() {
        return this.mSize;
    }

    public NativeHandle getHandle() {
        return this.mHandle;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.nativeFinalize();
        }
    }

    private void nativeFinalize() {
        OverrideMethod.invokeV("android.os.HidlMemory#nativeFinalize()V", true, this);
    }
}

