/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.NetworkInfo;
import android.net.wifi.WpsInfo;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pGroupList;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pWfdInfo;
import android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceResponse;
import android.net.wifi.p2p.nsd.WifiP2pServiceInfo;
import android.net.wifi.p2p.nsd.WifiP2pServiceRequest;
import android.net.wifi.p2p.nsd.WifiP2pServiceResponse;
import android.net.wifi.p2p.nsd.WifiP2pUpnpServiceResponse;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.CloseGuard;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Reference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WifiP2pManager {
    private static final String TAG = "WifiP2pManager";
    public static final String WIFI_P2P_STATE_CHANGED_ACTION = "android.net.wifi.p2p.STATE_CHANGED";
    public static final String EXTRA_WIFI_STATE = "wifi_p2p_state";
    public static final int WIFI_P2P_STATE_DISABLED = 1;
    public static final int WIFI_P2P_STATE_ENABLED = 2;
    public static final String WIFI_P2P_CONNECTION_CHANGED_ACTION = "android.net.wifi.p2p.CONNECTION_STATE_CHANGE";
    public static final String EXTRA_WIFI_P2P_INFO = "wifiP2pInfo";
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_WIFI_P2P_GROUP = "p2pGroupInfo";
    public static final String WIFI_P2P_PEERS_CHANGED_ACTION = "android.net.wifi.p2p.PEERS_CHANGED";
    public static final String EXTRA_P2P_DEVICE_LIST = "wifiP2pDeviceList";
    public static final String WIFI_P2P_DISCOVERY_CHANGED_ACTION = "android.net.wifi.p2p.DISCOVERY_STATE_CHANGE";
    public static final String EXTRA_DISCOVERY_STATE = "discoveryState";
    public static final int WIFI_P2P_DISCOVERY_STOPPED = 1;
    public static final int WIFI_P2P_DISCOVERY_STARTED = 2;
    public static final String WIFI_P2P_THIS_DEVICE_CHANGED_ACTION = "android.net.wifi.p2p.THIS_DEVICE_CHANGED";
    public static final String EXTRA_WIFI_P2P_DEVICE = "wifiP2pDevice";
    @SystemApi
    public static final String ACTION_WIFI_P2P_PERSISTENT_GROUPS_CHANGED = "android.net.wifi.p2p.action.WIFI_P2P_PERSISTENT_GROUPS_CHANGED";
    public static final String EXTRA_HANDOVER_MESSAGE = "android.net.wifi.p2p.EXTRA_HANDOVER_MESSAGE";
    public static final String CALLING_PACKAGE = "android.net.wifi.p2p.CALLING_PACKAGE";
    public static final String CALLING_FEATURE_ID = "android.net.wifi.p2p.CALLING_FEATURE_ID";
    public static final String CALLING_BINDER = "android.net.wifi.p2p.CALLING_BINDER";
    IWifiP2pManager mService;
    private static final int BASE = 139264;
    public static final int DISCOVER_PEERS = 139265;
    public static final int DISCOVER_PEERS_FAILED = 139266;
    public static final int DISCOVER_PEERS_SUCCEEDED = 139267;
    public static final int STOP_DISCOVERY = 139268;
    public static final int STOP_DISCOVERY_FAILED = 139269;
    public static final int STOP_DISCOVERY_SUCCEEDED = 139270;
    public static final int CONNECT = 139271;
    public static final int CONNECT_FAILED = 139272;
    public static final int CONNECT_SUCCEEDED = 139273;
    public static final int CANCEL_CONNECT = 139274;
    public static final int CANCEL_CONNECT_FAILED = 139275;
    public static final int CANCEL_CONNECT_SUCCEEDED = 139276;
    @UnsupportedAppUsage
    public static final int CREATE_GROUP = 139277;
    public static final int CREATE_GROUP_FAILED = 139278;
    public static final int CREATE_GROUP_SUCCEEDED = 139279;
    public static final int REMOVE_GROUP = 139280;
    public static final int REMOVE_GROUP_FAILED = 139281;
    public static final int REMOVE_GROUP_SUCCEEDED = 139282;
    public static final int REQUEST_PEERS = 139283;
    public static final int RESPONSE_PEERS = 139284;
    public static final int REQUEST_CONNECTION_INFO = 139285;
    public static final int RESPONSE_CONNECTION_INFO = 139286;
    public static final int REQUEST_GROUP_INFO = 139287;
    public static final int RESPONSE_GROUP_INFO = 139288;
    public static final int ADD_LOCAL_SERVICE = 139292;
    public static final int ADD_LOCAL_SERVICE_FAILED = 139293;
    public static final int ADD_LOCAL_SERVICE_SUCCEEDED = 139294;
    public static final int REMOVE_LOCAL_SERVICE = 139295;
    public static final int REMOVE_LOCAL_SERVICE_FAILED = 139296;
    public static final int REMOVE_LOCAL_SERVICE_SUCCEEDED = 139297;
    public static final int CLEAR_LOCAL_SERVICES = 139298;
    public static final int CLEAR_LOCAL_SERVICES_FAILED = 139299;
    public static final int CLEAR_LOCAL_SERVICES_SUCCEEDED = 139300;
    public static final int ADD_SERVICE_REQUEST = 139301;
    public static final int ADD_SERVICE_REQUEST_FAILED = 139302;
    public static final int ADD_SERVICE_REQUEST_SUCCEEDED = 139303;
    public static final int REMOVE_SERVICE_REQUEST = 139304;
    public static final int REMOVE_SERVICE_REQUEST_FAILED = 139305;
    public static final int REMOVE_SERVICE_REQUEST_SUCCEEDED = 139306;
    public static final int CLEAR_SERVICE_REQUESTS = 139307;
    public static final int CLEAR_SERVICE_REQUESTS_FAILED = 139308;
    public static final int CLEAR_SERVICE_REQUESTS_SUCCEEDED = 139309;
    public static final int DISCOVER_SERVICES = 139310;
    public static final int DISCOVER_SERVICES_FAILED = 139311;
    public static final int DISCOVER_SERVICES_SUCCEEDED = 139312;
    public static final int PING = 139313;
    public static final int RESPONSE_SERVICE = 139314;
    public static final int SET_DEVICE_NAME = 139315;
    public static final int SET_DEVICE_NAME_FAILED = 139316;
    public static final int SET_DEVICE_NAME_SUCCEEDED = 139317;
    public static final int DELETE_PERSISTENT_GROUP = 139318;
    public static final int DELETE_PERSISTENT_GROUP_FAILED = 139319;
    public static final int DELETE_PERSISTENT_GROUP_SUCCEEDED = 139320;
    public static final int REQUEST_PERSISTENT_GROUP_INFO = 139321;
    public static final int RESPONSE_PERSISTENT_GROUP_INFO = 139322;
    public static final int SET_WFD_INFO = 139323;
    public static final int SET_WFD_INFO_FAILED = 139324;
    public static final int SET_WFD_INFO_SUCCEEDED = 139325;
    public static final int START_WPS = 139326;
    public static final int START_WPS_FAILED = 139327;
    public static final int START_WPS_SUCCEEDED = 139328;
    public static final int START_LISTEN = 139329;
    public static final int START_LISTEN_FAILED = 139330;
    public static final int START_LISTEN_SUCCEEDED = 139331;
    public static final int STOP_LISTEN = 139332;
    public static final int STOP_LISTEN_FAILED = 139333;
    public static final int STOP_LISTEN_SUCCEEDED = 139334;
    public static final int SET_CHANNEL = 139335;
    public static final int SET_CHANNEL_FAILED = 139336;
    public static final int SET_CHANNEL_SUCCEEDED = 139337;
    public static final int GET_HANDOVER_REQUEST = 139339;
    public static final int GET_HANDOVER_SELECT = 139340;
    public static final int RESPONSE_GET_HANDOVER_MESSAGE = 139341;
    public static final int INITIATOR_REPORT_NFC_HANDOVER = 139342;
    public static final int RESPONDER_REPORT_NFC_HANDOVER = 139343;
    public static final int REPORT_NFC_HANDOVER_SUCCEEDED = 139344;
    public static final int REPORT_NFC_HANDOVER_FAILED = 139345;
    public static final int FACTORY_RESET = 139346;
    public static final int FACTORY_RESET_FAILED = 139347;
    public static final int FACTORY_RESET_SUCCEEDED = 139348;
    public static final int REQUEST_ONGOING_PEER_CONFIG = 139349;
    public static final int RESPONSE_ONGOING_PEER_CONFIG = 139350;
    public static final int SET_ONGOING_PEER_CONFIG = 139351;
    public static final int SET_ONGOING_PEER_CONFIG_FAILED = 139352;
    public static final int SET_ONGOING_PEER_CONFIG_SUCCEEDED = 139353;
    public static final int REQUEST_P2P_STATE = 139354;
    public static final int RESPONSE_P2P_STATE = 139355;
    public static final int REQUEST_DISCOVERY_STATE = 139356;
    public static final int RESPONSE_DISCOVERY_STATE = 139357;
    public static final int REQUEST_NETWORK_INFO = 139358;
    public static final int RESPONSE_NETWORK_INFO = 139359;
    public static final int UPDATE_CHANNEL_INFO = 139360;
    public static final int REQUEST_DEVICE_INFO = 139361;
    public static final int RESPONSE_DEVICE_INFO = 139362;
    public static final int ERROR = 0;
    public static final int P2P_UNSUPPORTED = 1;
    public static final int BUSY = 2;
    public static final int NO_SERVICE_REQUESTS = 3;
    @SystemApi
    public static final int MIRACAST_DISABLED = 0;
    @SystemApi
    public static final int MIRACAST_SOURCE = 1;
    @SystemApi
    public static final int MIRACAST_SINK = 2;

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public WifiP2pManager(IWifiP2pManager service) {
        this.mService = service;
    }

    private static void checkChannel(Channel c) {
        if (c == null) {
            throw new IllegalArgumentException("Channel needs to be initialized");
        }
    }

    private static void checkServiceInfo(WifiP2pServiceInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("service info is null");
        }
    }

    private static void checkServiceRequest(WifiP2pServiceRequest req) {
        if (req == null) {
            throw new IllegalArgumentException("service request is null");
        }
    }

    private static void checkP2pConfig(WifiP2pConfig c) {
        if (c == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        if (TextUtils.isEmpty(c.deviceAddress)) {
            throw new IllegalArgumentException("deviceAddress cannot be empty");
        }
    }

    public Channel initialize(Context srcContext, Looper srcLooper, ChannelListener listener) {
        Binder binder = new Binder();
        Channel channel = this.initalizeChannel(srcContext, srcLooper, listener, this.getMessenger(binder), binder);
        return channel;
    }

    public Channel initializeInternal(Context srcContext, Looper srcLooper, ChannelListener listener) {
        return this.initalizeChannel(srcContext, srcLooper, listener, this.getP2pStateMachineMessenger(), null);
    }

    private Channel initalizeChannel(Context srcContext, Looper srcLooper, ChannelListener listener, Messenger messenger, Binder binder) {
        if (messenger == null) {
            return null;
        }
        Channel c = new Channel(srcContext, srcLooper, listener, binder, this);
        if (c.mAsyncChannel.connectSync(srcContext, (Handler)c.mHandler, messenger) == 0) {
            Bundle bundle = new Bundle();
            bundle.putString(CALLING_PACKAGE, c.mContext.getOpPackageName());
            bundle.putString(CALLING_FEATURE_ID, c.mContext.getAttributionTag());
            bundle.putBinder(CALLING_BINDER, binder);
            c.mAsyncChannel.sendMessage(139360, 0, c.putListener(null), bundle);
            return c;
        }
        c.close();
        return null;
    }

    public void discoverPeers(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139265, 0, c.putListener(listener));
    }

    public void stopPeerDiscovery(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139268, 0, c.putListener(listener));
    }

    public void connect(Channel c, WifiP2pConfig config, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pManager.checkP2pConfig(config);
        c.mAsyncChannel.sendMessage(139271, 0, c.putListener(listener), config);
    }

    public void cancelConnect(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139274, 0, c.putListener(listener));
    }

    public void createGroup(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139277, -2, c.putListener(listener));
    }

    public void createGroup(Channel c, WifiP2pConfig config, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139277, 0, c.putListener(listener), config);
    }

    public void removeGroup(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139280, 0, c.putListener(listener));
    }

    @SystemApi
    public void startListening(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139329, 0, c.putListener(listener));
    }

    @SystemApi
    public void stopListening(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139332, 0, c.putListener(listener));
    }

    @SystemApi
    public void setWifiP2pChannels(Channel c, int listeningChannel, int operatingChannel, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        Bundle p2pChannels = new Bundle();
        p2pChannels.putInt("lc", listeningChannel);
        p2pChannels.putInt("oc", operatingChannel);
        c.mAsyncChannel.sendMessage(139335, 0, c.putListener(listener), p2pChannels);
    }

    @UnsupportedAppUsage
    public void startWps(Channel c, WpsInfo wps, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139326, 0, c.putListener(listener), wps);
    }

    public void addLocalService(Channel c, WifiP2pServiceInfo servInfo, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pManager.checkServiceInfo(servInfo);
        c.mAsyncChannel.sendMessage(139292, 0, c.putListener(listener), servInfo);
    }

    public void removeLocalService(Channel c, WifiP2pServiceInfo servInfo, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pManager.checkServiceInfo(servInfo);
        c.mAsyncChannel.sendMessage(139295, 0, c.putListener(listener), servInfo);
    }

    public void clearLocalServices(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139298, 0, c.putListener(listener));
    }

    public void setServiceResponseListener(Channel c, ServiceResponseListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mServRspListener = listener;
    }

    public void setDnsSdResponseListeners(Channel c, DnsSdServiceResponseListener servListener, DnsSdTxtRecordListener txtListener) {
        WifiP2pManager.checkChannel(c);
        c.mDnsSdServRspListener = servListener;
        c.mDnsSdTxtListener = txtListener;
    }

    public void setUpnpServiceResponseListener(Channel c, UpnpServiceResponseListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mUpnpServRspListener = listener;
    }

    public void discoverServices(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139310, 0, c.putListener(listener));
    }

    public void addServiceRequest(Channel c, WifiP2pServiceRequest req, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pManager.checkServiceRequest(req);
        c.mAsyncChannel.sendMessage(139301, 0, c.putListener(listener), req);
    }

    public void removeServiceRequest(Channel c, WifiP2pServiceRequest req, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pManager.checkServiceRequest(req);
        c.mAsyncChannel.sendMessage(139304, 0, c.putListener(listener), req);
    }

    public void clearServiceRequests(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139307, 0, c.putListener(listener));
    }

    public void requestPeers(Channel c, PeerListListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139283, 0, c.putListener(listener));
    }

    public void requestConnectionInfo(Channel c, ConnectionInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139285, 0, c.putListener(listener));
    }

    public void requestGroupInfo(Channel c, GroupInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139287, 0, c.putListener(listener));
    }

    @SystemApi
    public void setDeviceName(Channel c, String devName, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pDevice d = new WifiP2pDevice();
        d.deviceName = devName;
        c.mAsyncChannel.sendMessage(139315, 0, c.putListener(listener), d);
    }

    @SystemApi
    public void setWfdInfo(Channel c, WifiP2pWfdInfo wfdInfo, ActionListener listener) {
        this.setWFDInfo(c, wfdInfo, listener);
    }

    @UnsupportedAppUsage
    public void setWFDInfo(Channel c, WifiP2pWfdInfo wfdInfo, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        try {
            this.mService.checkConfigureWifiDisplayPermission();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        c.mAsyncChannel.sendMessage(139323, 0, c.putListener(listener), wfdInfo);
    }

    @SystemApi
    public void deletePersistentGroup(Channel c, int netId, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139318, netId, c.putListener(listener));
    }

    @SystemApi
    public void requestPersistentGroupInfo(Channel c, PersistentGroupInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139321, 0, c.putListener(listener));
    }

    @SystemApi
    public void setMiracastMode(int mode) {
        try {
            this.mService.setMiracastMode(mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Messenger getMessenger(Binder binder) {
        try {
            return this.mService.getMessenger(binder);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Messenger getP2pStateMachineMessenger() {
        try {
            return this.mService.getP2pStateMachineMessenger();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getNfcHandoverRequest(Channel c, HandoverMessageListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139339, 0, c.putListener(listener));
    }

    public void getNfcHandoverSelect(Channel c, HandoverMessageListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139340, 0, c.putListener(listener));
    }

    public void initiatorReportNfcHandover(Channel c, String handoverSelect, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        Bundle bundle = new Bundle();
        bundle.putString(EXTRA_HANDOVER_MESSAGE, handoverSelect);
        c.mAsyncChannel.sendMessage(139342, 0, c.putListener(listener), bundle);
    }

    public void responderReportNfcHandover(Channel c, String handoverRequest, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        Bundle bundle = new Bundle();
        bundle.putString(EXTRA_HANDOVER_MESSAGE, handoverRequest);
        c.mAsyncChannel.sendMessage(139343, 0, c.putListener(listener), bundle);
    }

    @SystemApi
    public void factoryReset(Channel c, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139346, 0, c.putListener(listener));
    }

    public void requestOngoingPeerConfig(Channel c, OngoingPeerInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        c.mAsyncChannel.sendMessage(139349, Binder.getCallingUid(), c.putListener(listener));
    }

    public void setOngoingPeerConfig(Channel c, WifiP2pConfig config, ActionListener listener) {
        WifiP2pManager.checkChannel(c);
        WifiP2pManager.checkP2pConfig(config);
        c.mAsyncChannel.sendMessage(139351, 0, c.putListener(listener), config);
    }

    public void requestP2pState(Channel c, P2pStateListener listener) {
        WifiP2pManager.checkChannel(c);
        if (listener == null) {
            throw new IllegalArgumentException("This listener cannot be null.");
        }
        c.mAsyncChannel.sendMessage(139354, 0, c.putListener(listener));
    }

    public void requestDiscoveryState(Channel c, DiscoveryStateListener listener) {
        WifiP2pManager.checkChannel(c);
        if (listener == null) {
            throw new IllegalArgumentException("This listener cannot be null.");
        }
        c.mAsyncChannel.sendMessage(139356, 0, c.putListener(listener));
    }

    public void requestNetworkInfo(Channel c, NetworkInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        if (listener == null) {
            throw new IllegalArgumentException("This listener cannot be null.");
        }
        c.mAsyncChannel.sendMessage(139358, 0, c.putListener(listener));
    }

    public void requestDeviceInfo(Channel c, DeviceInfoListener listener) {
        WifiP2pManager.checkChannel(c);
        if (listener == null) {
            throw new IllegalArgumentException("This listener cannot be null.");
        }
        c.mAsyncChannel.sendMessage(139361, 0, c.putListener(listener));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MiracastMode {
    }

    public static class Channel
    implements AutoCloseable {
        private static final int INVALID_LISTENER_KEY = 0;
        private final WifiP2pManager mP2pManager;
        private ChannelListener mChannelListener;
        private ServiceResponseListener mServRspListener;
        private DnsSdServiceResponseListener mDnsSdServRspListener;
        private DnsSdTxtRecordListener mDnsSdTxtListener;
        private UpnpServiceResponseListener mUpnpServRspListener;
        private HashMap<Integer, Object> mListenerMap = new HashMap();
        private final Object mListenerMapLock = new Object();
        private int mListenerKey = 0;
        private final CloseGuard mCloseGuard = new CloseGuard();
        final Binder mBinder;
        @UnsupportedAppUsage
        private AsyncChannel mAsyncChannel = new AsyncChannel();
        private P2pHandler mHandler;
        Context mContext;

        public Channel(Context context, Looper looper, ChannelListener l, Binder binder, WifiP2pManager p2pManager) {
            this.mHandler = new P2pHandler(looper);
            this.mChannelListener = l;
            this.mContext = context;
            this.mBinder = binder;
            this.mP2pManager = p2pManager;
            this.mCloseGuard.open("close");
        }

        @Override
        public void close() {
            if (this.mP2pManager == null) {
                Log.w(WifiP2pManager.TAG, "Channel.close(): Null mP2pManager!?");
            } else {
                try {
                    this.mP2pManager.mService.close(this.mBinder);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            this.mAsyncChannel.disconnect();
            this.mCloseGuard.close();
            Reference.reachabilityFence(this);
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void handleServiceResponse(WifiP2pServiceResponse resp) {
            if (resp instanceof WifiP2pDnsSdServiceResponse) {
                this.handleDnsSdServiceResponse((WifiP2pDnsSdServiceResponse)resp);
            } else if (resp instanceof WifiP2pUpnpServiceResponse) {
                if (this.mUpnpServRspListener != null) {
                    this.handleUpnpServiceResponse((WifiP2pUpnpServiceResponse)resp);
                }
            } else if (this.mServRspListener != null) {
                this.mServRspListener.onServiceAvailable(resp.getServiceType(), resp.getRawData(), resp.getSrcDevice());
            }
        }

        private void handleUpnpServiceResponse(WifiP2pUpnpServiceResponse resp) {
            this.mUpnpServRspListener.onUpnpServiceAvailable(resp.getUniqueServiceNames(), resp.getSrcDevice());
        }

        private void handleDnsSdServiceResponse(WifiP2pDnsSdServiceResponse resp) {
            if (resp.getDnsType() == 12) {
                if (this.mDnsSdServRspListener != null) {
                    this.mDnsSdServRspListener.onDnsSdServiceAvailable(resp.getInstanceName(), resp.getDnsQueryName(), resp.getSrcDevice());
                }
            } else if (resp.getDnsType() == 16) {
                if (this.mDnsSdTxtListener != null) {
                    this.mDnsSdTxtListener.onDnsSdTxtRecordAvailable(resp.getDnsQueryName(), resp.getTxtRecord(), resp.getSrcDevice());
                }
            } else {
                Log.e(WifiP2pManager.TAG, "Unhandled resp " + resp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @UnsupportedAppUsage
        private int putListener(Object listener) {
            int key;
            if (listener == null) {
                return 0;
            }
            Object object = this.mListenerMapLock;
            synchronized (object) {
                do {
                    ++this.mListenerKey;
                } while (key == 0);
                this.mListenerMap.put(key, listener);
            }
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getListener(int key) {
            if (key == 0) {
                return null;
            }
            Object object = this.mListenerMapLock;
            synchronized (object) {
                return this.mListenerMap.remove(key);
            }
        }

        class P2pHandler
        extends Handler {
            P2pHandler(Looper looper) {
                super(looper);
            }

            @Override
            public void handleMessage(Message message) {
                Object listener = Channel.this.getListener(message.arg2);
                switch (message.what) {
                    case 69636: {
                        if (Channel.this.mChannelListener == null) break;
                        Channel.this.mChannelListener.onChannelDisconnected();
                        Channel.this.mChannelListener = null;
                        break;
                    }
                    case 139266: 
                    case 139269: 
                    case 139272: 
                    case 139275: 
                    case 139278: 
                    case 139281: 
                    case 139293: 
                    case 139296: 
                    case 139299: 
                    case 139302: 
                    case 139305: 
                    case 139308: 
                    case 139311: 
                    case 139316: 
                    case 139319: 
                    case 139324: 
                    case 139327: 
                    case 139330: 
                    case 139333: 
                    case 139336: 
                    case 139345: 
                    case 139347: 
                    case 139352: {
                        if (listener == null) break;
                        ((ActionListener)listener).onFailure(message.arg1);
                        break;
                    }
                    case 139267: 
                    case 139270: 
                    case 139273: 
                    case 139276: 
                    case 139279: 
                    case 139282: 
                    case 139294: 
                    case 139297: 
                    case 139300: 
                    case 139303: 
                    case 139306: 
                    case 139309: 
                    case 139312: 
                    case 139317: 
                    case 139320: 
                    case 139325: 
                    case 139328: 
                    case 139331: 
                    case 139334: 
                    case 139337: 
                    case 139344: 
                    case 139348: 
                    case 139353: {
                        if (listener == null) break;
                        ((ActionListener)listener).onSuccess();
                        break;
                    }
                    case 139284: {
                        WifiP2pDeviceList peers = (WifiP2pDeviceList)message.obj;
                        if (listener == null) break;
                        ((PeerListListener)listener).onPeersAvailable(peers);
                        break;
                    }
                    case 139286: {
                        WifiP2pInfo wifiP2pInfo = (WifiP2pInfo)message.obj;
                        if (listener == null) break;
                        ((ConnectionInfoListener)listener).onConnectionInfoAvailable(wifiP2pInfo);
                        break;
                    }
                    case 139288: {
                        WifiP2pGroup group = (WifiP2pGroup)message.obj;
                        if (listener == null) break;
                        ((GroupInfoListener)listener).onGroupInfoAvailable(group);
                        break;
                    }
                    case 139314: {
                        WifiP2pServiceResponse resp = (WifiP2pServiceResponse)message.obj;
                        Channel.this.handleServiceResponse(resp);
                        break;
                    }
                    case 139322: {
                        WifiP2pGroupList groups = (WifiP2pGroupList)message.obj;
                        if (listener == null) break;
                        ((PersistentGroupInfoListener)listener).onPersistentGroupInfoAvailable(groups);
                        break;
                    }
                    case 139341: {
                        Bundle handoverBundle = (Bundle)message.obj;
                        if (listener == null) break;
                        String handoverMessage = handoverBundle != null ? handoverBundle.getString(WifiP2pManager.EXTRA_HANDOVER_MESSAGE) : null;
                        ((HandoverMessageListener)listener).onHandoverMessageAvailable(handoverMessage);
                        break;
                    }
                    case 139350: {
                        WifiP2pConfig peerConfig = (WifiP2pConfig)message.obj;
                        if (listener == null) break;
                        ((OngoingPeerInfoListener)listener).onOngoingPeerAvailable(peerConfig);
                        break;
                    }
                    case 139355: {
                        if (listener == null) break;
                        ((P2pStateListener)listener).onP2pStateAvailable(message.arg1);
                        break;
                    }
                    case 139357: {
                        if (listener == null) break;
                        ((DiscoveryStateListener)listener).onDiscoveryStateAvailable(message.arg1);
                        break;
                    }
                    case 139359: {
                        if (listener == null) break;
                        ((NetworkInfoListener)listener).onNetworkInfoAvailable((NetworkInfo)message.obj);
                        break;
                    }
                    case 139362: {
                        if (listener == null) break;
                        ((DeviceInfoListener)listener).onDeviceInfoAvailable((WifiP2pDevice)message.obj);
                        break;
                    }
                    default: {
                        Log.d(WifiP2pManager.TAG, "Ignored " + message);
                    }
                }
            }
        }
    }

    public static interface DeviceInfoListener {
        public void onDeviceInfoAvailable(WifiP2pDevice var1);
    }

    public static interface OngoingPeerInfoListener {
        public void onOngoingPeerAvailable(WifiP2pConfig var1);
    }

    public static interface NetworkInfoListener {
        public void onNetworkInfoAvailable(NetworkInfo var1);
    }

    public static interface DiscoveryStateListener {
        public void onDiscoveryStateAvailable(int var1);
    }

    public static interface P2pStateListener {
        public void onP2pStateAvailable(int var1);
    }

    public static interface HandoverMessageListener {
        public void onHandoverMessageAvailable(String var1);
    }

    @SystemApi
    public static interface PersistentGroupInfoListener {
        public void onPersistentGroupInfoAvailable(WifiP2pGroupList var1);
    }

    public static interface UpnpServiceResponseListener {
        public void onUpnpServiceAvailable(List<String> var1, WifiP2pDevice var2);
    }

    public static interface DnsSdTxtRecordListener {
        public void onDnsSdTxtRecordAvailable(String var1, Map<String, String> var2, WifiP2pDevice var3);
    }

    public static interface DnsSdServiceResponseListener {
        public void onDnsSdServiceAvailable(String var1, String var2, WifiP2pDevice var3);
    }

    public static interface ServiceResponseListener {
        public void onServiceAvailable(int var1, byte[] var2, WifiP2pDevice var3);
    }

    public static interface GroupInfoListener {
        public void onGroupInfoAvailable(WifiP2pGroup var1);
    }

    public static interface ConnectionInfoListener {
        public void onConnectionInfoAvailable(WifiP2pInfo var1);
    }

    public static interface PeerListListener {
        public void onPeersAvailable(WifiP2pDeviceList var1);
    }

    public static interface ActionListener {
        public void onSuccess();

        public void onFailure(int var1);
    }

    public static interface ChannelListener {
        public void onChannelDisconnected();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiP2pDiscoveryState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiP2pState {
    }
}

