/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.net.wifi.nl80211.ChannelSettings;
import android.net.wifi.nl80211.HiddenNetwork;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import java.util.Objects;

public class SingleScanSettings
implements Parcelable {
    private static final String TAG = "SingleScanSettings";
    public int scanType;
    public ArrayList<ChannelSettings> channelSettings;
    public ArrayList<HiddenNetwork> hiddenNetworks;
    public static final Parcelable.Creator<SingleScanSettings> CREATOR = new Parcelable.Creator<SingleScanSettings>(){

        @Override
        public SingleScanSettings createFromParcel(Parcel in) {
            SingleScanSettings result = new SingleScanSettings();
            result.scanType = in.readInt();
            if (!SingleScanSettings.isValidScanType(result.scanType)) {
                Log.wtf(SingleScanSettings.TAG, "Invalid scan type " + result.scanType);
            }
            result.channelSettings = new ArrayList();
            in.readTypedList(result.channelSettings, ChannelSettings.CREATOR);
            result.hiddenNetworks = new ArrayList();
            in.readTypedList(result.hiddenNetworks, HiddenNetwork.CREATOR);
            if (in.dataAvail() != 0) {
                Log.e(SingleScanSettings.TAG, "Found trailing data after parcel parsing.");
            }
            return result;
        }

        public SingleScanSettings[] newArray(int size) {
            return new SingleScanSettings[size];
        }
    };

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (!(rhs instanceof SingleScanSettings)) {
            return false;
        }
        SingleScanSettings settings = (SingleScanSettings)rhs;
        if (settings == null) {
            return false;
        }
        return this.scanType == settings.scanType && this.channelSettings.equals(settings.channelSettings) && this.hiddenNetworks.equals(settings.hiddenNetworks);
    }

    public int hashCode() {
        return Objects.hash(this.scanType, this.channelSettings, this.hiddenNetworks);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static boolean isValidScanType(int scanType) {
        return scanType == 0 || scanType == 1 || scanType == 2;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        if (!SingleScanSettings.isValidScanType(this.scanType)) {
            Log.wtf(TAG, "Invalid scan type " + this.scanType);
        }
        out.writeInt(this.scanType);
        out.writeTypedList(this.channelSettings);
        out.writeTypedList(this.hiddenNetworks);
    }
}

