/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.wifi.ParcelUtil;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WifiEnterpriseConfig
implements Parcelable {
    public static final String WAPI_AS_CERTIFICATE = "WAPIAS_";
    public static final String WAPI_USER_CERTIFICATE = "WAPIUSR_";
    public static final String EXTRA_WAPI_AS_CERTIFICATE_NAME = "android.net.wifi.extra.WAPI_AS_CERTIFICATE_NAME";
    public static final String EXTRA_WAPI_AS_CERTIFICATE_DATA = "android.net.wifi.extra.WAPI_AS_CERTIFICATE_DATA";
    public static final String EXTRA_WAPI_USER_CERTIFICATE_NAME = "android.net.wifi.extra.WAPI_USER_CERTIFICATE_NAME";
    public static final String EXTRA_WAPI_USER_CERTIFICATE_DATA = "android.net.wifi.extra.WAPI_USER_CERTIFICATE_DATA";
    public static final String EMPTY_VALUE = "NULL";
    public static final String EAP_KEY = "eap";
    public static final String PHASE2_KEY = "phase2";
    public static final String IDENTITY_KEY = "identity";
    public static final String ANON_IDENTITY_KEY = "anonymous_identity";
    public static final String PASSWORD_KEY = "password";
    public static final String SUBJECT_MATCH_KEY = "subject_match";
    public static final String ALTSUBJECT_MATCH_KEY = "altsubject_match";
    public static final String DOM_SUFFIX_MATCH_KEY = "domain_suffix_match";
    public static final String OPP_KEY_CACHING = "proactive_key_caching";
    public static final String EAP_ERP = "eap_erp";
    public static final String OCSP = "ocsp";
    public static final String ENGINE_ID_KEYSTORE = "keystore";
    public static final String KEYSTORE_URI = "keystore://";
    public static final String KEYSTORES_URI = "keystores://";
    public static final String ENGINE_ENABLE = "1";
    public static final String ENGINE_DISABLE = "0";
    private static final String CA_CERTIFICATE = "CACERT_";
    private static final String USER_CERTIFICATE = "USRCERT_";
    private static final String USER_PRIVATE_KEY = "USRPKEY_";
    public static final String CA_CERT_PREFIX = "keystore://CACERT_";
    public static final String CLIENT_CERT_PREFIX = "keystore://USRCERT_";
    public static final String CLIENT_CERT_KEY = "client_cert";
    public static final String CA_CERT_KEY = "ca_cert";
    public static final String CA_PATH_KEY = "ca_path";
    public static final String ENGINE_KEY = "engine";
    public static final String ENGINE_ID_KEY = "engine_id";
    public static final String PRIVATE_KEY_ID_KEY = "key_id";
    public static final String REALM_KEY = "realm";
    public static final String PLMN_KEY = "plmn";
    public static final String CA_CERT_ALIAS_DELIMITER = " ";
    public static final String WAPI_CERT_SUITE_KEY = "wapi_cert_suite";
    @SystemApi
    public static final int OCSP_NONE = 0;
    @SystemApi
    public static final int OCSP_REQUEST_CERT_STATUS = 1;
    @SystemApi
    public static final int OCSP_REQUIRE_CERT_STATUS = 2;
    @SystemApi
    public static final int OCSP_REQUIRE_ALL_NON_TRUSTED_CERTS_STATUS = 3;
    private int mOcsp = 0;
    private static final String[] SUPPLICANT_CONFIG_KEYS = new String[]{"identity", "anonymous_identity", "password", "client_cert", "ca_cert", "subject_match", "engine", "engine_id", "key_id", "altsubject_match", "domain_suffix_match", "ca_path"};
    private static final List<String> UNQUOTED_KEYS = Arrays.asList("engine", "proactive_key_caching", "eap_erp");
    @UnsupportedAppUsage
    private HashMap<String, String> mFields = new HashMap();
    private X509Certificate[] mCaCerts;
    private PrivateKey mClientPrivateKey;
    private X509Certificate[] mClientCertificateChain;
    private int mEapMethod = -1;
    private int mPhase2Method = 0;
    private boolean mIsAppInstalledDeviceKeyAndCert = false;
    private boolean mIsAppInstalledCaCert = false;
    private static final String TAG = "WifiEnterpriseConfig";
    public static final Parcelable.Creator<WifiEnterpriseConfig> CREATOR = new Parcelable.Creator<WifiEnterpriseConfig>(){

        @Override
        public WifiEnterpriseConfig createFromParcel(Parcel in) {
            WifiEnterpriseConfig enterpriseConfig = new WifiEnterpriseConfig();
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                String key = in.readString();
                String value = in.readString();
                enterpriseConfig.mFields.put(key, value);
            }
            enterpriseConfig.mEapMethod = in.readInt();
            enterpriseConfig.mPhase2Method = in.readInt();
            WifiEnterpriseConfig.access$302(enterpriseConfig, ParcelUtil.readCertificates(in));
            enterpriseConfig.mClientPrivateKey = ParcelUtil.readPrivateKey(in);
            WifiEnterpriseConfig.access$502(enterpriseConfig, ParcelUtil.readCertificates(in));
            enterpriseConfig.mIsAppInstalledDeviceKeyAndCert = in.readBoolean();
            enterpriseConfig.mIsAppInstalledCaCert = in.readBoolean();
            enterpriseConfig.mOcsp = in.readInt();
            return enterpriseConfig;
        }

        public WifiEnterpriseConfig[] newArray(int size) {
            return new WifiEnterpriseConfig[size];
        }
    };

    public WifiEnterpriseConfig() {
    }

    private void copyFrom(WifiEnterpriseConfig source, boolean ignoreMaskedPassword, String mask) {
        for (String key : source.mFields.keySet()) {
            if (ignoreMaskedPassword && key.equals(PASSWORD_KEY) && TextUtils.equals(source.mFields.get(key), mask)) continue;
            this.mFields.put(key, source.mFields.get(key));
        }
        this.mCaCerts = source.mCaCerts != null ? Arrays.copyOf(source.mCaCerts, source.mCaCerts.length) : null;
        this.mClientPrivateKey = source.mClientPrivateKey;
        this.mClientCertificateChain = source.mClientCertificateChain != null ? Arrays.copyOf(source.mClientCertificateChain, source.mClientCertificateChain.length) : null;
        this.mEapMethod = source.mEapMethod;
        this.mPhase2Method = source.mPhase2Method;
        this.mIsAppInstalledDeviceKeyAndCert = source.mIsAppInstalledDeviceKeyAndCert;
        this.mIsAppInstalledCaCert = source.mIsAppInstalledCaCert;
        this.mOcsp = source.mOcsp;
    }

    public WifiEnterpriseConfig(WifiEnterpriseConfig source) {
        this.copyFrom(source, false, "");
    }

    public void copyFromExternal(WifiEnterpriseConfig externalConfig, String mask) {
        this.copyFrom(externalConfig, true, this.convertToQuotedString(mask));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mFields.size());
        for (Map.Entry<String, String> entry : this.mFields.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
        dest.writeInt(this.mEapMethod);
        dest.writeInt(this.mPhase2Method);
        ParcelUtil.writeCertificates(dest, this.mCaCerts);
        ParcelUtil.writePrivateKey(dest, this.mClientPrivateKey);
        ParcelUtil.writeCertificates(dest, this.mClientCertificateChain);
        dest.writeBoolean(this.mIsAppInstalledDeviceKeyAndCert);
        dest.writeBoolean(this.mIsAppInstalledCaCert);
        dest.writeInt(this.mOcsp);
    }

    public boolean saveToSupplicant(SupplicantSaver saver) {
        if (!this.isEapMethodValid()) {
            return false;
        }
        boolean shouldNotWriteAnonIdentity = this.mEapMethod == 4 || this.mEapMethod == 5 || this.mEapMethod == 6;
        for (String key : this.mFields.keySet()) {
            if (shouldNotWriteAnonIdentity && ANON_IDENTITY_KEY.equals(key) || saver.saveValue(key, this.mFields.get(key))) continue;
            return false;
        }
        if (!saver.saveValue(EAP_KEY, Eap.strings[this.mEapMethod])) {
            return false;
        }
        if (this.mEapMethod != 1 && this.mEapMethod != 7 && this.mPhase2Method != 0) {
            boolean is_autheap = this.mEapMethod == 2 && this.mPhase2Method == 4;
            String prefix = is_autheap ? "autheap=" : "auth=";
            String value = this.convertToQuotedString(prefix + Phase2.strings[this.mPhase2Method]);
            return saver.saveValue(PHASE2_KEY, value);
        }
        if (this.mPhase2Method == 0) {
            return saver.saveValue(PHASE2_KEY, null);
        }
        Log.e(TAG, "WiFi enterprise configuration is invalid as it supplies a phase 2 method but the phase1 method does not support it.");
        return false;
    }

    public void loadFromSupplicant(SupplicantLoader loader) {
        for (String key : SUPPLICANT_CONFIG_KEYS) {
            String value = loader.loadValue(key);
            if (value == null) {
                this.mFields.put(key, EMPTY_VALUE);
                continue;
            }
            this.mFields.put(key, value);
        }
        String eapMethod = loader.loadValue(EAP_KEY);
        this.mEapMethod = this.getStringIndex(Eap.strings, eapMethod, -1);
        String phase2Method = this.removeDoubleQuotes(loader.loadValue(PHASE2_KEY));
        if (phase2Method.startsWith("auth=")) {
            phase2Method = phase2Method.substring("auth=".length());
        } else if (phase2Method.startsWith("autheap=")) {
            phase2Method = phase2Method.substring("autheap=".length());
        }
        this.mPhase2Method = this.getStringIndex(Phase2.strings, phase2Method, 0);
    }

    public void setEapMethod(int eapMethod) {
        switch (eapMethod) {
            case 8: {
                this.mEapMethod = eapMethod;
                this.setPhase2Method(0);
                break;
            }
            case 1: 
            case 7: {
                this.setPhase2Method(0);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.mEapMethod = eapMethod;
                this.setFieldValue(OPP_KEY_CACHING, ENGINE_ENABLE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EAP method");
            }
        }
    }

    public int getEapMethod() {
        return this.mEapMethod;
    }

    public void setPhase2Method(int phase2Method) {
        switch (phase2Method) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.mPhase2Method = phase2Method;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Phase 2 method");
            }
        }
    }

    public int getPhase2Method() {
        return this.mPhase2Method;
    }

    public void setIdentity(String identity) {
        this.setFieldValue(IDENTITY_KEY, identity, "");
    }

    public String getIdentity() {
        return this.getFieldValue(IDENTITY_KEY);
    }

    public void setAnonymousIdentity(String anonymousIdentity) {
        this.setFieldValue(ANON_IDENTITY_KEY, anonymousIdentity);
    }

    public String getAnonymousIdentity() {
        return this.getFieldValue(ANON_IDENTITY_KEY);
    }

    public void setPassword(String password) {
        this.setFieldValue(PASSWORD_KEY, password);
    }

    public String getPassword() {
        return this.getFieldValue(PASSWORD_KEY);
    }

    public static String encodeCaCertificateAlias(String alias) {
        byte[] bytes = alias.getBytes(StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte o : bytes) {
            sb.append(String.format("%02x", o & 0xFF));
        }
        return sb.toString();
    }

    public static String decodeCaCertificateAlias(String alias) {
        byte[] data = new byte[alias.length() >> 1];
        int n = 0;
        int position = 0;
        while (n < alias.length()) {
            data[position] = (byte)Integer.parseInt(alias.substring(n, n + 2), 16);
            n += 2;
            ++position;
        }
        try {
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return alias;
        }
    }

    @UnsupportedAppUsage
    public void setCaCertificateAlias(String alias) {
        this.setFieldValue(CA_CERT_KEY, alias, CA_CERT_PREFIX);
    }

    @SystemApi
    public void setCaCertificateAliases(String[] aliases) {
        if (aliases == null) {
            this.setFieldValue(CA_CERT_KEY, null, CA_CERT_PREFIX);
        } else if (aliases.length == 1) {
            this.setCaCertificateAlias(aliases[0]);
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < aliases.length; ++i) {
                if (i > 0) {
                    sb.append(CA_CERT_ALIAS_DELIMITER);
                }
                sb.append(WifiEnterpriseConfig.encodeCaCertificateAlias(CA_CERTIFICATE + aliases[i]));
            }
            this.setFieldValue(CA_CERT_KEY, sb.toString(), KEYSTORES_URI);
        }
    }

    @UnsupportedAppUsage
    public String getCaCertificateAlias() {
        return this.getFieldValue(CA_CERT_KEY, CA_CERT_PREFIX);
    }

    @SystemApi
    public String[] getCaCertificateAliases() {
        String[] stringArray;
        String value = this.getFieldValue(CA_CERT_KEY);
        if (value.startsWith(CA_CERT_PREFIX)) {
            return new String[]{this.getFieldValue(CA_CERT_KEY, CA_CERT_PREFIX)};
        }
        if (value.startsWith(KEYSTORES_URI)) {
            String values = value.substring(KEYSTORES_URI.length());
            String[] aliases = TextUtils.split(values, CA_CERT_ALIAS_DELIMITER);
            for (int i = 0; i < aliases.length; ++i) {
                aliases[i] = WifiEnterpriseConfig.decodeCaCertificateAlias(aliases[i]);
                if (!aliases[i].startsWith(CA_CERTIFICATE)) continue;
                aliases[i] = aliases[i].substring(CA_CERTIFICATE.length());
            }
            return aliases.length != 0 ? aliases : null;
        }
        if (TextUtils.isEmpty(value)) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCaCertificate(X509Certificate cert) {
        if (cert == null) {
            this.mCaCerts = null;
            return;
        }
        if (cert.getBasicConstraints() >= 0) {
            this.mIsAppInstalledCaCert = true;
            this.mCaCerts = new X509Certificate[]{cert};
            return;
        }
        this.mCaCerts = null;
        throw new IllegalArgumentException("Not a CA certificate");
    }

    public X509Certificate getCaCertificate() {
        if (this.mCaCerts != null && this.mCaCerts.length > 0) {
            return this.mCaCerts[0];
        }
        return null;
    }

    public void setCaCertificates(X509Certificate[] certs) {
        if (certs != null) {
            X509Certificate[] newCerts = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                if (certs[i].getBasicConstraints() < 0) {
                    this.mCaCerts = null;
                    throw new IllegalArgumentException("Not a CA certificate");
                }
                newCerts[i] = certs[i];
            }
            this.mCaCerts = newCerts;
            this.mIsAppInstalledCaCert = true;
        } else {
            this.mCaCerts = null;
        }
    }

    public X509Certificate[] getCaCertificates() {
        if (this.mCaCerts != null && this.mCaCerts.length > 0) {
            return this.mCaCerts;
        }
        return null;
    }

    public void resetCaCertificate() {
        this.mCaCerts = null;
    }

    @SystemApi
    public void setCaPath(String path) {
        this.setFieldValue(CA_PATH_KEY, path);
    }

    @SystemApi
    public String getCaPath() {
        return this.getFieldValue(CA_PATH_KEY);
    }

    @SystemApi
    public void setClientCertificateAlias(String alias) {
        this.setFieldValue(CLIENT_CERT_KEY, alias, CLIENT_CERT_PREFIX);
        this.setFieldValue(PRIVATE_KEY_ID_KEY, alias, USER_PRIVATE_KEY);
        if (TextUtils.isEmpty(alias)) {
            this.setFieldValue(ENGINE_KEY, ENGINE_DISABLE);
            this.setFieldValue(ENGINE_ID_KEY, "");
        } else {
            this.setFieldValue(ENGINE_KEY, ENGINE_ENABLE);
            this.setFieldValue(ENGINE_ID_KEY, ENGINE_ID_KEYSTORE);
        }
    }

    @SystemApi
    public String getClientCertificateAlias() {
        return this.getFieldValue(CLIENT_CERT_KEY, CLIENT_CERT_PREFIX);
    }

    public void setClientKeyEntry(PrivateKey privateKey, X509Certificate clientCertificate) {
        X509Certificate[] clientCertificates = null;
        if (clientCertificate != null) {
            clientCertificates = new X509Certificate[]{clientCertificate};
        }
        this.setClientKeyEntryWithCertificateChain(privateKey, clientCertificates);
    }

    public void setClientKeyEntryWithCertificateChain(PrivateKey privateKey, X509Certificate[] clientCertificateChain) {
        X509Certificate[] newCerts = null;
        if (clientCertificateChain != null && clientCertificateChain.length > 0) {
            if (clientCertificateChain[0].getBasicConstraints() != -1) {
                throw new IllegalArgumentException("First certificate in the chain must be a client end certificate");
            }
            for (int i = 1; i < clientCertificateChain.length; ++i) {
                if (clientCertificateChain[i].getBasicConstraints() != -1) continue;
                throw new IllegalArgumentException("All certificates following the first must be CA certificates");
            }
            newCerts = Arrays.copyOf(clientCertificateChain, clientCertificateChain.length);
            if (privateKey == null) {
                throw new IllegalArgumentException("Client cert without a private key");
            }
            if (privateKey.getEncoded() == null) {
                throw new IllegalArgumentException("Private key cannot be encoded");
            }
        }
        this.mClientPrivateKey = privateKey;
        this.mClientCertificateChain = newCerts;
        this.mIsAppInstalledDeviceKeyAndCert = true;
    }

    public X509Certificate getClientCertificate() {
        if (this.mClientCertificateChain != null && this.mClientCertificateChain.length > 0) {
            return this.mClientCertificateChain[0];
        }
        return null;
    }

    public X509Certificate[] getClientCertificateChain() {
        if (this.mClientCertificateChain != null && this.mClientCertificateChain.length > 0) {
            return this.mClientCertificateChain;
        }
        return null;
    }

    public void resetClientKeyEntry() {
        this.mClientPrivateKey = null;
        this.mClientCertificateChain = null;
    }

    public PrivateKey getClientPrivateKey() {
        return this.mClientPrivateKey;
    }

    public void setSubjectMatch(String subjectMatch) {
        this.setFieldValue(SUBJECT_MATCH_KEY, subjectMatch);
    }

    public String getSubjectMatch() {
        return this.getFieldValue(SUBJECT_MATCH_KEY);
    }

    public void setAltSubjectMatch(String altSubjectMatch) {
        this.setFieldValue(ALTSUBJECT_MATCH_KEY, altSubjectMatch);
    }

    public String getAltSubjectMatch() {
        return this.getFieldValue(ALTSUBJECT_MATCH_KEY);
    }

    public void setDomainSuffixMatch(String domain) {
        this.setFieldValue(DOM_SUFFIX_MATCH_KEY, domain);
    }

    public String getDomainSuffixMatch() {
        return this.getFieldValue(DOM_SUFFIX_MATCH_KEY);
    }

    public void setRealm(String realm) {
        this.setFieldValue(REALM_KEY, realm);
    }

    public String getRealm() {
        return this.getFieldValue(REALM_KEY);
    }

    public void setPlmn(String plmn) {
        this.setFieldValue(PLMN_KEY, plmn);
    }

    public String getPlmn() {
        return this.getFieldValue(PLMN_KEY);
    }

    public String getKeyId(WifiEnterpriseConfig current) {
        if (this.mEapMethod == -1) {
            return current != null ? current.getKeyId(null) : EMPTY_VALUE;
        }
        if (!this.isEapMethodValid()) {
            return EMPTY_VALUE;
        }
        return Eap.strings[this.mEapMethod] + "_" + Phase2.strings[this.mPhase2Method];
    }

    private String removeDoubleQuotes(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        int length = string2.length();
        if (length > 1 && string2.charAt(0) == '\"' && string2.charAt(length - 1) == '\"') {
            return string2.substring(1, length - 1);
        }
        return string2;
    }

    private String convertToQuotedString(String string2) {
        return "\"" + string2 + "\"";
    }

    private int getStringIndex(String[] arr, String toBeFound, int defaultIndex) {
        if (TextUtils.isEmpty(toBeFound)) {
            return defaultIndex;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (!toBeFound.equals(arr[i])) continue;
            return i;
        }
        return defaultIndex;
    }

    private String getFieldValue(String key, String prefix) {
        String value = this.mFields.get(key);
        if (TextUtils.isEmpty(value) || EMPTY_VALUE.equals(value)) {
            return "";
        }
        if ((value = this.removeDoubleQuotes(value)).startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public String getFieldValue(String key) {
        return this.getFieldValue(key, "");
    }

    private void setFieldValue(String key, String value, String prefix) {
        if (TextUtils.isEmpty(value)) {
            this.mFields.put(key, EMPTY_VALUE);
        } else {
            String valueToSet = !UNQUOTED_KEYS.contains(key) ? this.convertToQuotedString(prefix + value) : prefix + value;
            this.mFields.put(key, valueToSet);
        }
    }

    public void setFieldValue(String key, String value) {
        this.setFieldValue(key, value, "");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String key : this.mFields.keySet()) {
            String value = PASSWORD_KEY.equals(key) ? "<removed>" : this.mFields.get(key);
            sb.append(key).append(CA_CERT_ALIAS_DELIMITER).append(value).append("\n");
        }
        if (this.mEapMethod >= 0 && this.mEapMethod < Eap.strings.length) {
            sb.append("eap_method: ").append(Eap.strings[this.mEapMethod]).append("\n");
        }
        if (this.mPhase2Method > 0 && this.mPhase2Method < Phase2.strings.length) {
            sb.append("phase2_method: ").append(Phase2.strings[this.mPhase2Method]).append("\n");
        }
        sb.append(" ocsp: ").append(this.mOcsp).append("\n");
        return sb.toString();
    }

    private boolean isEapMethodValid() {
        if (this.mEapMethod == -1) {
            Log.e(TAG, "WiFi enterprise configuration is invalid as it supplies no EAP method.");
            return false;
        }
        if (this.mEapMethod < 0 || this.mEapMethod >= Eap.strings.length) {
            Log.e(TAG, "mEapMethod is invald for WiFi enterprise configuration: " + this.mEapMethod);
            return false;
        }
        if (this.mPhase2Method < 0 || this.mPhase2Method >= Phase2.strings.length) {
            Log.e(TAG, "mPhase2Method is invald for WiFi enterprise configuration: " + this.mPhase2Method);
            return false;
        }
        return true;
    }

    public boolean isAppInstalledDeviceKeyAndCert() {
        return this.mIsAppInstalledDeviceKeyAndCert;
    }

    public boolean isAppInstalledCaCert() {
        return this.mIsAppInstalledCaCert;
    }

    @SystemApi
    public void setOcsp(int ocsp) {
        if (ocsp < 0 || ocsp > 3) {
            throw new IllegalArgumentException("Invalid OCSP type.");
        }
        this.mOcsp = ocsp;
    }

    @SystemApi
    public int getOcsp() {
        return this.mOcsp;
    }

    public boolean isAuthenticationSimBased() {
        if (this.mEapMethod == 4 || this.mEapMethod == 5 || this.mEapMethod == 6) {
            return true;
        }
        if (this.mEapMethod == 0) {
            return this.mPhase2Method == 5 || this.mPhase2Method == 6 || this.mPhase2Method == 7;
        }
        return false;
    }

    @SystemApi
    public void setWapiCertSuite(String wapiCertSuite) {
        this.setFieldValue(WAPI_CERT_SUITE_KEY, wapiCertSuite);
    }

    @SystemApi
    public String getWapiCertSuite() {
        return this.getFieldValue(WAPI_CERT_SUITE_KEY);
    }

    public boolean isInsecure() {
        if (this.mEapMethod != 0 && this.mEapMethod != 1 && this.mEapMethod != 2) {
            return false;
        }
        if (TextUtils.isEmpty(this.getAltSubjectMatch()) && TextUtils.isEmpty(this.getDomainSuffixMatch())) {
            return true;
        }
        if (this.mIsAppInstalledCaCert) {
            return false;
        }
        if (this.getCaCertificateAliases() != null) {
            return false;
        }
        return TextUtils.isEmpty(this.getCaPath());
    }

    static /* synthetic */ X509Certificate[] access$302(WifiEnterpriseConfig x0, X509Certificate[] x1) {
        x0.mCaCerts = x1;
        return x1;
    }

    static /* synthetic */ X509Certificate[] access$502(WifiEnterpriseConfig x0, X509Certificate[] x1) {
        x0.mClientCertificateChain = x1;
        return x1;
    }

    public static interface SupplicantLoader {
        public String loadValue(String var1);
    }

    public static interface SupplicantSaver {
        public boolean saveValue(String var1, String var2);
    }

    public static class Phase2 {
        public static final int NONE = 0;
        public static final int PAP = 1;
        public static final int MSCHAP = 2;
        public static final int MSCHAPV2 = 3;
        public static final int GTC = 4;
        public static final int SIM = 5;
        public static final int AKA = 6;
        public static final int AKA_PRIME = 7;
        private static final String AUTH_PREFIX = "auth=";
        private static final String AUTHEAP_PREFIX = "autheap=";
        public static final String[] strings = new String[]{"NULL", "PAP", "MSCHAP", "MSCHAPV2", "GTC", "SIM", "AKA", "AKA'"};

        private Phase2() {
        }
    }

    public static class Eap {
        public static final int NONE = -1;
        public static final int PEAP = 0;
        public static final int TLS = 1;
        public static final int TTLS = 2;
        public static final int PWD = 3;
        public static final int SIM = 4;
        public static final int AKA = 5;
        public static final int AKA_PRIME = 6;
        public static final int UNAUTH_TLS = 7;
        public static final int WAPI_CERT = 8;
        public static final String[] strings = new String[]{"PEAP", "TLS", "TTLS", "PWD", "SIM", "AKA", "AKA'", "WFA-UNAUTH-TLS", "WAPI_CERT"};

        private Eap() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Ocsp {
    }
}

