/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.app.PendingIntent;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.session.MediaSession;
import android.media.session.MediaSessionManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.ArrayMap;
import android.util.Log;
import android.view.KeyEvent;

public class MediaSessionLegacyHelper {
    private static final String TAG = "MediaSessionHelper";
    private static final boolean DEBUG = Log.isLoggable("MediaSessionHelper", 3);
    private static final Object sLock = new Object();
    private static MediaSessionLegacyHelper sInstance;
    private Context mContext;
    private MediaSessionManager mSessionManager;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private ArrayMap<PendingIntent, SessionHolder> mSessions = new ArrayMap();

    private MediaSessionLegacyHelper(Context context) {
        this.mContext = context;
        this.mSessionManager = (MediaSessionManager)context.getSystemService("media_session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static MediaSessionLegacyHelper getHelper(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new MediaSessionLegacyHelper(context.getApplicationContext());
            }
        }
        return sInstance;
    }

    public static Bundle getOldMetadata(MediaMetadata metadata, int artworkWidth, int artworkHeight) {
        boolean includeArtwork = artworkWidth != -1 && artworkHeight != -1;
        Bundle oldMetadata = new Bundle();
        if (metadata.containsKey("android.media.metadata.ALBUM")) {
            oldMetadata.putString(String.valueOf(1), metadata.getString("android.media.metadata.ALBUM"));
        }
        if (includeArtwork && metadata.containsKey("android.media.metadata.ART")) {
            Bitmap art = metadata.getBitmap("android.media.metadata.ART");
            oldMetadata.putParcelable(String.valueOf(100), MediaSessionLegacyHelper.scaleBitmapIfTooBig(art, artworkWidth, artworkHeight));
        } else if (includeArtwork && metadata.containsKey("android.media.metadata.ALBUM_ART")) {
            Bitmap art = metadata.getBitmap("android.media.metadata.ALBUM_ART");
            oldMetadata.putParcelable(String.valueOf(100), MediaSessionLegacyHelper.scaleBitmapIfTooBig(art, artworkWidth, artworkHeight));
        }
        if (metadata.containsKey("android.media.metadata.ALBUM_ARTIST")) {
            oldMetadata.putString(String.valueOf(13), metadata.getString("android.media.metadata.ALBUM_ARTIST"));
        }
        if (metadata.containsKey("android.media.metadata.ARTIST")) {
            oldMetadata.putString(String.valueOf(2), metadata.getString("android.media.metadata.ARTIST"));
        }
        if (metadata.containsKey("android.media.metadata.AUTHOR")) {
            oldMetadata.putString(String.valueOf(3), metadata.getString("android.media.metadata.AUTHOR"));
        }
        if (metadata.containsKey("android.media.metadata.COMPILATION")) {
            oldMetadata.putString(String.valueOf(15), metadata.getString("android.media.metadata.COMPILATION"));
        }
        if (metadata.containsKey("android.media.metadata.COMPOSER")) {
            oldMetadata.putString(String.valueOf(4), metadata.getString("android.media.metadata.COMPOSER"));
        }
        if (metadata.containsKey("android.media.metadata.DATE")) {
            oldMetadata.putString(String.valueOf(5), metadata.getString("android.media.metadata.DATE"));
        }
        if (metadata.containsKey("android.media.metadata.DISC_NUMBER")) {
            oldMetadata.putLong(String.valueOf(14), metadata.getLong("android.media.metadata.DISC_NUMBER"));
        }
        if (metadata.containsKey("android.media.metadata.DURATION")) {
            oldMetadata.putLong(String.valueOf(9), metadata.getLong("android.media.metadata.DURATION"));
        }
        if (metadata.containsKey("android.media.metadata.GENRE")) {
            oldMetadata.putString(String.valueOf(6), metadata.getString("android.media.metadata.GENRE"));
        }
        if (metadata.containsKey("android.media.metadata.NUM_TRACKS")) {
            oldMetadata.putLong(String.valueOf(10), metadata.getLong("android.media.metadata.NUM_TRACKS"));
        }
        if (metadata.containsKey("android.media.metadata.RATING")) {
            oldMetadata.putParcelable(String.valueOf(101), metadata.getRating("android.media.metadata.RATING"));
        }
        if (metadata.containsKey("android.media.metadata.USER_RATING")) {
            oldMetadata.putParcelable(String.valueOf(0x10000001), metadata.getRating("android.media.metadata.USER_RATING"));
        }
        if (metadata.containsKey("android.media.metadata.TITLE")) {
            oldMetadata.putString(String.valueOf(7), metadata.getString("android.media.metadata.TITLE"));
        }
        if (metadata.containsKey("android.media.metadata.TRACK_NUMBER")) {
            oldMetadata.putLong(String.valueOf(0), metadata.getLong("android.media.metadata.TRACK_NUMBER"));
        }
        if (metadata.containsKey("android.media.metadata.WRITER")) {
            oldMetadata.putString(String.valueOf(11), metadata.getString("android.media.metadata.WRITER"));
        }
        if (metadata.containsKey("android.media.metadata.YEAR")) {
            oldMetadata.putLong(String.valueOf(8), metadata.getLong("android.media.metadata.YEAR"));
        }
        return oldMetadata;
    }

    public MediaSession getSession(PendingIntent pi) {
        SessionHolder holder = this.mSessions.get(pi);
        return holder == null ? null : holder.mSession;
    }

    public void sendMediaButtonEvent(KeyEvent keyEvent, boolean needWakeLock) {
        if (keyEvent == null) {
            Log.w(TAG, "Tried to send a null key event. Ignoring.");
            return;
        }
        this.mSessionManager.dispatchMediaKeyEvent(keyEvent, needWakeLock);
        if (DEBUG) {
            Log.d(TAG, "dispatched media key " + keyEvent);
        }
    }

    public void sendVolumeKeyEvent(KeyEvent keyEvent, int stream, boolean musicOnly) {
        if (keyEvent == null) {
            Log.w(TAG, "Tried to send a null key event. Ignoring.");
            return;
        }
        this.mSessionManager.dispatchVolumeKeyEvent(keyEvent, stream, musicOnly);
    }

    public void sendAdjustVolumeBy(int suggestedStream, int delta, int flags) {
        this.mSessionManager.dispatchAdjustVolume(suggestedStream, delta, flags);
        if (DEBUG) {
            Log.d(TAG, "dispatched volume adjustment");
        }
    }

    public boolean isGlobalPriorityActive() {
        return this.mSessionManager.isGlobalPriorityActive();
    }

    public void addRccListener(PendingIntent pi, MediaSession.Callback listener) {
        if (pi == null) {
            Log.w(TAG, "Pending intent was null, can't add rcc listener.");
            return;
        }
        SessionHolder holder = this.getHolder(pi, true);
        if (holder == null) {
            return;
        }
        if (holder.mRccListener != null && holder.mRccListener == listener) {
            if (DEBUG) {
                Log.d(TAG, "addRccListener listener already added.");
            }
            return;
        }
        holder.mRccListener = listener;
        holder.mFlags |= 2;
        holder.mSession.setFlags(holder.mFlags);
        holder.update();
        if (DEBUG) {
            Log.d(TAG, "Added rcc listener for " + pi + ".");
        }
    }

    public void removeRccListener(PendingIntent pi) {
        if (pi == null) {
            return;
        }
        SessionHolder holder = this.getHolder(pi, false);
        if (holder != null && holder.mRccListener != null) {
            holder.mRccListener = null;
            holder.mFlags &= 0xFFFFFFFD;
            holder.mSession.setFlags(holder.mFlags);
            holder.update();
            if (DEBUG) {
                Log.d(TAG, "Removed rcc listener for " + pi + ".");
            }
        }
    }

    public void addMediaButtonListener(PendingIntent pi, ComponentName mbrComponent, Context context) {
        if (pi == null) {
            Log.w(TAG, "Pending intent was null, can't addMediaButtonListener.");
            return;
        }
        SessionHolder holder = this.getHolder(pi, true);
        if (holder == null) {
            return;
        }
        if (holder.mMediaButtonListener != null && DEBUG) {
            Log.d(TAG, "addMediaButtonListener already added " + pi);
        }
        holder.mMediaButtonListener = new MediaButtonListener(pi, context);
        holder.mFlags |= 1;
        holder.mSession.setFlags(holder.mFlags);
        holder.mSession.setMediaButtonReceiver(pi);
        holder.update();
        if (DEBUG) {
            Log.d(TAG, "addMediaButtonListener added " + pi);
        }
    }

    public void removeMediaButtonListener(PendingIntent pi) {
        if (pi == null) {
            return;
        }
        SessionHolder holder = this.getHolder(pi, false);
        if (holder != null && holder.mMediaButtonListener != null) {
            holder.mFlags &= 0xFFFFFFFE;
            holder.mSession.setFlags(holder.mFlags);
            holder.mMediaButtonListener = null;
            holder.update();
            if (DEBUG) {
                Log.d(TAG, "removeMediaButtonListener removed " + pi);
            }
        }
    }

    private static Bitmap scaleBitmapIfTooBig(Bitmap bitmap, int maxWidth, int maxHeight) {
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (width > maxWidth || height > maxHeight) {
                float scale = Math.min((float)maxWidth / (float)width, (float)maxHeight / (float)height);
                int newWidth = Math.round(scale * (float)width);
                int newHeight = Math.round(scale * (float)height);
                Bitmap.Config newConfig = bitmap.getConfig();
                if (newConfig == null) {
                    newConfig = Bitmap.Config.ARGB_8888;
                }
                Bitmap outBitmap = Bitmap.createBitmap(newWidth, newHeight, newConfig);
                Canvas canvas = new Canvas(outBitmap);
                Paint paint = new Paint();
                paint.setAntiAlias(true);
                paint.setFilterBitmap(true);
                canvas.drawBitmap(bitmap, null, new RectF(0.0f, 0.0f, outBitmap.getWidth(), outBitmap.getHeight()), paint);
                bitmap = outBitmap;
            }
        }
        return bitmap;
    }

    private SessionHolder getHolder(PendingIntent pi, boolean createIfMissing) {
        SessionHolder holder = this.mSessions.get(pi);
        if (holder == null && createIfMissing) {
            MediaSession session = new MediaSession(this.mContext, "MediaSessionHelper-" + pi.getCreatorPackage());
            session.setActive(true);
            holder = new SessionHolder(session, pi);
            this.mSessions.put(pi, holder);
        }
        return holder;
    }

    private static void sendKeyEvent(PendingIntent pi, Context context, Intent intent) {
        try {
            pi.send(context, 0, intent);
        }
        catch (PendingIntent.CanceledException e) {
            Log.e(TAG, "Error sending media key down event:", e);
            return;
        }
    }

    private class SessionHolder {
        public final MediaSession mSession;
        public final PendingIntent mPi;
        public MediaButtonListener mMediaButtonListener;
        public MediaSession.Callback mRccListener;
        public int mFlags;
        public SessionCallback mCb;

        public SessionHolder(MediaSession session, PendingIntent pi) {
            this.mSession = session;
            this.mPi = pi;
        }

        public void update() {
            if (this.mMediaButtonListener == null && this.mRccListener == null) {
                this.mSession.setCallback(null);
                this.mSession.release();
                this.mCb = null;
                MediaSessionLegacyHelper.this.mSessions.remove(this.mPi);
            } else if (this.mCb == null) {
                this.mCb = new SessionCallback();
                Handler handler = new Handler(Looper.getMainLooper());
                this.mSession.setCallback(this.mCb, handler);
            }
        }

        private class SessionCallback
        extends MediaSession.Callback {
            private SessionCallback() {
            }

            @Override
            public boolean onMediaButtonEvent(Intent mediaButtonIntent) {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onMediaButtonEvent(mediaButtonIntent);
                }
                return true;
            }

            @Override
            public void onPlay() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onPlay();
                }
            }

            @Override
            public void onPause() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onPause();
                }
            }

            @Override
            public void onSkipToNext() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onSkipToNext();
                }
            }

            @Override
            public void onSkipToPrevious() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onSkipToPrevious();
                }
            }

            @Override
            public void onFastForward() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onFastForward();
                }
            }

            @Override
            public void onRewind() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onRewind();
                }
            }

            @Override
            public void onStop() {
                if (SessionHolder.this.mMediaButtonListener != null) {
                    SessionHolder.this.mMediaButtonListener.onStop();
                }
            }

            @Override
            public void onSeekTo(long pos) {
                if (SessionHolder.this.mRccListener != null) {
                    SessionHolder.this.mRccListener.onSeekTo(pos);
                }
            }

            @Override
            public void onSetRating(Rating rating) {
                if (SessionHolder.this.mRccListener != null) {
                    SessionHolder.this.mRccListener.onSetRating(rating);
                }
            }
        }
    }

    private static class MediaButtonListener
    extends MediaSession.Callback {
        private final PendingIntent mPendingIntent;
        private final Context mContext;

        public MediaButtonListener(PendingIntent pi, Context context) {
            this.mPendingIntent = pi;
            this.mContext = context;
        }

        @Override
        public boolean onMediaButtonEvent(Intent mediaButtonIntent) {
            MediaSessionLegacyHelper.sendKeyEvent(this.mPendingIntent, this.mContext, mediaButtonIntent);
            return true;
        }

        @Override
        public void onPlay() {
            this.sendKeyEvent(126);
        }

        @Override
        public void onPause() {
            this.sendKeyEvent(127);
        }

        @Override
        public void onSkipToNext() {
            this.sendKeyEvent(87);
        }

        @Override
        public void onSkipToPrevious() {
            this.sendKeyEvent(88);
        }

        @Override
        public void onFastForward() {
            this.sendKeyEvent(90);
        }

        @Override
        public void onRewind() {
            this.sendKeyEvent(89);
        }

        @Override
        public void onStop() {
            this.sendKeyEvent(86);
        }

        private void sendKeyEvent(int keyCode) {
            KeyEvent ke = new KeyEvent(0, keyCode);
            Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
            intent.addFlags(0x10000000);
            intent.putExtra("android.intent.extra.KEY_EVENT", ke);
            MediaSessionLegacyHelper.sendKeyEvent(this.mPendingIntent, this.mContext, intent);
            ke = new KeyEvent(1, keyCode);
            intent.putExtra("android.intent.extra.KEY_EVENT", ke);
            MediaSessionLegacyHelper.sendKeyEvent(this.mPendingIntent, this.mContext, intent);
            if (DEBUG) {
                Log.d(MediaSessionLegacyHelper.TAG, "Sent " + keyCode + " to pending intent " + this.mPendingIntent);
            }
        }
    }
}

