/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

public class Session2Command
implements Parcelable {
    public static final int COMMAND_CODE_CUSTOM = 0;
    public static final Parcelable.Creator<Session2Command> CREATOR = new Parcelable.Creator<Session2Command>(){

        @Override
        public Session2Command createFromParcel(Parcel in) {
            return new Session2Command(in);
        }

        public Session2Command[] newArray(int size) {
            return new Session2Command[size];
        }
    };
    private final int mCommandCode;
    private final String mCustomAction;
    private final Bundle mCustomExtras;

    public Session2Command(int commandCode) {
        if (commandCode == 0) {
            throw new IllegalArgumentException("commandCode shouldn't be COMMAND_CODE_CUSTOM");
        }
        this.mCommandCode = commandCode;
        this.mCustomAction = null;
        this.mCustomExtras = null;
    }

    public Session2Command(String action, Bundle extras) {
        if (action == null) {
            throw new IllegalArgumentException("action shouldn't be null");
        }
        this.mCommandCode = 0;
        this.mCustomAction = action;
        this.mCustomExtras = extras;
    }

    Session2Command(Parcel in) {
        this.mCommandCode = in.readInt();
        this.mCustomAction = in.readString();
        this.mCustomExtras = in.readBundle();
    }

    public int getCommandCode() {
        return this.mCommandCode;
    }

    public String getCustomAction() {
        return this.mCustomAction;
    }

    public Bundle getCustomExtras() {
        return this.mCustomExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("parcel shouldn't be null");
        }
        dest.writeInt(this.mCommandCode);
        dest.writeString(this.mCustomAction);
        dest.writeBundle(this.mCustomExtras);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Session2Command)) {
            return false;
        }
        Session2Command other = (Session2Command)obj;
        return this.mCommandCode == other.mCommandCode && TextUtils.equals(this.mCustomAction, other.mCustomAction);
    }

    public int hashCode() {
        return Objects.hash(this.mCustomAction, this.mCommandCode);
    }

    public static class Result {
        private final int mResultCode;
        private final Bundle mResultData;
        public static final int RESULT_INFO_SKIPPED = 1;
        public static final int RESULT_SUCCESS = 0;
        public static final int RESULT_ERROR_UNKNOWN_ERROR = -1;

        public Result(int resultCode, Bundle resultData) {
            this.mResultCode = resultCode;
            this.mResultData = resultData;
        }

        public int getResultCode() {
            return this.mResultCode;
        }

        public Bundle getResultData() {
            return this.mResultData;
        }
    }
}

