/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.hardware.cas.V1_0.IDescramblerBase;
import android.media.MediaCas;
import android.media.MediaCasException;
import android.media.MediaCasStateException;
import android.media.MediaCodec;
import android.os.IHwBinder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.nio.ByteBuffer;

public class MediaDescrambler
implements AutoCloseable {
    private static final String TAG = "MediaDescrambler";
    private IDescramblerBase mIDescrambler;
    public static final byte SCRAMBLE_CONTROL_UNSCRAMBLED = 0;
    public static final byte SCRAMBLE_CONTROL_RESERVED = 1;
    public static final byte SCRAMBLE_CONTROL_EVEN_KEY = 2;
    public static final byte SCRAMBLE_CONTROL_ODD_KEY = 3;
    public static final byte SCRAMBLE_FLAG_PES_HEADER = 1;
    private long mNativeContext;

    private void validateInternalStates() {
        if (this.mIDescrambler == null) {
            throw new IllegalStateException();
        }
    }

    private void cleanupAndRethrowIllegalState() {
        this.mIDescrambler = null;
        throw new IllegalStateException();
    }

    public MediaDescrambler(int CA_system_id) throws MediaCasException.UnsupportedCasException {
        block5: {
            try {
                this.mIDescrambler = MediaCas.getService().createDescrambler(CA_system_id);
            }
            catch (Exception e) {
                Log.e(TAG, "Failed to create descrambler: " + e);
                this.mIDescrambler = null;
                return this.mIDescrambler;
            }
            finally {
                if (this.mIDescrambler != null) break block5;
                throw new MediaCasException.UnsupportedCasException("Unsupported CA_system_id " + CA_system_id);
            }
        }
        this.native_setup(this.mIDescrambler.asBinder());
    }

    IHwBinder getBinder() {
        this.validateInternalStates();
        return this.mIDescrambler.asBinder();
    }

    public boolean requiresSecureDecoderComponent(String mime) {
        this.validateInternalStates();
        try {
            return this.mIDescrambler.requiresSecureDecoderComponent(mime);
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
            return true;
        }
    }

    public void setMediaCasSession(MediaCas.Session session) {
        this.validateInternalStates();
        try {
            MediaCasStateException.throwExceptionIfNeeded(this.mIDescrambler.setMediaCasSession(session.mSessionId));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public int descramble(ByteBuffer srcBuf, ByteBuffer dstBuf, MediaCodec.CryptoInfo cryptoInfo) {
        this.validateInternalStates();
        if (cryptoInfo.numSubSamples <= 0) {
            throw new IllegalArgumentException("Invalid CryptoInfo: invalid numSubSamples=" + cryptoInfo.numSubSamples);
        }
        if (cryptoInfo.numBytesOfClearData == null && cryptoInfo.numBytesOfEncryptedData == null) {
            throw new IllegalArgumentException("Invalid CryptoInfo: clearData and encryptedData size arrays are both null!");
        }
        if (cryptoInfo.numBytesOfClearData != null && cryptoInfo.numBytesOfClearData.length < cryptoInfo.numSubSamples) {
            throw new IllegalArgumentException("Invalid CryptoInfo: numBytesOfClearData is too small!");
        }
        if (cryptoInfo.numBytesOfEncryptedData != null && cryptoInfo.numBytesOfEncryptedData.length < cryptoInfo.numSubSamples) {
            throw new IllegalArgumentException("Invalid CryptoInfo: numBytesOfEncryptedData is too small!");
        }
        if (cryptoInfo.key == null || cryptoInfo.key.length != 16) {
            throw new IllegalArgumentException("Invalid CryptoInfo: key array is invalid!");
        }
        try {
            return this.native_descramble(cryptoInfo.key[0], cryptoInfo.key[1], cryptoInfo.numSubSamples, cryptoInfo.numBytesOfClearData, cryptoInfo.numBytesOfEncryptedData, srcBuf, srcBuf.position(), srcBuf.limit(), dstBuf, dstBuf.position(), dstBuf.limit());
        }
        catch (ServiceSpecificException e) {
            MediaCasStateException.throwExceptionIfNeeded(e.errorCode, e.getMessage());
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
        return -1;
    }

    @Override
    public void close() {
        if (this.mIDescrambler != null) {
            try {
                this.mIDescrambler.release();
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mIDescrambler = null;
            }
        }
        this.native_release();
    }

    protected void finalize() {
        this.close();
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaDescrambler#native_init()V", true, null);
    }

    private void native_setup(IHwBinder iHwBinder) {
        OverrideMethod.invokeV("android.media.MediaDescrambler#native_setup(Landroid/os/IHwBinder;)V", true, this);
    }

    private void native_release() {
        OverrideMethod.invokeV("android.media.MediaDescrambler#native_release()V", true, this);
    }

    private int native_descramble(byte by, byte by2, int n, int[] nArray, int[] nArray2, ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) throws RemoteException {
        return OverrideMethod.invokeI("android.media.MediaDescrambler#native_descramble(BBI[I[ILjava/nio/ByteBuffer;IILjava/nio/ByteBuffer;II)I", true, this);
    }

    static {
        System.loadLibrary("media_jni");
        MediaDescrambler.native_init();
    }
}

