/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.content.res.AssetManager;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import libcore.util.NativeAllocationRegistry_Delegate;

public class Font_Builder_Delegate {
    protected static final DelegateManager<Font_Builder_Delegate> sBuilderManager = new DelegateManager<Font_Builder_Delegate>(Font_Builder_Delegate.class);
    private static long sFontFinalizer = -1L;
    protected ByteBuffer mBuffer;
    protected int mWeight;
    protected boolean mItalic;
    protected int mTtcIndex;
    protected String filePath;

    @LayoutlibDelegate
    static long nInitBuilder() {
        return sBuilderManager.addNewDelegate(new Font_Builder_Delegate());
    }

    @LayoutlibDelegate
    static ByteBuffer createBuffer(AssetManager am, String path, boolean isAsset, int cookie) throws IOException {
        try (InputStream assetStream = isAsset ? am.open(path, 3) : am.openNonAsset(cookie, path, 3);){
            int capacity = assetStream.available();
            ByteBuffer buffer = ByteBuffer.allocateDirect(capacity);
            buffer.order(ByteOrder.nativeOrder());
            ReadableByteChannel channel = Channels.newChannel(assetStream);
            channel.read(buffer);
            if (assetStream.read() != -1) {
                throw new IOException("Unable to access full contents of " + path);
            }
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    @LayoutlibDelegate
    static void nAddAxis(long builderPtr, int tag, float value) {
        Bridge.getLog().fidelityWarning("unsupported", "Font$Builder.nAddAxis is not supported.", null, null, null);
    }

    @LayoutlibDelegate
    static long nBuild(long builderPtr, ByteBuffer buffer, String filePath, int weight, boolean italic, int ttcIndex) {
        Font_Builder_Delegate font = sBuilderManager.getDelegate(builderPtr);
        if (font != null) {
            font.mBuffer = buffer;
            font.mWeight = weight;
            font.mItalic = italic;
            font.mTtcIndex = ttcIndex;
            font.filePath = filePath;
        }
        return builderPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nGetReleaseNativeFont() {
        Class<Font_Builder_Delegate> clazz = Font_Builder_Delegate.class;
        synchronized (Font_Builder_Delegate.class) {
            if (sFontFinalizer == -1L) {
                sFontFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sBuilderManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFontFinalizer;
        }
    }
}

