/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Path_Delegate;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Parcel;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class Region_Delegate {
    protected static final DelegateManager<Region_Delegate> sManager = new DelegateManager<Region_Delegate>(Region_Delegate.class);
    private Area mArea = new Area();

    public static Region_Delegate getDelegate(long nativeShader) {
        return sManager.getDelegate(nativeShader);
    }

    public Area getJavaArea() {
        return this.mArea;
    }

    public static Area combineShapes(Shape shape1, Shape shape2, int regionOp) {
        if (regionOp == Region.Op.DIFFERENCE.nativeInt) {
            if (shape1 == null) {
                return null;
            }
            Area result = new Area(shape1);
            result.subtract(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return result;
        }
        if (regionOp == Region.Op.INTERSECT.nativeInt) {
            if (shape1 == null) {
                return new Area(shape2);
            }
            Area result = new Area(shape1);
            result.intersect(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return result;
        }
        if (regionOp == Region.Op.UNION.nativeInt) {
            if (shape1 == null) {
                return new Area(shape2);
            }
            Area result = new Area(shape1);
            result.add(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return result;
        }
        if (regionOp == Region.Op.XOR.nativeInt) {
            if (shape1 == null) {
                return new Area(shape2);
            }
            Area result = new Area(shape1);
            result.exclusiveOr(shape2 instanceof Area ? (Area)shape2 : new Area(shape2));
            return result;
        }
        if (regionOp == Region.Op.REVERSE_DIFFERENCE.nativeInt) {
            Area result = new Area(shape2);
            if (shape1 != null) {
                result.subtract(shape1 instanceof Area ? (Area)shape1 : new Area(shape1));
            }
            return result;
        }
        return null;
    }

    @LayoutlibDelegate
    static boolean isEmpty(Region thisRegion) {
        Region_Delegate regionDelegate = sManager.getDelegate(thisRegion.mNativeRegion);
        if (regionDelegate == null) {
            return true;
        }
        return regionDelegate.mArea.isEmpty();
    }

    @LayoutlibDelegate
    static boolean isRect(Region thisRegion) {
        Region_Delegate regionDelegate = sManager.getDelegate(thisRegion.mNativeRegion);
        if (regionDelegate == null) {
            return true;
        }
        return regionDelegate.mArea.isRectangular();
    }

    @LayoutlibDelegate
    static boolean isComplex(Region thisRegion) {
        Region_Delegate regionDelegate = sManager.getDelegate(thisRegion.mNativeRegion);
        if (regionDelegate == null) {
            return true;
        }
        return !regionDelegate.mArea.isSingular();
    }

    @LayoutlibDelegate
    static boolean contains(Region thisRegion, int x, int y) {
        Region_Delegate regionDelegate = sManager.getDelegate(thisRegion.mNativeRegion);
        if (regionDelegate == null) {
            return false;
        }
        return regionDelegate.mArea.contains(x, y);
    }

    @LayoutlibDelegate
    static boolean quickContains(Region thisRegion, int left, int top, int right, int bottom) {
        Region_Delegate regionDelegate = sManager.getDelegate(thisRegion.mNativeRegion);
        if (regionDelegate == null) {
            return false;
        }
        return regionDelegate.mArea.isRectangular() && regionDelegate.mArea.contains(left, top, right - left, bottom - top);
    }

    @LayoutlibDelegate
    static boolean quickReject(Region thisRegion, int left, int top, int right, int bottom) {
        Region_Delegate regionDelegate = sManager.getDelegate(thisRegion.mNativeRegion);
        if (regionDelegate == null) {
            return false;
        }
        return regionDelegate.mArea.isEmpty() || !regionDelegate.mArea.intersects(left, top, right - left, bottom - top);
    }

    @LayoutlibDelegate
    static boolean quickReject(Region thisRegion, Region rgn) {
        Region_Delegate regionDelegate = sManager.getDelegate(thisRegion.mNativeRegion);
        if (regionDelegate == null) {
            return false;
        }
        Region_Delegate targetRegionDelegate = sManager.getDelegate(rgn.mNativeRegion);
        if (targetRegionDelegate == null) {
            return false;
        }
        return regionDelegate.mArea.isEmpty() || !regionDelegate.mArea.getBounds().intersects(targetRegionDelegate.mArea.getBounds());
    }

    @LayoutlibDelegate
    static void translate(Region thisRegion, int dx, int dy, Region dst) {
        Region_Delegate regionDelegate = sManager.getDelegate(thisRegion.mNativeRegion);
        if (regionDelegate == null) {
            return;
        }
        Region_Delegate targetRegionDelegate = sManager.getDelegate(dst.mNativeRegion);
        if (targetRegionDelegate == null) {
            return;
        }
        if (regionDelegate.mArea.isEmpty()) {
            targetRegionDelegate.mArea = new Area();
        } else {
            targetRegionDelegate.mArea = new Area(regionDelegate.mArea);
            AffineTransform mtx = new AffineTransform();
            mtx.translate(dx, dy);
            targetRegionDelegate.mArea.transform(mtx);
        }
    }

    @LayoutlibDelegate
    static void scale(Region thisRegion, float scale, Region dst) {
        Region_Delegate regionDelegate = sManager.getDelegate(thisRegion.mNativeRegion);
        if (regionDelegate == null) {
            return;
        }
        Region_Delegate targetRegionDelegate = sManager.getDelegate(dst.mNativeRegion);
        if (targetRegionDelegate == null) {
            return;
        }
        if (regionDelegate.mArea.isEmpty()) {
            targetRegionDelegate.mArea = new Area();
        } else {
            targetRegionDelegate.mArea = new Area(regionDelegate.mArea);
            AffineTransform mtx = new AffineTransform();
            mtx.scale(scale, scale);
            targetRegionDelegate.mArea.transform(mtx);
        }
    }

    @LayoutlibDelegate
    static long nativeConstructor() {
        Region_Delegate newDelegate = new Region_Delegate();
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static void nativeDestructor(long native_region) {
        sManager.removeJavaReferenceFor(native_region);
    }

    @LayoutlibDelegate
    static void nativeSetRegion(long native_dst, long native_src) {
        Region_Delegate dstRegion = sManager.getDelegate(native_dst);
        if (dstRegion == null) {
            return;
        }
        Region_Delegate srcRegion = sManager.getDelegate(native_src);
        if (srcRegion == null) {
            return;
        }
        dstRegion.mArea.reset();
        dstRegion.mArea.add(srcRegion.mArea);
    }

    @LayoutlibDelegate
    static boolean nativeSetRect(long native_dst, int left, int top, int right, int bottom) {
        Region_Delegate dstRegion = sManager.getDelegate(native_dst);
        if (dstRegion == null) {
            return true;
        }
        dstRegion.mArea = new Area(new Rectangle2D.Float(left, top, right - left, bottom - top));
        return !dstRegion.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeSetPath(long native_dst, long native_path, long native_clip) {
        Region_Delegate dstRegion = sManager.getDelegate(native_dst);
        if (dstRegion == null) {
            return true;
        }
        Path_Delegate path = Path_Delegate.getDelegate(native_path);
        if (path == null) {
            return true;
        }
        dstRegion.mArea = new Area(path.getJavaShape());
        Region_Delegate clip = sManager.getDelegate(native_clip);
        if (clip != null) {
            dstRegion.mArea.subtract(clip.getJavaArea());
        }
        return !dstRegion.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeGetBounds(long native_region, Rect rect) {
        Region_Delegate region = sManager.getDelegate(native_region);
        if (region == null) {
            return true;
        }
        Rectangle bounds = region.mArea.getBounds();
        if (bounds.isEmpty()) {
            rect.bottom = 0;
            rect.right = 0;
            rect.top = 0;
            rect.left = 0;
            return false;
        }
        rect.left = bounds.x;
        rect.top = bounds.y;
        rect.right = bounds.x + bounds.width;
        rect.bottom = bounds.y + bounds.height;
        return true;
    }

    @LayoutlibDelegate
    static boolean nativeGetBoundaryPath(long native_region, long native_path) {
        Region_Delegate region = sManager.getDelegate(native_region);
        if (region == null) {
            return false;
        }
        Path_Delegate path = Path_Delegate.getDelegate(native_path);
        if (path == null) {
            return false;
        }
        if (region.mArea.isEmpty()) {
            path.reset();
            return false;
        }
        path.setPathIterator(region.mArea.getPathIterator(new AffineTransform()));
        return true;
    }

    @LayoutlibDelegate
    static boolean nativeOp(long native_dst, int left, int top, int right, int bottom, int op) {
        Region_Delegate region = sManager.getDelegate(native_dst);
        if (region == null) {
            return false;
        }
        region.mArea = Region_Delegate.combineShapes(region.mArea, new Rectangle2D.Float(left, top, right - left, bottom - top), op);
        assert (region.mArea != null);
        if (region.mArea != null) {
            region.mArea = new Area();
        }
        return !region.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeOp(long native_dst, Rect rect, long native_region, int op) {
        Region_Delegate region = sManager.getDelegate(native_dst);
        if (region == null) {
            return false;
        }
        region.mArea = Region_Delegate.combineShapes(region.mArea, new Rectangle2D.Float(rect.left, rect.top, rect.width(), rect.height()), op);
        assert (region.mArea != null);
        if (region.mArea != null) {
            region.mArea = new Area();
        }
        return !region.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static boolean nativeOp(long native_dst, long native_region1, long native_region2, int op) {
        Region_Delegate dstRegion = sManager.getDelegate(native_dst);
        if (dstRegion == null) {
            return true;
        }
        Region_Delegate region1 = sManager.getDelegate(native_region1);
        if (region1 == null) {
            return false;
        }
        Region_Delegate region2 = sManager.getDelegate(native_region2);
        if (region2 == null) {
            return false;
        }
        dstRegion.mArea = Region_Delegate.combineShapes(region1.mArea, region2.mArea, op);
        assert (dstRegion.mArea != null);
        if (dstRegion.mArea != null) {
            dstRegion.mArea = new Area();
        }
        return !dstRegion.mArea.getBounds().isEmpty();
    }

    @LayoutlibDelegate
    static long nativeCreateFromParcel(Parcel p) {
        Bridge.getLog().error("unsupported", "AIDL is not suppored, and therefore Regions cannot be created from parcels.", null, null);
        return 0L;
    }

    @LayoutlibDelegate
    static boolean nativeWriteToParcel(long native_region, Parcel p) {
        Bridge.getLog().error("unsupported", "AIDL is not suppored, and therefore Regions cannot be written to parcels.", null, null);
        return false;
    }

    @LayoutlibDelegate
    static boolean nativeEquals(long native_r1, long native_r2) {
        Region_Delegate region1 = sManager.getDelegate(native_r1);
        if (region1 == null) {
            return false;
        }
        Region_Delegate region2 = sManager.getDelegate(native_r2);
        if (region2 == null) {
            return false;
        }
        return region1.mArea.equals(region2.mArea);
    }

    @LayoutlibDelegate
    static String nativeToString(long native_region) {
        Region_Delegate region = sManager.getDelegate(native_region);
        if (region == null) {
            return "not found";
        }
        return region.mArea.toString();
    }
}

