/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;

public class PointF
implements Parcelable {
    public float x;
    public float y;
    public static final Parcelable.Creator<PointF> CREATOR = new Parcelable.Creator<PointF>(){

        @Override
        public PointF createFromParcel(Parcel in) {
            PointF r = new PointF();
            r.readFromParcel(in);
            return r;
        }

        public PointF[] newArray(int size) {
            return new PointF[size];
        }
    };

    public PointF() {
    }

    public PointF(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public PointF(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public PointF(PointF p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(PointF p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public void offset(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public boolean equals(float x, float y) {
        return this.x == x && this.y == y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointF pointF = (PointF)o;
        if (Float.compare(pointF.x, this.x) != 0) {
            return false;
        }
        return Float.compare(pointF.y, this.y) == 0;
    }

    public int hashCode() {
        int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        return result;
    }

    public String toString() {
        return "PointF(" + this.x + ", " + this.y + ")";
    }

    public float length() {
        return PointF.length(this.x, this.y);
    }

    public static float length(float x, float y) {
        return (float)Math.hypot(x, y);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
    }

    public void readFromParcel(Parcel in) {
        this.x = in.readFloat();
        this.y = in.readFloat();
    }
}

