/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix_Delegate;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.RoundRectangle;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import libcore.util.NativeAllocationRegistry_Delegate;

public final class Path_Delegate {
    private static final DelegateManager<Path_Delegate> sManager = new DelegateManager<Path_Delegate>(Path_Delegate.class);
    private static final float EPSILON = 1.0E-4f;
    private static long sFinalizer = -1L;
    private Path.FillType mFillType = Path.FillType.WINDING;
    private Path2D mPath = new Path2D.Double();
    private float mLastX = 0.0f;
    private float mLastY = 0.0f;
    private boolean mCachedIsEmpty = true;

    public static Path_Delegate getDelegate(long nPath) {
        return sManager.getDelegate(nPath);
    }

    public Path2D getJavaShape() {
        return this.mPath;
    }

    public void setJavaShape(Shape shape) {
        this.reset();
        this.mPath.append(shape, false);
    }

    public void reset() {
        this.mPath.reset();
        this.mLastX = 0.0f;
        this.mLastY = 0.0f;
    }

    public void setPathIterator(PathIterator iterator) {
        this.reset();
        this.mPath.append(iterator, false);
    }

    @LayoutlibDelegate
    static long nInit() {
        Path_Delegate newDelegate = new Path_Delegate();
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static long nInit(long nPath) {
        Path_Delegate newDelegate = new Path_Delegate();
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate != null) {
            newDelegate.set(pathDelegate);
        }
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static void nReset(long nPath) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.reset();
    }

    @LayoutlibDelegate
    static void nRewind(long nPath) {
        Path_Delegate.nReset(nPath);
    }

    @LayoutlibDelegate
    static void nSet(long native_dst, long nSrc) {
        Path_Delegate pathDstDelegate = sManager.getDelegate(native_dst);
        if (pathDstDelegate == null) {
            return;
        }
        Path_Delegate pathSrcDelegate = sManager.getDelegate(nSrc);
        if (pathSrcDelegate == null) {
            return;
        }
        pathDstDelegate.set(pathSrcDelegate);
    }

    @LayoutlibDelegate
    static boolean nIsConvex(long nPath) {
        Bridge.getLog().fidelityWarning("unsupported", "Path.isConvex is not supported.", null, null, null);
        return true;
    }

    @LayoutlibDelegate
    static int nGetFillType(long nPath) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return 0;
        }
        return pathDelegate.mFillType.nativeInt;
    }

    @LayoutlibDelegate
    public static void nSetFillType(long nPath, int ft) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.setFillType(Path.sFillTypeArray[ft]);
    }

    @LayoutlibDelegate
    static boolean nIsEmpty(long nPath) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        return pathDelegate == null || pathDelegate.isEmpty();
    }

    @LayoutlibDelegate
    static boolean nIsRect(long nPath, RectF rect) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return false;
        }
        Area area = new Area(pathDelegate.mPath);
        if (area.isRectangular()) {
            if (rect != null) {
                pathDelegate.fillBounds(rect);
            }
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static void nComputeBounds(long nPath, RectF bounds) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.fillBounds(bounds);
    }

    @LayoutlibDelegate
    static void nIncReserve(long nPath, int extraPtCount) {
    }

    @LayoutlibDelegate
    static void nMoveTo(long nPath, float x, float y) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.moveTo(x, y);
    }

    @LayoutlibDelegate
    static void nRMoveTo(long nPath, float dx, float dy) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.rMoveTo(dx, dy);
    }

    @LayoutlibDelegate
    static void nLineTo(long nPath, float x, float y) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.lineTo(x, y);
    }

    @LayoutlibDelegate
    static void nRLineTo(long nPath, float dx, float dy) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.rLineTo(dx, dy);
    }

    @LayoutlibDelegate
    static void nQuadTo(long nPath, float x1, float y1, float x2, float y2) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.quadTo(x1, y1, x2, y2);
    }

    @LayoutlibDelegate
    static void nRQuadTo(long nPath, float dx1, float dy1, float dx2, float dy2) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.rQuadTo(dx1, dy1, dx2, dy2);
    }

    @LayoutlibDelegate
    static void nCubicTo(long nPath, float x1, float y1, float x2, float y2, float x3, float y3) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.cubicTo(x1, y1, x2, y2, x3, y3);
    }

    @LayoutlibDelegate
    static void nRCubicTo(long nPath, float x1, float y1, float x2, float y2, float x3, float y3) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.rCubicTo(x1, y1, x2, y2, x3, y3);
    }

    @LayoutlibDelegate
    static void nArcTo(long nPath, float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean forceMoveTo) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.arcTo(left, top, right, bottom, startAngle, sweepAngle, forceMoveTo);
    }

    @LayoutlibDelegate
    static void nClose(long nPath) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.close();
    }

    @LayoutlibDelegate
    static void nAddRect(long nPath, float left, float top, float right, float bottom, int dir) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.addRect(left, top, right, bottom, dir);
    }

    @LayoutlibDelegate
    static void nAddOval(long nPath, float left, float top, float right, float bottom, int dir) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mPath.append(new Ellipse2D.Float(left, top, right - left, bottom - top), false);
    }

    @LayoutlibDelegate
    static void nAddCircle(long nPath, float x, float y, float radius, int dir) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mPath.append(new Ellipse2D.Float(x - radius, y - radius, radius * 2.0f, radius * 2.0f), false);
    }

    @LayoutlibDelegate
    static void nAddArc(long nPath, float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mPath.append(new Arc2D.Float(left, top, right - left, bottom - top, -startAngle, -sweepAngle, 0), false);
    }

    @LayoutlibDelegate
    static void nAddRoundRect(long nPath, float left, float top, float right, float bottom, float rx, float ry, int dir) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mPath.append(new RoundRectangle2D.Float(left, top, right - left, bottom - top, rx * 2.0f, ry * 2.0f), false);
    }

    @LayoutlibDelegate
    static void nAddRoundRect(long nPath, float left, float top, float right, float bottom, float[] radii, int dir) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        float[] cornerDimensions = new float[radii.length];
        for (int i = 0; i < radii.length; ++i) {
            cornerDimensions[i] = 2.0f * radii[i];
        }
        pathDelegate.mPath.append(new RoundRectangle(left, top, right - left, bottom - top, cornerDimensions), false);
    }

    @LayoutlibDelegate
    static void nAddPath(long nPath, long src, float dx, float dy) {
        Path_Delegate.addPath(nPath, src, AffineTransform.getTranslateInstance(dx, dy));
    }

    @LayoutlibDelegate
    static void nAddPath(long nPath, long src) {
        Path_Delegate.addPath(nPath, src, null);
    }

    @LayoutlibDelegate
    static void nAddPath(long nPath, long src, long matrix) {
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(matrix);
        if (matrixDelegate == null) {
            return;
        }
        Path_Delegate.addPath(nPath, src, matrixDelegate.getAffineTransform());
    }

    @LayoutlibDelegate
    static void nOffset(long nPath, float dx, float dy) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.offset(dx, dy);
    }

    @LayoutlibDelegate
    static void nSetLastPoint(long nPath, float dx, float dy) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        pathDelegate.mLastX = dx;
        pathDelegate.mLastY = dy;
    }

    @LayoutlibDelegate
    static void nTransform(long nPath, long matrix, long dst_path) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return;
        }
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(matrix);
        if (matrixDelegate == null) {
            return;
        }
        Path_Delegate dstDelegate = sManager.getDelegate(dst_path);
        pathDelegate.transform(matrixDelegate, dstDelegate);
    }

    @LayoutlibDelegate
    static void nTransform(long nPath, long matrix) {
        Path_Delegate.nTransform(nPath, matrix, 0L);
    }

    @LayoutlibDelegate
    static boolean nOp(long nPath1, long nPath2, int op, long result) {
        Bridge.getLog().error("unsupported", "Path.op() not supported", null, null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nGetFinalizer() {
        Class<Path_Delegate> clazz = Path_Delegate.class;
        synchronized (Path_Delegate.class) {
            if (sFinalizer == -1L) {
                sFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFinalizer;
        }
    }

    @LayoutlibDelegate
    static float[] nApproximate(long nPath, float error) {
        Path_Delegate pathDelegate = sManager.getDelegate(nPath);
        if (pathDelegate == null) {
            return null;
        }
        PathIterator iterator = pathDelegate.getJavaShape().getPathIterator(null, error);
        float[] segment = new float[6];
        float totalLength = 0.0f;
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        Point2D.Float previousPoint = null;
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(segment);
            Point2D.Float currentPoint = new Point2D.Float(segment[0], segment[1]);
            if (previousPoint != null && type != 0) {
                totalLength = (float)((double)totalLength + currentPoint.distance(previousPoint));
            }
            previousPoint = currentPoint;
            points.add(currentPoint);
            iterator.next();
        }
        int nPoints = points.size();
        float[] result = new float[nPoints * 3];
        previousPoint = null;
        float walkedDistance = 0.0f;
        for (int i = 0; i < nPoints; ++i) {
            Point2D.Float point = (Point2D.Float)points.get(i);
            float distance = previousPoint != null ? (float)previousPoint.distance(point) : 0.0f;
            result[i * 3] = (walkedDistance += distance) / totalLength;
            result[i * 3 + 1] = point.x;
            result[i * 3 + 2] = point.y;
            previousPoint = point;
        }
        return result;
    }

    private void set(Path_Delegate delegate) {
        this.mPath.reset();
        this.setFillType(delegate.mFillType);
        this.mPath.append(delegate.mPath, false);
    }

    private void setFillType(Path.FillType fillType) {
        this.mFillType = fillType;
        this.mPath.setWindingRule(Path_Delegate.getWindingRule(fillType));
    }

    private static int getWindingRule(Path.FillType type) {
        switch (type) {
            case WINDING: 
            case INVERSE_WINDING: {
                return 1;
            }
            case EVEN_ODD: 
            case INVERSE_EVEN_ODD: {
                return 0;
            }
        }
        assert (false);
        return 1;
    }

    private static Path.Direction getDirection(int direction) {
        for (Path.Direction d : Path.Direction.values()) {
            if (direction != d.nativeInt) continue;
            return d;
        }
        assert (false);
        return null;
    }

    public static void addPath(long destPath, long srcPath, AffineTransform transform) {
        Path_Delegate destPathDelegate = sManager.getDelegate(destPath);
        if (destPathDelegate == null) {
            return;
        }
        Path_Delegate srcPathDelegate = sManager.getDelegate(srcPath);
        if (srcPathDelegate == null) {
            return;
        }
        if (transform != null) {
            destPathDelegate.mPath.append(srcPathDelegate.mPath.getPathIterator(transform), false);
        } else {
            destPathDelegate.mPath.append(srcPathDelegate.mPath, false);
        }
    }

    public boolean hasPoints() {
        return !this.mPath.getPathIterator(null).isDone();
    }

    public boolean isEmpty() {
        if (!this.mCachedIsEmpty) {
            return false;
        }
        float[] coords = new float[6];
        this.mCachedIsEmpty = Boolean.TRUE;
        PathIterator it = this.mPath.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            if (type != 0) {
                this.mCachedIsEmpty = false;
                return false;
            }
            it.next();
        }
        return true;
    }

    public void fillBounds(RectF bounds) {
        Rectangle2D rect = this.mPath.getBounds2D();
        bounds.left = (float)rect.getMinX();
        bounds.right = (float)rect.getMaxX();
        bounds.top = (float)rect.getMinY();
        bounds.bottom = (float)rect.getMaxY();
    }

    public void moveTo(float x, float y) {
        this.mLastX = x;
        this.mLastY = y;
        this.mPath.moveTo(this.mLastX, this.mLastY);
    }

    public void rMoveTo(float dx, float dy) {
        this.mLastX = dx += this.mLastX;
        this.mLastY = dy += this.mLastY;
        this.mPath.moveTo(this.mLastX, this.mLastY);
    }

    public void lineTo(float x, float y) {
        if (!this.hasPoints()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = x;
        this.mLastY = y;
        this.mPath.lineTo(this.mLastX, this.mLastY);
    }

    public void rLineTo(float dx, float dy) {
        if (!this.hasPoints()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        if (Math.abs(dx) < 1.0E-4f && Math.abs(dy) < 1.0E-4f) {
            return;
        }
        this.mLastX = dx += this.mLastX;
        this.mLastY = dy += this.mLastY;
        this.mPath.lineTo(this.mLastX, this.mLastY);
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        this.mLastX = x2;
        this.mLastY = y2;
        this.mPath.quadTo(x1, y1, this.mLastX, this.mLastY);
    }

    public void rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        if (!this.hasPoints()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = dx2 += this.mLastX;
        this.mLastY = dy2 += this.mLastY;
        this.mPath.quadTo(dx1 += this.mLastX, dy1 += this.mLastY, this.mLastX, this.mLastY);
    }

    public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (!this.hasPoints()) {
            this.mPath.moveTo(0.0, 0.0);
        }
        this.mLastX = x3;
        this.mLastY = y3;
        this.mPath.curveTo(x1, y1, x2, y2, this.mLastX, this.mLastY);
    }

    public void rCubicTo(float dx1, float dy1, float dx2, float dy2, float dx3, float dy3) {
        if (!this.hasPoints()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = dx3 += this.mLastX;
        this.mLastY = dy3 += this.mLastY;
        this.mPath.curveTo(dx1 += this.mLastX, dy1 += this.mLastY, dx2 += this.mLastX, dy2 += this.mLastY, this.mLastX, this.mLastY);
    }

    public void arcTo(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean forceMoveTo) {
        Arc2D.Float arc = new Arc2D.Float(left, top, right - left, bottom - top, -startAngle, -sweepAngle, 0);
        this.mPath.append(arc, true);
        this.resetLastPointFromPath();
    }

    public void close() {
        this.mPath.closePath();
    }

    private void resetLastPointFromPath() {
        Point2D last = this.mPath.getCurrentPoint();
        this.mLastX = (float)last.getX();
        this.mLastY = (float)last.getY();
    }

    public void addRect(float left, float top, float right, float bottom, int dir) {
        this.moveTo(left, top);
        Path.Direction direction = Path_Delegate.getDirection(dir);
        switch (direction) {
            case CW: {
                this.lineTo(right, top);
                this.lineTo(right, bottom);
                this.lineTo(left, bottom);
                break;
            }
            case CCW: {
                this.lineTo(left, bottom);
                this.lineTo(right, bottom);
                this.lineTo(right, top);
            }
        }
        this.close();
        this.resetLastPointFromPath();
    }

    public void offset(float dx, float dy) {
        GeneralPath newPath = new GeneralPath();
        PathIterator iterator = this.mPath.getPathIterator(new AffineTransform(0.0f, 0.0f, dx, 0.0f, 0.0f, dy));
        newPath.append(iterator, false);
        this.mPath = newPath;
    }

    public void transform(Matrix_Delegate matrix, Path_Delegate dst) {
        if (matrix.hasPerspective()) {
            assert (false);
            Bridge.getLog().fidelityWarning("matrix.affine", "android.graphics.Path#transform() only supports affine transformations.", null, null, null);
        }
        GeneralPath newPath = new GeneralPath();
        PathIterator iterator = this.mPath.getPathIterator(matrix.getAffineTransform());
        newPath.append(iterator, false);
        if (dst != null) {
            dst.mPath = newPath;
        } else {
            this.mPath = newPath;
        }
    }
}

