/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Path_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.util.CachedPathIteratorFactory;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.geom.PathIterator;

public final class PathMeasure_Delegate {
    private static final DelegateManager<PathMeasure_Delegate> sManager = new DelegateManager<PathMeasure_Delegate>(PathMeasure_Delegate.class);
    private CachedPathIteratorFactory mOriginalPathIterator;
    private long mNativePath;

    private PathMeasure_Delegate(long native_path, boolean forceClosed) {
        this.mNativePath = native_path;
        if (native_path != 0L) {
            if (forceClosed) {
                native_path = Path_Delegate.nInit(native_path);
                Path_Delegate.nClose(native_path);
            }
            Path_Delegate pathDelegate = Path_Delegate.getDelegate(native_path);
            this.mOriginalPathIterator = new CachedPathIteratorFactory(pathDelegate.getJavaShape().getPathIterator(null));
        }
    }

    @LayoutlibDelegate
    static long native_create(long native_path, boolean forceClosed) {
        return sManager.addNewDelegate(new PathMeasure_Delegate(native_path, forceClosed));
    }

    @LayoutlibDelegate
    static void native_destroy(long native_instance) {
        sManager.removeJavaReferenceFor(native_instance);
    }

    @LayoutlibDelegate
    static boolean native_getPosTan(long native_instance, float distance, float[] pos, float[] tan) {
        Bridge.getLog().fidelityWarning("unsupported", "PathMeasure.getPostTan is not supported.", null, null, null);
        return false;
    }

    @LayoutlibDelegate
    static boolean native_getMatrix(long native_instance, float distance, long native_matrix, int flags) {
        Bridge.getLog().fidelityWarning("unsupported", "PathMeasure.getMatrix is not supported.", null, null, null);
        return false;
    }

    @LayoutlibDelegate
    static boolean native_nextContour(long native_instance) {
        Bridge.getLog().fidelityWarning("unsupported", "PathMeasure.nextContour is not supported.", null, null, null);
        return false;
    }

    @LayoutlibDelegate
    static void native_setPath(long native_instance, long native_path, boolean forceClosed) {
        PathMeasure_Delegate pathMeasure = sManager.getDelegate(native_instance);
        assert (pathMeasure != null);
        if (native_path != 0L) {
            if (forceClosed) {
                native_path = Path_Delegate.nInit(native_path);
                Path_Delegate.nClose(native_path);
            }
            Path_Delegate pathDelegate = Path_Delegate.getDelegate(native_path);
            pathMeasure.mOriginalPathIterator = new CachedPathIteratorFactory(pathDelegate.getJavaShape().getPathIterator(null));
        }
        pathMeasure.mNativePath = native_path;
    }

    @LayoutlibDelegate
    static float native_getLength(long native_instance) {
        PathMeasure_Delegate pathMeasure = sManager.getDelegate(native_instance);
        assert (pathMeasure != null);
        if (pathMeasure.mOriginalPathIterator == null) {
            return 0.0f;
        }
        return pathMeasure.mOriginalPathIterator.iterator().getTotalLength();
    }

    @LayoutlibDelegate
    static boolean native_isClosed(long native_instance) {
        PathMeasure_Delegate pathMeasure = sManager.getDelegate(native_instance);
        assert (pathMeasure != null);
        Path_Delegate path = Path_Delegate.getDelegate(pathMeasure.mNativePath);
        if (path == null) {
            return false;
        }
        int type = 0;
        float[] segment = new float[6];
        PathIterator pi = path.getJavaShape().getPathIterator(null);
        while (!pi.isDone()) {
            type = pi.currentSegment(segment);
            pi.next();
        }
        return type == 4;
    }

    @LayoutlibDelegate
    static boolean native_getSegment(long native_instance, float startD, float stopD, long native_dst_path, boolean startWithMoveTo) {
        if (startD < 0.0f) {
            startD = 0.0f;
        }
        if (startD >= stopD) {
            return false;
        }
        PathMeasure_Delegate pathMeasure = sManager.getDelegate(native_instance);
        assert (pathMeasure != null);
        CachedPathIteratorFactory.CachedPathIterator iterator = pathMeasure.mOriginalPathIterator.iterator();
        float accLength = startD;
        boolean isZeroLength = true;
        float[] points = new float[6];
        iterator.jumpToSegment(accLength);
        while (!iterator.isDone() && stopD - accLength > 0.1f) {
            int type = iterator.currentSegment(points, stopD - accLength);
            if (accLength - iterator.getCurrentSegmentLength() <= stopD) {
                if (startWithMoveTo) {
                    startWithMoveTo = false;
                    if (type != 0) {
                        float[] lastPoint = new float[2];
                        iterator.getCurrentSegmentEnd(lastPoint);
                        Path_Delegate.nMoveTo(native_dst_path, lastPoint[0], lastPoint[1]);
                    }
                }
                isZeroLength = isZeroLength && iterator.getCurrentSegmentLength() > 0.0f;
                switch (type) {
                    case 0: {
                        Path_Delegate.nMoveTo(native_dst_path, points[0], points[1]);
                        break;
                    }
                    case 1: {
                        Path_Delegate.nLineTo(native_dst_path, points[0], points[1]);
                        break;
                    }
                    case 4: {
                        Path_Delegate.nClose(native_dst_path);
                        break;
                    }
                    case 3: {
                        Path_Delegate.nCubicTo(native_dst_path, points[0], points[1], points[2], points[3], points[4], points[5]);
                        break;
                    }
                    case 2: {
                        Path_Delegate.nQuadTo(native_dst_path, points[0], points[1], points[2], points[3]);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            accLength += iterator.getCurrentSegmentLength();
            iterator.next();
        }
        return !isZeroLength;
    }
}

