/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.BidiRenderer;
import android.graphics.Bitmap;
import android.graphics.BitmapShader_Delegate;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas_Delegate;
import android.graphics.Color;
import android.graphics.Matrix_Delegate;
import android.graphics.NinePatch_Delegate;
import android.graphics.Paint;
import android.graphics.Paint_Delegate;
import android.graphics.Path_Delegate;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.RoundRectangle;
import android.graphics.Shader_Delegate;
import android.graphics.TemporaryBuffer;
import android.text.TextUtils;
import android.util.imagepool.ImagePool;
import android.util.imagepool.ImagePoolProvider;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.impl.GcSnapshot;
import com.android.layoutlib.bridge.impl.PorterDuffUtility;
import com.android.ninepatch.NinePatchChunk;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;

public class BaseCanvas_Delegate {
    protected static DelegateManager<BaseCanvas_Delegate> sManager = new DelegateManager<BaseCanvas_Delegate>(BaseCanvas_Delegate.class);
    private static final boolean[] sBoolOut = new boolean[1];
    protected Bitmap_Delegate mBitmap;
    protected GcSnapshot mSnapshot;

    protected BaseCanvas_Delegate(Bitmap_Delegate bitmap) {
        this.mBitmap = bitmap;
        this.mSnapshot = GcSnapshot.createDefaultSnapshot(this.mBitmap);
    }

    protected BaseCanvas_Delegate() {
        this.mSnapshot = GcSnapshot.createDefaultSnapshot(null);
    }

    protected void dispose() {
        this.mSnapshot.dispose();
    }

    public GcSnapshot getSnapshot() {
        return this.mSnapshot;
    }

    @LayoutlibDelegate
    static void nDrawBitmap(long nativeCanvas, long bitmapHandle, float left, float top, long nativePaintOrZero, int canvasDensity, int screenDensity, int bitmapDensity) {
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmapHandle);
        if (bitmapDelegate == null) {
            return;
        }
        BufferedImage image = bitmapDelegate.getImage();
        float right = left + (float)image.getWidth();
        float bottom = top + (float)image.getHeight();
        BaseCanvas_Delegate.drawBitmap(nativeCanvas, bitmapDelegate, nativePaintOrZero, 0, 0, image.getWidth(), image.getHeight(), (int)left, (int)top, (int)right, (int)bottom);
    }

    @LayoutlibDelegate
    static void nDrawBitmap(long nativeCanvas, long bitmapHandle, float srcLeft, float srcTop, float srcRight, float srcBottom, float dstLeft, float dstTop, float dstRight, float dstBottom, long nativePaintOrZero, int screenDensity, int bitmapDensity) {
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmapHandle);
        if (bitmapDelegate == null) {
            return;
        }
        BaseCanvas_Delegate.drawBitmap(nativeCanvas, bitmapDelegate, nativePaintOrZero, (int)srcLeft, (int)srcTop, (int)srcRight, (int)srcBottom, (int)dstLeft, (int)dstTop, (int)dstRight, (int)dstBottom);
    }

    @LayoutlibDelegate
    static void nDrawBitmap(long nativeCanvas, int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, long nativePaintOrZero) {
        ImagePool.Image image = ImagePoolProvider.get().acquire(width, height, hasAlpha ? 2 : 1);
        image.setRGB(0, 0, width, height, colors, offset, stride);
        BaseCanvas_Delegate.draw(nativeCanvas, nativePaintOrZero, true, false, (graphics, paint) -> {
            if (paint != null && paint.isFilterBitmap()) {
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            image.drawImage(graphics, (int)x, (int)y, null);
        });
    }

    @LayoutlibDelegate
    static void nDrawColor(long nativeCanvas, int color2, int mode) {
        BaseCanvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        int w = canvasDelegate.mBitmap.getImage().getWidth();
        int h = canvasDelegate.mBitmap.getImage().getHeight();
        BaseCanvas_Delegate.draw(nativeCanvas, (graphics, paint) -> {
            graphics.setTransform(new AffineTransform());
            graphics.setColor(new java.awt.Color(color2, true));
            Composite composite = PorterDuffUtility.getComposite(PorterDuffUtility.getPorterDuffMode(mode), 255);
            if (composite != null) {
                graphics.setComposite(composite);
            }
            graphics.fillRect(0, 0, w, h);
        });
    }

    @LayoutlibDelegate
    static void nDrawColor(long nativeCanvas, long nativeColorSpace, long color2, int mode) {
        BaseCanvas_Delegate.nDrawColor(nativeCanvas, Color.toArgb(color2), mode);
    }

    @LayoutlibDelegate
    static void nDrawPaint(long nativeCanvas, long paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPaint is not supported.", null, null, null);
    }

    @LayoutlibDelegate
    static void nDrawPoint(long nativeCanvas, float x, float y, long nativePaint) {
        BaseCanvas_Delegate.draw(nativeCanvas, nativePaint, false, false, (graphics, paintDelegate) -> graphics.fillRect((int)x, (int)y, 1, 1));
    }

    @LayoutlibDelegate
    static void nDrawPoints(long nativeCanvas, float[] pts, int offset, int count, long nativePaint) {
        if (offset < 0 || count < 0 || offset + count > pts.length) {
            throw new IllegalArgumentException("Invalid argument set");
        }
        count = count >> 1 << 1;
        for (int i = offset; i < offset + count; i += 2) {
            BaseCanvas_Delegate.nDrawPoint(nativeCanvas, pts[i], pts[i + 1], nativePaint);
        }
    }

    @LayoutlibDelegate
    static void nDrawLine(long nativeCanvas, float startX, float startY, float stopX, float stopY, long paint) {
        BaseCanvas_Delegate.draw(nativeCanvas, paint, false, false, (graphics, paintDelegate) -> graphics.drawLine((int)startX, (int)startY, (int)stopX, (int)stopY));
    }

    @LayoutlibDelegate
    static void nDrawLines(long nativeCanvas, float[] pts, int offset, int count, long nativePaint) {
        BaseCanvas_Delegate.draw(nativeCanvas, nativePaint, false, false, (graphics, paintDelegate) -> {
            for (int i = 0; i < count; i += 4) {
                graphics.drawLine((int)pts[i + offset], (int)pts[i + offset + 1], (int)pts[i + offset + 2], (int)pts[i + offset + 3]);
            }
        });
    }

    @LayoutlibDelegate
    static void nDrawRect(long nativeCanvas, float left, float top, float right, float bottom, long paint) {
        BaseCanvas_Delegate.draw(nativeCanvas, paint, false, false, (graphics, paintDelegate) -> {
            int style2 = paintDelegate.getStyle();
            if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                graphics.fillRect((int)left, (int)top, (int)(right - left), (int)(bottom - top));
            }
            if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                graphics.drawRect((int)left, (int)top, (int)(right - left), (int)(bottom - top));
            }
        });
    }

    @LayoutlibDelegate
    static void nDrawOval(long nativeCanvas, float left, float top, float right, float bottom, long paint) {
        if (right > left && bottom > top) {
            BaseCanvas_Delegate.draw(nativeCanvas, paint, false, false, (graphics, paintDelegate) -> {
                int style2 = paintDelegate.getStyle();
                if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.fillOval((int)left, (int)top, (int)(right - left), (int)(bottom - top));
                }
                if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.drawOval((int)left, (int)top, (int)(right - left), (int)(bottom - top));
                }
            });
        }
    }

    @LayoutlibDelegate
    static void nDrawCircle(long nativeCanvas, float cx, float cy, float radius, long paint) {
        BaseCanvas_Delegate.nDrawOval(nativeCanvas, cx - radius, cy - radius, cx + radius, cy + radius, paint);
    }

    @LayoutlibDelegate
    static void nDrawArc(long nativeCanvas, float left, float top, float right, float bottom, float startAngle, float sweep, boolean useCenter, long paint) {
        if (right > left && bottom > top) {
            BaseCanvas_Delegate.draw(nativeCanvas, paint, false, false, (graphics, paintDelegate) -> {
                int style2 = paintDelegate.getStyle();
                Arc2D.Float arc = new Arc2D.Float(left, top, right - left, bottom - top, -startAngle, -sweep, useCenter ? 2 : 0);
                if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.fill(arc);
                }
                if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics.draw(arc);
                }
            });
        }
    }

    @LayoutlibDelegate
    static void nDrawRoundRect(long nativeCanvas, float left, float top, float right, float bottom, float rx, float ry, long paint) {
        BaseCanvas_Delegate.draw(nativeCanvas, paint, false, false, (graphics, paintDelegate) -> {
            int style2 = paintDelegate.getStyle();
            if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                graphics.fillRoundRect((int)left, (int)top, (int)(right - left), (int)(bottom - top), 2 * (int)rx, 2 * (int)ry);
            }
            if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                graphics.drawRoundRect((int)left, (int)top, (int)(right - left), (int)(bottom - top), 2 * (int)rx, 2 * (int)ry);
            }
        });
    }

    @LayoutlibDelegate
    static void nDrawDoubleRoundRect(long nativeCanvas, float outerLeft, float outerTop, float outerRight, float outerBottom, float outerRx, float outerRy, float innerLeft, float innerTop, float innerRight, float innerBottom, float innerRx, float innerRy, long nativePaint) {
        BaseCanvas_Delegate.nDrawDoubleRoundRect(nativeCanvas, outerLeft, outerTop, outerRight, outerBottom, new float[]{outerRx, outerRy, outerRx, outerRy, outerRx, outerRy, outerRx, outerRy}, innerLeft, innerTop, innerRight, innerBottom, new float[]{innerRx, innerRy, innerRx, innerRy, innerRx, innerRy, innerRx, innerRy}, nativePaint);
    }

    @LayoutlibDelegate
    static void nDrawDoubleRoundRect(long nativeCanvas, float outerLeft, float outerTop, float outerRight, float outerBottom, float[] outerRadii, float innerLeft, float innerTop, float innerRight, float innerBottom, float[] innerRadii, long nativePaint) {
        BaseCanvas_Delegate.draw(nativeCanvas, nativePaint, false, false, (graphics, paintDelegate) -> {
            RoundRectangle innerRect = new RoundRectangle(innerLeft, innerTop, innerRight - innerLeft, innerBottom - innerTop, innerRadii);
            RoundRectangle outerRect = new RoundRectangle(outerLeft, outerTop, outerRight - outerLeft, outerBottom - outerTop, outerRadii);
            int style2 = paintDelegate.getStyle();
            if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                graphics.draw(innerRect);
                graphics.draw(outerRect);
            }
            if (style2 == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                Area outerArea = new Area(outerRect);
                Area innerArea = new Area(innerRect);
                outerArea.subtract(innerArea);
                graphics.fill(outerArea);
            }
        });
    }

    @LayoutlibDelegate
    public static void nDrawPath(long nativeCanvas, long path, long paint) {
        Path_Delegate pathDelegate = Path_Delegate.getDelegate(path);
        if (pathDelegate == null) {
            return;
        }
        BaseCanvas_Delegate.draw(nativeCanvas, paint, false, false, (graphics, paintDelegate) -> {
            int style2;
            Path2D shape = pathDelegate.getJavaShape();
            Rectangle2D bounds = shape.getBounds2D();
            if (bounds.isEmpty()) {
                if (pathDelegate.isEmpty()) {
                    return;
                }
                float strokeWidth = paintDelegate.getStrokeWidth();
                if (strokeWidth <= 0.0f) {
                    return;
                }
                bounds.setRect(bounds.getX(), bounds.getY(), Math.max((double)strokeWidth, bounds.getWidth()), Math.max((double)strokeWidth, bounds.getHeight()));
            }
            if ((style2 = paintDelegate.getStyle()) == Paint.Style.FILL.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                graphics.fill(shape);
            }
            if (style2 == Paint.Style.STROKE.nativeInt || style2 == Paint.Style.FILL_AND_STROKE.nativeInt) {
                graphics.draw(shape);
            }
        });
    }

    @LayoutlibDelegate
    static void nDrawRegion(long nativeCanvas, long nativeRegion, long nativePaint) {
        Bridge.getLog().fidelityWarning("unsupported", "Some canvas paths may not be drawn", null, null, null);
    }

    @LayoutlibDelegate
    static void nDrawNinePatch(long nativeCanvas, long nativeBitmap, long ninePatch, final float dstLeft, final float dstTop, final float dstRight, final float dstBottom, long nativePaintOrZero, final int screenDensity, final int bitmapDensity) {
        final Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(nativeBitmap);
        if (bitmapDelegate == null) {
            return;
        }
        byte[] c = NinePatch_Delegate.getChunk(ninePatch);
        if (c == null) {
            BufferedImage image = bitmapDelegate.getImage();
            BaseCanvas_Delegate.drawBitmap(nativeCanvas, bitmapDelegate, nativePaintOrZero, 0, 0, image.getWidth(), image.getHeight(), (int)dstLeft, (int)dstTop, (int)dstRight, (int)dstBottom);
            return;
        }
        final NinePatchChunk chunkObject = NinePatch_Delegate.getChunk(c);
        if (chunkObject == null) {
            return;
        }
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(nativePaintOrZero);
        canvasDelegate.getSnapshot().draw(new GcSnapshot.Drawable(){

            @Override
            public void draw(Graphics2D graphics, Paint_Delegate paint) {
                chunkObject.draw(bitmapDelegate.getImage(), graphics, (int)dstLeft, (int)dstTop, (int)(dstRight - dstLeft), (int)(dstBottom - dstTop), screenDensity, bitmapDensity);
            }
        }, paintDelegate, true, false);
    }

    @LayoutlibDelegate
    static void nDrawBitmapMatrix(long nCanvas, long bitmapHandle, long nMatrix, long nPaint) {
        BaseCanvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(nPaint);
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmapHandle);
        if (bitmapDelegate == null) {
            return;
        }
        BufferedImage image = BaseCanvas_Delegate.getImageToDraw(bitmapDelegate, paintDelegate, sBoolOut);
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(nMatrix);
        if (matrixDelegate == null) {
            return;
        }
        AffineTransform mtx = matrixDelegate.getAffineTransform();
        canvasDelegate.getSnapshot().draw((graphics, paint) -> {
            if (paint != null && paint.isFilterBitmap()) {
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            graphics.drawImage(image, mtx, null);
        }, paintDelegate, true, false);
    }

    @LayoutlibDelegate
    static void nDrawBitmapMesh(long nCanvas, long bitmapHandle, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, long nPaint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawBitmapMesh is not supported.", null, null, null);
    }

    @LayoutlibDelegate
    static void nDrawVertices(long nCanvas, int mode, int n, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, long nPaint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawVertices is not supported.", null, null, null);
    }

    @LayoutlibDelegate
    static void nDrawText(long nativeCanvas, char[] text, int index, int count, float startX, float startY, int flags, long paint) {
        BaseCanvas_Delegate.drawText(nativeCanvas, text, index, count, startX, startY, flags, paint);
    }

    @LayoutlibDelegate
    static void nDrawText(long nativeCanvas, String text, int start, int end, float x, float y, int flags, long paint) {
        int count = end - start;
        char[] buffer = TemporaryBuffer.obtain(count);
        TextUtils.getChars(text, start, end, buffer, 0);
        BaseCanvas_Delegate.nDrawText(nativeCanvas, buffer, 0, count, x, y, flags, paint);
    }

    @LayoutlibDelegate
    static void nDrawTextRun(long nativeCanvas, String text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, long paint) {
        int count = end - start;
        char[] buffer = TemporaryBuffer.obtain(count);
        TextUtils.getChars(text, start, end, buffer, 0);
        BaseCanvas_Delegate.drawText(nativeCanvas, buffer, 0, count, x, y, isRtl ? 1 : 0, paint);
    }

    @LayoutlibDelegate
    static void nDrawTextRun(long nativeCanvas, char[] text, int start, int count, int contextStart, int contextCount, float x, float y, boolean isRtl, long paint, long nativeMeasuredText) {
        BaseCanvas_Delegate.drawText(nativeCanvas, text, start, count, x, y, isRtl ? 1 : 0, paint);
    }

    @LayoutlibDelegate
    static void nDrawTextOnPath(long nativeCanvas, char[] text, int index, int count, long path, float hOffset, float vOffset, int bidiFlags, long paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawTextOnPath is not supported.", null, null, null);
    }

    @LayoutlibDelegate
    static void nDrawTextOnPath(long nativeCanvas, String text, long path, float hOffset, float vOffset, int bidiFlags, long paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawTextOnPath is not supported.", null, null, null);
    }

    private static void draw(long nCanvas, long nPaint, boolean compositeOnly, boolean forceSrcMode, GcSnapshot.Drawable drawable2) {
        BaseCanvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(nPaint);
        canvasDelegate.getSnapshot().draw(drawable2, paintDelegate, compositeOnly, forceSrcMode);
    }

    private static void draw(long nCanvas, GcSnapshot.Drawable drawable2) {
        BaseCanvas_Delegate canvasDelegate = sManager.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.mSnapshot.draw(drawable2);
    }

    private static void drawText(long nativeCanvas, char[] text, int index, int count, float startX, float startY, int bidiFlags, long paint) {
        BaseCanvas_Delegate.draw(nativeCanvas, paint, false, false, (graphics, paintDelegate) -> {
            float x = startX;
            int limit = index + count;
            if (paintDelegate.getTextAlign() != Paint.Align.LEFT.nativeInt) {
                RectF bounds = paintDelegate.measureText(text, index, count, null, 0, bidiFlags);
                float m = bounds.right - bounds.left;
                if (paintDelegate.getTextAlign() == Paint.Align.CENTER.nativeInt) {
                    x -= m / 2.0f;
                } else if (paintDelegate.getTextAlign() == Paint.Align.RIGHT.nativeInt) {
                    x -= m;
                }
            }
            new BidiRenderer(graphics, paintDelegate, text).setRenderLocation(x, startY).renderText(index, limit, bidiFlags, null, 0, true);
        });
    }

    private static void drawBitmap(long nativeCanvas, Bitmap_Delegate bitmap, long nativePaintOrZero, int sleft, int stop, int sright, int sbottom, int dleft, int dtop, int dright, int dbottom) {
        BaseCanvas_Delegate canvasDelegate = sManager.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(nativePaintOrZero);
        BufferedImage image = BaseCanvas_Delegate.getImageToDraw(bitmap, paintDelegate, sBoolOut);
        BaseCanvas_Delegate.draw(nativeCanvas, nativePaintOrZero, true, sBoolOut[0], (graphics, paint) -> {
            if (paint != null && paint.isFilterBitmap()) {
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            graphics.drawImage(image, dleft, dtop, dright, dbottom, sleft, stop, sright, sbottom, null);
        });
    }

    private static BufferedImage getImageToDraw(Bitmap_Delegate bitmap, Paint_Delegate paint, boolean[] forceSrcMode) {
        BufferedImage image = bitmap.getImage();
        forceSrcMode[0] = false;
        if (bitmap.getConfig() == Bitmap.Config.ALPHA_8) {
            Shader_Delegate shader = paint.getShader();
            Paint javaPaint = null;
            if (shader instanceof BitmapShader_Delegate) {
                javaPaint = shader.getJavaPaint();
            }
            BaseCanvas_Delegate.fixAlpha8Bitmap(image, javaPaint);
        } else if (!bitmap.hasAlpha()) {
            if (paint != null) {
                PorterDuff.Mode mode = PorterDuff.intToMode(paint.getPorterDuffMode());
                boolean bl = forceSrcMode[0] = mode == PorterDuff.Mode.SRC_OVER || mode == PorterDuff.Mode.SRC;
            }
            if (!forceSrcMode[0]) {
                image = Bitmap_Delegate.createCopy(image, 1, 255);
            }
        }
        return image;
    }

    private static void fixAlpha8Bitmap(BufferedImage image, Paint javaPaint) {
        int w = image.getWidth();
        int h = image.getHeight();
        DataBuffer texture = null;
        if (javaPaint != null) {
            PaintContext context = javaPaint.createContext(ColorModel.getRGBdefault(), null, null, new AffineTransform(), null);
            texture = context.getRaster(0, 0, w, h).getDataBuffer();
        }
        int[] argb = new int[w * h];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), argb, 0, image.getWidth());
        int length = argb.length;
        for (int i = 0; i < length; ++i) {
            int n = i;
            argb[n] = argb[n] & 0xFF000000;
            if (texture == null) continue;
            int n2 = i;
            argb[n2] = argb[n2] | texture.getElem(i) & 0xFFFFFF;
        }
        image.setRGB(0, 0, w, h, argb, 0, w);
    }

    protected int save(int saveFlags) {
        int count = this.mSnapshot.size();
        this.mSnapshot = this.mSnapshot.save(saveFlags);
        return count;
    }

    protected int saveLayerAlpha(RectF rect, int alpha, int saveFlags) {
        Paint_Delegate paint = new Paint_Delegate();
        paint.setAlpha(alpha);
        return this.saveLayer(rect, paint, saveFlags);
    }

    protected int saveLayer(RectF rect, Paint_Delegate paint, int saveFlags) {
        int count = this.mSnapshot.size();
        this.mSnapshot = this.mSnapshot.saveLayer(rect, paint, saveFlags);
        return count;
    }

    protected void restoreTo(int saveCount) {
        this.mSnapshot = this.mSnapshot.restoreTo(saveCount);
    }

    protected void restore() {
        this.mSnapshot = this.mSnapshot.restore();
    }

    protected boolean clipRect(float left, float top, float right, float bottom, int regionOp) {
        return this.mSnapshot.clipRect(left, top, right, bottom, regionOp);
    }
}

