/*
 * Decompiled with CFR 0.152.
 */
package android.content.res.loader;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.ApkAssets;
import android.content.res.loader.AssetsProvider;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import java.io.Closeable;
import java.io.IOException;

public class ResourcesProvider
implements AutoCloseable,
Closeable {
    private static final String TAG = "ResourcesProvider";
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private boolean mOpen = true;
    @GuardedBy(value={"mLock"})
    private int mOpenCount = 0;
    @GuardedBy(value={"mLock"})
    private final ApkAssets mApkAssets;

    public static ResourcesProvider empty(AssetsProvider assetsProvider) {
        return new ResourcesProvider(ApkAssets.loadEmptyForLoader(4, assetsProvider));
    }

    public static ResourcesProvider loadFromApk(ParcelFileDescriptor fileDescriptor) throws IOException {
        return ResourcesProvider.loadFromApk(fileDescriptor, null);
    }

    public static ResourcesProvider loadFromApk(ParcelFileDescriptor fileDescriptor, AssetsProvider assetsProvider) throws IOException {
        return new ResourcesProvider(ApkAssets.loadFromFd(fileDescriptor.getFileDescriptor(), fileDescriptor.toString(), 4, assetsProvider));
    }

    @VisibleForTesting
    public static ResourcesProvider loadFromApk(ParcelFileDescriptor fileDescriptor, long offset, long length, AssetsProvider assetsProvider) throws IOException {
        return new ResourcesProvider(ApkAssets.loadFromFd(fileDescriptor.getFileDescriptor(), fileDescriptor.toString(), offset, length, 4, assetsProvider));
    }

    public static ResourcesProvider loadFromTable(ParcelFileDescriptor fileDescriptor, AssetsProvider assetsProvider) throws IOException {
        return new ResourcesProvider(ApkAssets.loadTableFromFd(fileDescriptor.getFileDescriptor(), fileDescriptor.toString(), 4, assetsProvider));
    }

    @VisibleForTesting
    public static ResourcesProvider loadFromTable(ParcelFileDescriptor fileDescriptor, long offset, long length, AssetsProvider assetsProvider) throws IOException {
        return new ResourcesProvider(ApkAssets.loadTableFromFd(fileDescriptor.getFileDescriptor(), fileDescriptor.toString(), offset, length, 4, assetsProvider));
    }

    public static ResourcesProvider loadFromSplit(Context context, String splitName) throws IOException {
        ApplicationInfo appInfo = context.getApplicationInfo();
        int splitIndex = ArrayUtils.indexOf(appInfo.splitNames, splitName);
        if (splitIndex < 0) {
            throw new IllegalArgumentException("Split " + splitName + " not found");
        }
        String splitPath = appInfo.getSplitCodePaths()[splitIndex];
        return new ResourcesProvider(ApkAssets.loadFromPath(splitPath, 4, null));
    }

    public static ResourcesProvider loadFromDirectory(String path, AssetsProvider assetsProvider) throws IOException {
        return new ResourcesProvider(ApkAssets.loadFromDir(path, 4, assetsProvider));
    }

    private ResourcesProvider(ApkAssets apkAssets) {
        this.mApkAssets = apkAssets;
    }

    public ApkAssets getApkAssets() {
        return this.mApkAssets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementRefCount() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mOpen) {
                throw new IllegalStateException("Operation failed: resources provider is closed");
            }
            ++this.mOpenCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementRefCount() {
        Object object = this.mLock;
        synchronized (object) {
            --this.mOpenCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mOpen) {
                return;
            }
            if (this.mOpenCount != 0) {
                throw new IllegalStateException("Failed to close provider used by " + this.mOpenCount + " ResourcesLoader instances");
            }
            this.mOpen = false;
        }
        try {
            this.mApkAssets.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOpenCount != 0) {
                Log.w(TAG, "ResourcesProvider " + this + " finalized with non-zero refs: " + this.mOpenCount);
            }
            if (this.mOpen) {
                this.mOpen = false;
                this.mApkAssets.close();
            }
        }
    }
}

