/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.content.pm.PermissionInfo;
import android.content.pm.parsing.component.ParsedComponent;
import android.content.pm.parsing.component.ParsedPermissionGroup;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;

public class ParsedPermission
extends ParsedComponent {
    String backgroundPermission;
    private String group;
    int requestRes;
    int protectionLevel;
    boolean tree;
    private ParsedPermissionGroup parsedPermissionGroup;
    public static final Parcelable.Creator<ParsedPermission> CREATOR = new Parcelable.Creator<ParsedPermission>(){

        @Override
        public ParsedPermission createFromParcel(Parcel source) {
            return new ParsedPermission(source);
        }

        public ParsedPermission[] newArray(int size) {
            return new ParsedPermission[size];
        }
    };

    @VisibleForTesting
    public ParsedPermission() {
    }

    public ParsedPermission(ParsedPermission other) {
        super(other);
        this.backgroundPermission = other.backgroundPermission;
        this.group = other.group;
        this.requestRes = other.requestRes;
        this.protectionLevel = other.protectionLevel;
        this.tree = other.tree;
        this.parsedPermissionGroup = other.parsedPermissionGroup;
    }

    public ParsedPermission(ParsedPermission other, PermissionInfo pendingPermissionInfo, String packageName, String name) {
        this(other);
        this.flags = pendingPermissionInfo.flags;
        this.descriptionRes = pendingPermissionInfo.descriptionRes;
        this.backgroundPermission = pendingPermissionInfo.backgroundPermission;
        this.group = pendingPermissionInfo.group;
        this.requestRes = pendingPermissionInfo.requestRes;
        this.protectionLevel = pendingPermissionInfo.protectionLevel;
        this.setName(name);
        this.setPackageName(packageName);
    }

    public ParsedPermission setGroup(String group) {
        this.group = TextUtils.safeIntern(group);
        return this;
    }

    public ParsedPermission setFlags(int flags) {
        this.flags = flags;
        return this;
    }

    public boolean isRuntime() {
        return this.getProtection() == 1;
    }

    public boolean isAppOp() {
        return (this.protectionLevel & 0x40) != 0;
    }

    public int getProtection() {
        return this.protectionLevel & 0xF;
    }

    public int getProtectionFlags() {
        return this.protectionLevel & 0xFFFFFFF0;
    }

    public int calculateFootprint() {
        int size = this.getName().length();
        if (this.getNonLocalizedLabel() != null) {
            size += this.getNonLocalizedLabel().length();
        }
        return size;
    }

    public String toString() {
        return "Permission{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.getName() + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.backgroundPermission);
        dest.writeString(this.group);
        dest.writeInt(this.requestRes);
        dest.writeInt(this.protectionLevel);
        dest.writeBoolean(this.tree);
        dest.writeParcelable(this.parsedPermissionGroup, flags);
    }

    protected ParsedPermission(Parcel in) {
        super(in);
        ClassLoader boot = Object.class.getClassLoader();
        this.backgroundPermission = in.readString();
        this.group = in.readString();
        this.requestRes = in.readInt();
        this.protectionLevel = in.readInt();
        this.tree = in.readBoolean();
        this.parsedPermissionGroup = (ParsedPermissionGroup)in.readParcelable(boot);
    }

    public String getBackgroundPermission() {
        return this.backgroundPermission;
    }

    public String getGroup() {
        return this.group;
    }

    public int getRequestRes() {
        return this.requestRes;
    }

    public int getProtectionLevel() {
        return this.protectionLevel;
    }

    public boolean isTree() {
        return this.tree;
    }

    public ParsedPermissionGroup getParsedPermissionGroup() {
        return this.parsedPermissionGroup;
    }

    public ParsedPermission setProtectionLevel(int value) {
        this.protectionLevel = value;
        return this;
    }

    public ParsedPermission setParsedPermissionGroup(ParsedPermissionGroup value) {
        this.parsedPermissionGroup = value;
        return this;
    }
}

