/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.IBluetoothMap;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.CloseGuard;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public class BluetoothMap
implements BluetoothProfile,
AutoCloseable {
    private static final String TAG = "BluetoothMap";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private CloseGuard mCloseGuard;
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.map.profile.action.CONNECTION_STATE_CHANGED";
    public static final int STATE_ERROR = -1;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_CANCELED = 2;
    private BluetoothAdapter mAdapter;
    private final BluetoothProfileConnector<IBluetoothMap> mProfileConnector = new BluetoothProfileConnector(this, 9, "BluetoothMap", IBluetoothMap.class.getName()){

        public IBluetoothMap getServiceInterface(IBinder service) {
            return IBluetoothMap.Stub.asInterface(Binder.allowBlocking(service));
        }
    };

    BluetoothMap(Context context, BluetoothProfile.ServiceListener listener) {
        Log.d(TAG, "Create BluetoothMap proxy object");
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mProfileConnector.connect(context, listener);
        this.mCloseGuard = new CloseGuard();
        this.mCloseGuard.open("close");
    }

    protected void finalize() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    @Override
    @SystemApi
    public void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothMap getService() {
        return this.mProfileConnector.getService();
    }

    public int getState() {
        IBluetoothMap service = this.getService();
        if (service != null) {
            try {
                return service.getState();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        }
        return -1;
    }

    public BluetoothDevice getClient() {
        IBluetoothMap service = this.getService();
        if (service != null) {
            try {
                return service.getClient();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        }
        return null;
    }

    public boolean isConnected(BluetoothDevice device) {
        IBluetoothMap service = this.getService();
        if (service != null) {
            try {
                return service.isConnected(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothMap.log(Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    public boolean connect(BluetoothDevice device) {
        BluetoothMap.log("connect(" + device + ")not supported for MAPS");
        return false;
    }

    @UnsupportedAppUsage
    public boolean disconnect(BluetoothDevice device) {
        BluetoothMap.log("disconnect(" + device + ")");
        IBluetoothMap service = this.getService();
        if (service != null && this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            try {
                return service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public static boolean doesClassMatchSink(BluetoothClass btClass) {
        switch (btClass.getDeviceClass()) {
            case 256: 
            case 260: 
            case 264: 
            case 268: {
                return true;
            }
        }
        return false;
    }

    @Override
    @SystemApi
    public List<BluetoothDevice> getConnectedDevices() {
        BluetoothMap.log("getConnectedDevices()");
        IBluetoothMap service = this.getService();
        if (service != null && this.isEnabled()) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        BluetoothMap.log("getDevicesMatchingStates()");
        IBluetoothMap service = this.getService();
        if (service != null && this.isEnabled()) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        BluetoothMap.log("getConnectionState(" + device + ")");
        IBluetoothMap service = this.getService();
        if (service != null && this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    public boolean setPriority(BluetoothDevice device, int priority) {
        BluetoothMap.log("setPriority(" + device + ", " + priority + ")");
        return this.setConnectionPolicy(device, BluetoothAdapter.priorityToConnectionPolicy(priority));
    }

    @SystemApi
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        BluetoothMap.log("setConnectionPolicy(" + device + ", " + connectionPolicy + ")");
        IBluetoothMap service = this.getService();
        if (service != null && this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            if (connectionPolicy != 0 && connectionPolicy != 100) {
                return false;
            }
            try {
                return service.setConnectionPolicy(device, connectionPolicy);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public int getPriority(BluetoothDevice device) {
        return BluetoothAdapter.connectionPolicyToPriority(this.getConnectionPolicy(device));
    }

    @SystemApi
    public int getConnectionPolicy(BluetoothDevice device) {
        IBluetoothMap service = this.getService();
        if (service != null && this.isEnabled() && BluetoothMap.isValidDevice(device)) {
            try {
                return service.getConnectionPolicy(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private boolean isEnabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.getState() == 12) {
            return true;
        }
        BluetoothMap.log("Bluetooth is Not enabled");
        return false;
    }

    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }
}

