/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ContextImpl;
import android.app.IWindowToken;
import android.app.ResourcesManager;
import android.app.WindowContext;
import android.content.Context;
import android.content.res.Configuration;
import android.view.WindowManagerGlobal;
import java.lang.ref.WeakReference;

public class WindowTokenClient
extends IWindowToken.Stub {
    private WeakReference<WindowContext> mContextRef = null;
    private final ResourcesManager mResourcesManager = ResourcesManager.getInstance();

    void attachContext(WindowContext context) {
        if (this.mContextRef != null) {
            throw new IllegalStateException("Context is already attached.");
        }
        this.mContextRef = new WeakReference<WindowContext>(context);
        ContextImpl impl = ContextImpl.getImpl(context);
        impl.setResources(impl.createWindowContextResources());
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig, int newDisplayId) {
        boolean configChanged;
        Context context = (Context)this.mContextRef.get();
        if (context == null) {
            return;
        }
        int currentDisplayId = context.getDisplayId();
        boolean displayChanged = newDisplayId != currentDisplayId;
        Configuration config = context.getResources().getConfiguration();
        boolean bl = configChanged = config.diff(newConfig) != 0;
        if (displayChanged || configChanged) {
            this.mResourcesManager.updateResourcesForActivity(this, newConfig, newDisplayId, displayChanged);
        }
        if (displayChanged) {
            context.updateDisplay(newDisplayId);
        }
    }

    @Override
    public void onWindowTokenRemoved() {
        WindowContext context = (WindowContext)this.mContextRef.get();
        if (context != null) {
            context.destroy();
            this.mContextRef.clear();
        }
        WindowManagerGlobal.getInstance().closeAll(this, this.mContextRef.getClass().getName(), "WindowContext");
    }
}

