/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack.lang;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.tasks.youtrack.lang.YouTrackFile;
import com.intellij.tasks.youtrack.lang.YouTrackLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YouTrackParserDefinition
implements ParserDefinition {
    private static final Logger LOG = Logger.getInstance(YouTrackParserDefinition.class);
    public static final IElementType ANY_TEXT = new IElementType("ANY_TEXT", (Language)YouTrackLanguage.INSTANCE);
    public static final IElementType QUERY = new IElementType("QUERY", (Language)YouTrackLanguage.INSTANCE);
    public static final IFileElementType FILE = new IFileElementType((Language)YouTrackLanguage.INSTANCE);

    @NotNull
    public Lexer createLexer(Project project) {
        return new YouTrackMockLexer();
    }

    public PsiParser createParser(Project project) {
        return new YouTrackMockParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        assert (node.getElementType() == QUERY);
        return new YouTrackQueryElement(node);
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new YouTrackFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static class YouTrackMockParser
    implements PsiParser {
        private YouTrackMockParser() {
        }

        @NotNull
        public ASTNode parse(IElementType root, PsiBuilder builder) {
            PsiBuilder.Marker rootMarker = builder.mark();
            PsiBuilder.Marker queryMarker = builder.mark();
            assert (builder.getTokenType() == null || builder.getTokenType() == ANY_TEXT);
            builder.advanceLexer();
            queryMarker.done(QUERY);
            assert (builder.eof());
            rootMarker.done(root);
            return builder.getTreeBuilt();
        }
    }

    private static class YouTrackMockLexer
    extends LexerBase {
        private int myStart;
        private int myEnd;
        private CharSequence myBuffer;

        private YouTrackMockLexer() {
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            this.myBuffer = buffer;
            this.myStart = startOffset;
            this.myEnd = endOffset;
        }

        public int getState() {
            return 0;
        }

        @Nullable
        public IElementType getTokenType() {
            return this.myStart >= this.myEnd ? null : ANY_TEXT;
        }

        public int getTokenStart() {
            return this.myStart;
        }

        public int getTokenEnd() {
            return this.myEnd;
        }

        public void advance() {
            this.myStart = this.myEnd;
        }

        @NotNull
        public CharSequence getBufferSequence() {
            return this.myBuffer;
        }

        public int getBufferEnd() {
            return this.myEnd;
        }
    }

    public static class YouTrackQueryElement
    extends ASTWrapperPsiElement {
        YouTrackQueryElement(@NotNull ASTNode node) {
            super(node);
        }
    }
}

