/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskUiUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TaskStateCombo
extends JPanel {
    private final JBLabel myHintLabel;
    private Project myProject;
    private Task myTask;
    private final TemplateKindCombo myKindCombo = new TemplateKindCombo();

    public static boolean stateUpdatesSupportedFor(@Nullable Task task) {
        if (task == null || !task.isIssue()) {
            return false;
        }
        TaskRepository repository = task.getRepository();
        return repository != null && repository.isSupported(8);
    }

    public TaskStateCombo() {
        this(null, null);
    }

    public TaskStateCombo(Project project, Task task) {
        this.myProject = project;
        this.myTask = task;
        this.myHintLabel = new JBLabel();
        this.myHintLabel.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.myHintLabel.setToolTipText("Pressing Up or Down arrows while in editor changes the state");
        JComboBox comboBox = this.myKindCombo.getComboBox();
        comboBox.setPreferredSize(new Dimension(300, comboBox.getPreferredSize().height));
        this.setLayout(new BoxLayout(this, 2));
        this.add((Component)this.myKindCombo);
        this.add((Component)this.myHintLabel);
    }

    public boolean scheduleUpdateOnce() {
        if (this.myProject != null && TaskStateCombo.stateUpdatesSupportedFor(this.myTask) && this.myKindCombo.getComboBox().getItemCount() == 0) {
            JComboBox comboBox = this.myKindCombo.getComboBox();
            final TaskRepository repository = this.myTask.getRepository();
            assert (repository != null);
            new TaskUiUtil.ComboBoxUpdater<CustomStateTrinityAdapter>(this.myProject, "Fetching available task states...", comboBox){

                @Override
                @NotNull
                protected List<CustomStateTrinityAdapter> fetch(@NotNull ProgressIndicator indicator) throws Exception {
                    return CustomStateTrinityAdapter.wrapList(repository.getAvailableTaskStates(TaskStateCombo.this.myTask));
                }

                @Override
                @Nullable
                public CustomStateTrinityAdapter getSelectedItem() {
                    CustomTaskState state = TaskStateCombo.this.getPreferredState(repository, CustomStateTrinityAdapter.unwrapList((Collection)this.myResult));
                    return state != null ? new CustomStateTrinityAdapter(state) : null;
                }
            }.queue();
            return true;
        }
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myKindCombo.setEnabled(enabled);
    }

    public void showHintLabel(boolean show) {
        this.myHintLabel.setVisible(show);
    }

    @Nullable
    public CustomTaskState getSelectedState() {
        CustomStateTrinityAdapter item = (CustomStateTrinityAdapter)((Object)this.myKindCombo.getComboBox().getSelectedItem());
        if (item == null) {
            return null;
        }
        return item.myState;
    }

    public void registerUpDownAction(@NotNull JComponent focusable) {
        this.myKindCombo.registerUpDownHint(focusable);
    }

    @NotNull
    public JComboBox getComboBox() {
        return this.myKindCombo.getComboBox();
    }

    public void setProject(@NotNull Project project) {
        this.myProject = project;
    }

    public void setTask(@NotNull Task task) {
        this.myTask = task;
    }

    @Nullable
    protected abstract CustomTaskState getPreferredState(@NotNull TaskRepository var1, @NotNull Collection<CustomTaskState> var2);

    private static class CustomStateTrinityAdapter
    extends Trinity<String, Icon, String> {
        final CustomTaskState myState;

        CustomStateTrinityAdapter(@NotNull CustomTaskState state) {
            super((Object)state.getPresentableName(), null, (Object)state.getId());
            this.myState = state;
        }

        @NotNull
        static List<CustomStateTrinityAdapter> wrapList(@NotNull Collection<? extends CustomTaskState> states) {
            return ContainerUtil.map(states, state -> new CustomStateTrinityAdapter((CustomTaskState)state));
        }

        @NotNull
        static List<CustomTaskState> unwrapList(@NotNull Collection<? extends CustomStateTrinityAdapter> wrapped) {
            return ContainerUtil.map(wrapped, adapter -> adapter.myState);
        }
    }
}

