/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl;

import com.intellij.debugger.streams.trace.PrevAwareState;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.impl.StateBase;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TerminationStateImpl
extends StateBase
implements PrevAwareState {
    private final TraceElement myResult;
    private final StreamCall myPrevCall;
    private final Map<TraceElement, List<TraceElement>> myToPrev;

    TerminationStateImpl(@NotNull TraceElement result, @NotNull StreamCall prevCall, @NotNull List<TraceElement> elements2, @NotNull Map<TraceElement, List<TraceElement>> toPrevMapping) {
        super(elements2);
        this.myResult = result;
        this.myPrevCall = prevCall;
        this.myToPrev = toPrevMapping;
    }

    @Override
    @NotNull
    public List<Value> getRawValues() {
        return Collections.singletonList(this.myResult.getValue());
    }

    @Override
    @NotNull
    public StreamCall getPrevCall() {
        return this.myPrevCall;
    }

    @Override
    @NotNull
    public List<TraceElement> getPrevValues(@NotNull TraceElement value) {
        return this.myToPrev.getOrDefault(value, Collections.emptyList());
    }
}

