/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve.impl;

import com.intellij.debugger.streams.resolve.ResolvedStreamCall;
import com.intellij.debugger.streams.resolve.ResolvedStreamChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResolvedStreamChainImpl
implements ResolvedStreamChain {
    private final ResolvedStreamCall.Terminator myTerminator;
    private final List<ResolvedStreamCall.Intermediate> myIntermediateCalls;

    ResolvedStreamChainImpl(@NotNull ResolvedStreamCall.Terminator terminator, @NotNull List<ResolvedStreamCall.Intermediate> intermediates) {
        this.myTerminator = terminator;
        this.myIntermediateCalls = Collections.unmodifiableList(new ArrayList<ResolvedStreamCall.Intermediate>(intermediates));
    }

    @Override
    @NotNull
    public ResolvedStreamCall.Terminator getTerminator() {
        return this.myTerminator;
    }

    @Override
    @NotNull
    public List<ResolvedStreamCall.Intermediate> getIntermediateCalls() {
        return this.myIntermediateCalls;
    }

    public static class Builder {
        private final List<ResolvedStreamCall.Intermediate> myIntermediates = new ArrayList<ResolvedStreamCall.Intermediate>();
        private ResolvedStreamCall.Terminator myTerminator;

        public void addIntermediate(@NotNull ResolvedStreamCall.Intermediate intermediate) {
            this.myIntermediates.add(intermediate);
        }

        public void setTerminator(@NotNull ResolvedStreamCall.Terminator terminator) {
            this.myTerminator = terminator;
        }

        public ResolvedStreamChain build() {
            if (this.myTerminator == null) {
                throw new IllegalStateException("terminator not specified");
            }
            return new ResolvedStreamChainImpl(this.myTerminator, this.myIntermediates);
        }
    }
}

