/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FlatMapResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Map<Integer, TraceElement> before = info.getValuesOrderBefore();
        Map<Integer, TraceElement> after = info.getValuesOrderAfter();
        HashMap<TraceElement, List<TraceElement>> forward = new HashMap<TraceElement, List<TraceElement>>();
        HashMap<TraceElement, List<TraceElement>> backward = new HashMap<TraceElement, List<TraceElement>>();
        int[] beforeTimes = before.keySet().stream().mapToInt(Integer::intValue).toArray();
        int[] afterTimes = after.keySet().stream().mapToInt(Integer::intValue).toArray();
        int beforeIndex = 0;
        for (int i = 0; i < beforeTimes.length; ++i) {
            int nextBeforeTime;
            TraceElement afterElement = before.get(beforeTimes[i]);
            ArrayList<TraceElement> afterElements = new ArrayList<TraceElement>();
            int n = nextBeforeTime = i + 1 < beforeTimes.length ? beforeTimes[i + 1] : Integer.MAX_VALUE;
            while (beforeIndex < afterTimes.length && afterTimes[beforeIndex] < nextBeforeTime) {
                TraceElement beforeElement = after.get(afterTimes[beforeIndex]);
                afterElements.add(beforeElement);
                backward.put(beforeElement, Collections.singletonList(afterElement));
                ++beforeIndex;
            }
            forward.put(afterElement, afterElements);
        }
        return ValuesOrderResolver.Result.of(forward, backward);
    }
}

