/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.action;

import com.intellij.debugger.streams.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChainResolver {
    private static final Logger LOG = Logger.getInstance(ChainResolver.class);
    private ChainsSearchResult mySearchResult = new ChainsSearchResult(0L, -1L, null);

    ChainResolver() {
    }

    @NotNull
    ChainStatus tryFindChain(@NotNull PsiElement elementAtDebugger) {
        if (this.mySearchResult.isSuitableFor(elementAtDebugger)) {
            return this.mySearchResult.chainsStatus;
        }
        this.mySearchResult = ChainsSearchResult.of(elementAtDebugger);
        ChainResolver.checkChainsExistenceInBackground(elementAtDebugger, this.mySearchResult);
        return this.mySearchResult.chainsStatus;
    }

    private static void checkChainsExistenceInBackground(@NotNull PsiElement elementAtDebugger, @NotNull ChainsSearchResult searchResult) {
        List<LibrarySupportProvider> extensions = ChainResolver.forLanguage(elementAtDebugger.getLanguage());
        if (extensions.isEmpty()) {
            searchResult.markUnsupportedLanguage();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)elementAtDebugger.getProject()).runReadActionInSmartMode(() -> {
                boolean found;
                LibrarySupportProvider provider = (LibrarySupportProvider)ExtensionProcessingHelper.findFirstSafe(p -> p.getChainBuilder().isChainExists(elementAtDebugger), (Iterable)extensions);
                boolean bl = found = provider != null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Chains found:" + found);
                }
                searchResult.updateStatus(found);
            }));
        }
    }

    @NotNull
    List<StreamChainWithLibrary> getChains(@NotNull PsiElement elementAtDebugger) {
        if (!this.mySearchResult.isSuitableFor(elementAtDebugger) || !this.mySearchResult.chainsStatus.equals((Object)ChainStatus.FOUND)) {
            LOG.error("Cannot build chains: " + (Object)((Object)this.mySearchResult.chainsStatus));
            return Collections.emptyList();
        }
        ArrayList<StreamChainWithLibrary> chains = new ArrayList<StreamChainWithLibrary>();
        String elementLanguageId = elementAtDebugger.getLanguage().getID();
        LibrarySupportProvider.EP_NAME.forEachExtensionSafe(provider -> {
            StreamChainBuilder chainBuilder;
            if (provider.getLanguageId().equals(elementLanguageId) && (chainBuilder = provider.getChainBuilder()).isChainExists(elementAtDebugger)) {
                for (StreamChain x : chainBuilder.build(elementAtDebugger)) {
                    chains.add(new StreamChainWithLibrary(x, (LibrarySupportProvider)provider));
                }
            }
        });
        return chains;
    }

    @NotNull
    private static List<LibrarySupportProvider> forLanguage(@NotNull Language language) {
        return LibrarySupportProvider.EP_NAME.getByGroupingKey((Object)language.getID(), ChainResolver.class, LibrarySupportProvider::getLanguageId);
    }

    private static class ChainsSearchResult {
        final long elementHash;
        final long offset;
        final long fileModificationStamp;
        @NotNull
        volatile ChainStatus chainsStatus = ChainStatus.COMPUTING;

        ChainsSearchResult(long elementHash, long offsetInFile, @Nullable PsiFile containingFile) {
            this.elementHash = elementHash;
            this.fileModificationStamp = ChainsSearchResult.getModificationStamp(containingFile);
            this.offset = offsetInFile;
        }

        private static long getModificationStamp(@Nullable PsiFile file) {
            return file == null ? -1L : file.getModificationStamp();
        }

        @NotNull
        static ChainsSearchResult of(@NotNull PsiElement element) {
            return new ChainsSearchResult(element.hashCode(), element.getTextOffset(), element.getContainingFile());
        }

        void updateStatus(boolean found) {
            LOG.assertTrue(ChainStatus.COMPUTING.equals((Object)this.chainsStatus));
            this.chainsStatus = found ? ChainStatus.FOUND : ChainStatus.NOT_FOUND;
        }

        void markUnsupportedLanguage() {
            LOG.assertTrue(ChainStatus.COMPUTING.equals((Object)this.chainsStatus));
            this.chainsStatus = ChainStatus.LANGUAGE_NOT_SUPPORTED;
        }

        boolean isSuitableFor(@NotNull PsiElement element) {
            return this.elementHash == (long)element.hashCode() && this.offset == (long)element.getTextOffset() && this.fileModificationStamp == ChainsSearchResult.getModificationStamp(element.getContainingFile());
        }
    }

    static final class StreamChainWithLibrary {
        final StreamChain chain;
        final LibrarySupportProvider provider;

        StreamChainWithLibrary(@NotNull StreamChain chain, @NotNull LibrarySupportProvider provider) {
            this.chain = chain;
            this.provider = provider;
        }
    }

    static enum ChainStatus {
        LANGUAGE_NOT_SUPPORTED,
        COMPUTING,
        FOUND,
        NOT_FOUND;

    }
}

