/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.structureView;

import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.structureView.YAMLStructureViewFactory;

class YAMLStructureViewUtil {
    private YAMLStructureViewUtil() {
    }

    @Nullable
    static String getKeyValueLocationString(@NotNull YAMLKeyValue kv) {
        YAMLValue value = kv.getValue();
        if (value instanceof YAMLScalar) {
            return kv.getValueText();
        }
        if (value instanceof YAMLAlias) {
            return YAMLStructureViewFactory.getAliasPresentableText((YAMLAlias)value);
        }
        return null;
    }

    @Nullable
    static Icon getKeyValueIcon(@NotNull YAMLKeyValue kv) {
        YAMLValue value = kv.getValue();
        if (value instanceof YAMLScalar) {
            return kv.getIcon(0);
        }
        if (value instanceof YAMLAlias) {
            return YAMLStructureViewFactory.ALIAS_ICON;
        }
        return PlatformIcons.XML_TAG_ICON;
    }

    @NotNull
    static String getSeqItemPresentableText(@Nullable YAMLValue itemValue) {
        if (itemValue instanceof YAMLScalar) {
            return ((YAMLScalar)itemValue).getTextValue();
        }
        if (itemValue instanceof YAMLAlias) {
            return YAMLStructureViewFactory.getAliasPresentableText((YAMLAlias)itemValue);
        }
        return YAMLBundle.message("YAMLStructureViewSequenceItem.element.name", new Object[0]);
    }

    @NotNull
    static Icon getSeqItemIcon(@Nullable YAMLValue itemValue) {
        if (itemValue instanceof YAMLScalar) {
            return PlatformIcons.PROPERTY_ICON;
        }
        if (itemValue instanceof YAMLAlias) {
            return YAMLStructureViewFactory.ALIAS_ICON;
        }
        return PlatformIcons.XML_TAG_ICON;
    }
}

