/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.schema.YamlEmptyObjectAdapter;
import org.jetbrains.yaml.schema.YamlObjectAdapter;
import org.jetbrains.yaml.schema.YamlPropertyAdapter;

public class YamlJsonPsiWalker
implements JsonLikePsiWalker {
    public static final YamlJsonPsiWalker INSTANCE = new YamlJsonPsiWalker();

    private YamlJsonPsiWalker() {
    }

    public ThreeState isName(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof YAMLDocument || parent instanceof YAMLMapping) {
            return ThreeState.YES;
        }
        if (parent instanceof YAMLKeyValue && YamlJsonPsiWalker.isFirstChild(element, parent)) {
            ASTNode prev = element.getNode().getTreePrev();
            return prev.getElementType() == YAMLTokenTypes.INDENT ? ThreeState.YES : ThreeState.NO;
        }
        if (parent instanceof YAMLSequenceItem && YamlJsonPsiWalker.isFirstChild(element, parent)) {
            return ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    private static boolean isFirstChild(PsiElement element, PsiElement parent) {
        PsiElement[] children = parent.getChildren();
        return children.length != 0 && children[0] == element;
    }

    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        return element instanceof YAMLKeyValue && ((YAMLKeyValue)element).getValue() != null;
    }

    public boolean isTopJsonElement(@NotNull PsiElement element) {
        return element instanceof YAMLFile || element instanceof YAMLDocument;
    }

    public boolean acceptsEmptyRoot() {
        return true;
    }

    public PsiElement findElementToCheck(@NotNull PsiElement element) {
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (!(current instanceof YAMLValue) && !(current instanceof YAMLKeyValue)) continue;
            return current;
        }
        return null;
    }

    public boolean requiresNameQuotes() {
        return false;
    }

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        return element instanceof YAMLValue ? YamlPropertyAdapter.createValueAdapterByType((YAMLValue)element) : (element instanceof YAMLDocument ? new YamlEmptyObjectAdapter(element) : null);
    }

    public boolean allowsSingleQuotes() {
        return true;
    }

    public boolean hasMissingCommaAfter(@NotNull PsiElement element) {
        return false;
    }

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        YAMLMapping mapping = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLMapping.class, (boolean)true, (Class[])new Class[]{YAMLKeyValue.class});
        if (mapping != null) {
            return new YamlPropertyAdapter(element.getParent());
        }
        YAMLKeyValue property = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class, (boolean)false);
        if (property == null) {
            return null;
        }
        YAMLValue value = property.getValue();
        if (value == null || !PsiTreeUtil.isAncestor((PsiElement)value, (PsiElement)element, (boolean)true)) {
            return null;
        }
        return new YamlPropertyAdapter((PsiElement)property);
    }

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement originalPosition, PsiElement computedPosition) {
        YAMLMapping object = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, YAMLMapping.class);
        YAMLMapping otherObject = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)computedPosition, YAMLMapping.class);
        if (object == null || otherObject != null && PsiTreeUtil.isAncestor((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)object), (PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)otherObject), (boolean)true)) {
            object = otherObject;
        }
        if (object == null) {
            return Collections.emptySet();
        }
        return new YamlObjectAdapter(object).getPropertyList().stream().map(p -> p.getName()).collect(Collectors.toSet());
    }

    @Nullable
    public JsonPointerPosition findPosition(@NotNull PsiElement element, boolean forceLastTransition) {
        JsonPointerPosition pos = new JsonPointerPosition();
        PsiElement current = element;
        while (!YamlJsonPsiWalker.breakCondition(current)) {
            String propertyName;
            PsiElement position = current;
            if ((current = current.getParent()) instanceof YAMLSequence) {
                YAMLSequence array = (YAMLSequence)current;
                List<YAMLSequenceItem> expressions = array.getItems();
                int idx = -1;
                for (int i = 0; i < expressions.size(); ++i) {
                    YAMLSequenceItem value = expressions.get(i);
                    if (!position.equals(value)) continue;
                    idx = i;
                    break;
                }
                if (idx == -1) continue;
                pos.addPrecedingStep(idx);
                continue;
            }
            if (current instanceof YAMLSequenceItem) continue;
            if (current instanceof YAMLKeyValue) {
                propertyName = StringUtil.notNullize((String)((YAMLKeyValue)current).getName());
                if (!((current = current.getParent()) instanceof YAMLMapping)) {
                    return null;
                }
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (current instanceof YAMLMapping && position instanceof YAMLKeyValue) {
                propertyName = StringUtil.notNullize((String)((YAMLKeyValue)position).getName());
                if (propertyName.contains("IntellijIdeaRulezzz")) continue;
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (YamlJsonPsiWalker.breakCondition(current)) break;
            if (current instanceof YAMLMapping) {
                List<YAMLPsiElement> elements = ((YAMLMapping)current).getYAMLElements();
                if (elements.size() == 0) {
                    return null;
                }
                if (position instanceof YAMLPsiElement && elements.contains(position)) continue;
            }
            return null;
        }
        return pos;
    }

    private static boolean breakCondition(PsiElement current) {
        return current instanceof PsiFile || current instanceof YAMLDocument || current instanceof YAMLBlockMappingImpl && current.getParent() instanceof YAMLDocument;
    }

    public boolean requiresValueQuotes() {
        return false;
    }

    public String getDefaultObjectValue() {
        return "";
    }

    public String getDefaultArrayValue() {
        return "- ";
    }

    public boolean hasWhitespaceDelimitedCodeBlocks() {
        return true;
    }

    public String getNodeTextForValidation(PsiElement element) {
        String text = element.getText();
        if (!StringUtil.startsWith((CharSequence)text, (CharSequence)"!!") && !StringUtil.startsWithChar((CharSequence)text, (char)'&')) {
            return text;
        }
        int spaceIndex = text.indexOf(32);
        return spaceIndex > 0 ? text.substring(spaceIndex + 1) : text;
    }

    public TextRange adjustErrorHighlightingRange(@NotNull PsiElement element) {
        YAMLAnchor[] anchors = (YAMLAnchor[])PsiTreeUtil.getChildrenOfType((PsiElement)element, YAMLAnchor.class);
        if (anchors == null || anchors.length == 0) {
            return element.getTextRange();
        }
        YAMLAnchor lastAnchor = anchors[anchors.length - 1];
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)lastAnchor);
        return next == null ? element.getTextRange() : next.getTextRange();
    }

    public JsonLikeSyntaxAdapter getSyntaxAdapter(final Project project) {
        return new JsonLikeSyntaxAdapter(){
            private final YAMLElementGenerator myGenerator;
            {
                this.myGenerator = YAMLElementGenerator.getInstance(project);
            }

            @Nullable
            public PsiElement getPropertyValue(PsiElement property) {
                assert (property instanceof YAMLKeyValue);
                YAMLValue value = ((YAMLKeyValue)property).getValue();
                if (value == null) {
                    return null;
                }
                return this.adjustValue((PsiElement)value);
            }

            @NotNull
            public PsiElement adjustValue(@NotNull PsiElement value) {
                if (!(value instanceof YAMLValue)) {
                    return value;
                }
                YAMLAnchor[] anchors = (YAMLAnchor[])PsiTreeUtil.getChildrenOfType((PsiElement)value, YAMLAnchor.class);
                if (anchors == null || anchors.length == 0) {
                    return value;
                }
                PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)anchors[anchors.length - 1]);
                return next == null ? value : next;
            }

            @Nullable
            public String getPropertyName(PsiElement property) {
                assert (property instanceof YAMLKeyValue);
                return ((YAMLKeyValue)property).getName();
            }

            private YAMLKeyValue findPrecedingKeyValueWithNoValue(PsiElement element) {
                if (PsiUtilCore.getElementType((PsiElement)element) == YAMLTokenTypes.INDENT) {
                    PsiElement prev = element.getPrevSibling();
                    PsiElement psiElement = prev = prev == null ? null : PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prev);
                    if (prev instanceof YAMLKeyValue && ((YAMLKeyValue)prev).getValue() == null) {
                        return (YAMLKeyValue)prev;
                    }
                }
                return null;
            }

            @NotNull
            public PsiElement createProperty(@NotNull String name, @NotNull String value, PsiElement element) {
                YAMLKeyValue keyValue = this.myGenerator.createYamlKeyValue(name, StringUtil.unquoteString((String)value));
                return element instanceof YAMLDocument || this.findPrecedingKeyValueWithNoValue(element) != null ? this.myGenerator.createDummyYamlWithText(keyValue.getText()).getDocuments().get(0).getFirstChild() : keyValue;
            }

            public boolean ensureComma(PsiElement self, PsiElement newElement) {
                if (newElement instanceof YAMLKeyValue && self instanceof YAMLKeyValue) {
                    self.getParent().addAfter(this.myGenerator.createEol(), self);
                }
                return false;
            }

            public void removeIfComma(PsiElement forward) {
                if (forward instanceof LeafPsiElement && ((LeafPsiElement)forward).getElementType() == YAMLTokenTypes.EOL) {
                    PsiElement nextSibling;
                    while ((nextSibling = forward.getNextSibling()) instanceof LeafPsiElement && ((LeafPsiElement)nextSibling).getElementType() == YAMLTokenTypes.INDENT) {
                        nextSibling.delete();
                    }
                    forward.delete();
                }
            }

            public boolean fixWhitespaceBefore(PsiElement initialElement, PsiElement element) {
                return initialElement instanceof YAMLValue && initialElement != element;
            }

            @NotNull
            public String getDefaultValueFromType(@Nullable JsonSchemaType type) {
                if (type == null) {
                    return "";
                }
                if (type == JsonSchemaType._object) {
                    return " ";
                }
                if (type == JsonSchemaType._array) {
                    return " - ";
                }
                return type.getDefaultValue();
            }

            public PsiElement adjustNewProperty(PsiElement element) {
                if (element instanceof YAMLMapping) {
                    return element.getFirstChild();
                }
                return element;
            }

            public PsiElement adjustPropertyAnchor(LeafPsiElement element) {
                YAMLKeyValue keyValue = this.findPrecedingKeyValueWithNoValue((PsiElement)element);
                assert (keyValue != null) : "Should come here only for YAMLKeyValue with no value and a following indent";
                PsiComment nextComment = (PsiComment)ObjectUtils.tryCast((Object)this.skipNonNewlineSpaces(keyValue), PsiComment.class);
                if (nextComment != null) {
                    keyValue.addBefore(this.myGenerator.createSpace(), null);
                    keyValue.addBefore(nextComment.copy(), null);
                }
                keyValue.addBefore(this.myGenerator.createEol(), null);
                keyValue.addBefore(this.myGenerator.createIndent(element.getTextLength()), null);
                PsiElement prev = element.getPrevSibling();
                if (prev != null) {
                    prev.delete();
                }
                element.delete();
                if (nextComment != null) {
                    nextComment.delete();
                }
                return keyValue;
            }

            @Nullable
            private PsiElement skipNonNewlineSpaces(YAMLKeyValue keyValue) {
                PsiElement sibling = keyValue.getNextSibling();
                while (sibling instanceof PsiWhiteSpace && !sibling.getText().contains("\n")) {
                    sibling = sibling.getNextSibling();
                }
                return sibling;
            }
        };
    }

    public PsiElement getParentContainer(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class), (Class[])new Class[]{YAMLMapping.class, YAMLSequence.class});
    }

    @NotNull
    public Collection<PsiElement> getRoots(@NotNull PsiFile file) {
        if (!(file instanceof YAMLFile)) {
            return ContainerUtil.emptyList();
        }
        HashSet<PsiElement> roots = new HashSet<PsiElement>();
        for (YAMLDocument document : ((YAMLFile)file).getDocuments()) {
            YAMLValue topLevelValue = document.getTopLevelValue();
            roots.add((PsiElement)(topLevelValue == null ? document : topLevelValue));
        }
        return roots;
    }

    @Nullable
    public PsiElement getPropertyNameElement(PsiElement property) {
        return property instanceof YAMLKeyValue ? ((YAMLKeyValue)property).getKey() : null;
    }
}

