/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public abstract class YamlUnknownValuesInspectionBase
extends YamlMetaTypeInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        return new ValuesChecker(holder, metaTypeProvider);
    }

    protected static class ValuesChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        private final YamlMetaTypeProvider myMetaTypeProvider;
        private final ProblemsHolder myProblemsHolder;

        public ValuesChecker(@NotNull ProblemsHolder problemsHolder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
            this.myProblemsHolder = problemsHolder;
            this.myMetaTypeProvider = metaTypeProvider;
        }

        @Override
        protected void visitYAMLSequenceItem(@NotNull YAMLSequenceItem item) {
            YAMLValue value = item.getValue();
            if (value == null) {
                return;
            }
            if (value instanceof YAMLKeyValue || value instanceof YAMLMapping) {
                return;
            }
            YamlMetaTypeProvider.MetaTypeProxy meta = this.myMetaTypeProvider.getValueMetaType(value);
            if (meta != null && meta.getField().isMany()) {
                meta.getMetaType().validateValue(value, this.myProblemsHolder);
            }
        }

        @Override
        protected void visitYAMLKeyValue(@NotNull YAMLKeyValue keyValue) {
            if (keyValue.getKey() == null) {
                return;
            }
            YamlMetaTypeProvider.MetaTypeProxy meta = this.myMetaTypeProvider.getKeyValueMetaType(keyValue);
            if (meta == null) {
                return;
            }
            YAMLValue value = keyValue.getValue();
            if (value == null) {
                this.validateEmptyValue(meta.getField(), keyValue);
                return;
            }
            this.validateMultiplicity(meta, value);
            meta.getMetaType().validateKey(keyValue, this.myProblemsHolder);
            if (value instanceof YAMLMapping || value instanceof YAMLSequence) {
                return;
            }
            meta.getMetaType().validateValue(value, this.myProblemsHolder);
        }

        @Override
        protected void visitYAMLMapping(@NotNull YAMLMapping mapping) {
            YamlMetaTypeProvider.MetaTypeProxy meta = this.myMetaTypeProvider.getValueMetaType(mapping);
            if (meta != null) {
                meta.getMetaType().validateValue(mapping, this.myProblemsHolder);
            }
        }

        protected void validateMultiplicity(@NotNull YamlMetaTypeProvider.MetaTypeProxy meta, @NotNull YAMLValue value) {
            if (meta.getField().isMany()) {
                this.requireMultiplicityMany(meta, value);
            } else {
                this.requireMultiplicityOne(meta, value);
            }
        }

        protected void requireMultiplicityOne(@NotNull YamlMetaTypeProvider.MetaTypeProxy meta, @NotNull YAMLValue value) {
            if (meta.getField().hasRelationSpecificType(Field.Relation.SEQUENCE_ITEM)) {
                return;
            }
            if (value instanceof YAMLSequence) {
                for (YAMLSequenceItem next : ((YAMLSequence)value).getItems()) {
                    if (next.getValue() == null || !next.getKeysValues().isEmpty()) continue;
                    this.myProblemsHolder.registerProblem((PsiElement)next.getValue(), YAMLBundle.message("YamlUnknownValuesInspectionBase.error.array.not.allowed", new Object[0]), new LocalQuickFix[0]);
                }
            }
        }

        protected void requireMultiplicityMany(@NotNull YamlMetaTypeProvider.MetaTypeProxy meta, @NotNull YAMLValue value) {
            boolean actuallyOne;
            if (meta.getField().hasRelationSpecificType(Field.Relation.OBJECT_CONTENTS)) {
                return;
            }
            boolean bl = actuallyOne = value instanceof YAMLScalar || value instanceof YAMLMapping && !meta.getField().isAnyNameAllowed();
            if (actuallyOne) {
                this.myProblemsHolder.registerProblem((PsiElement)value, YAMLBundle.message("YamlUnknownValuesInspectionBase.error.array.is.required", new Object[0]), new LocalQuickFix[0]);
            }
        }

        protected void validateEmptyValue(@NotNull Field feature, @NotNull YAMLKeyValue withoutValue) {
            assert (withoutValue.getKey() != null);
            if (!feature.isEmptyValueAllowed()) {
                InspectionManager manager = this.myProblemsHolder.getManager();
                ProblemDescriptor eolError = manager.createProblemDescriptor(withoutValue.getKey(), YAMLBundle.message("YamlUnknownValuesInspectionBase.error.value.is.required", ArrayUtil.EMPTY_OBJECT_ARRAY), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myProblemsHolder.isOnTheFly(), true);
                this.myProblemsHolder.registerProblem(eolError);
            }
        }
    }
}

