/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlMetaType;

@ApiStatus.Internal
public abstract class YamlKeyInsertHandler
implements InsertHandler<LookupElement> {
    private final boolean myNeedsSequenceItem;

    public YamlKeyInsertHandler(boolean needsSequenceItem) {
        this.myNeedsSequenceItem = needsSequenceItem;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        String lookupString;
        if (!YamlKeyInsertHandler.needsColon(context)) {
            return;
        }
        YamlMetaType.ForcedCompletionPath path = Optional.of(item.getObject()).filter(YamlMetaType.ForcedCompletionPath.class::isInstance).map(YamlMetaType.ForcedCompletionPath.class::cast).orElse(null);
        if (path != null) {
            lookupString = this.getReplacement();
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)lookupString);
        } else {
            lookupString = item.getLookupString();
        }
        String commonPadding = YamlKeyInsertHandler.getIndentation(context, lookupString);
        YamlMetaType.YamlInsertionMarkup insertionMarkup = this.computeInsertionMarkup(context, path != null ? path : YamlMetaType.ForcedCompletionPath.nullPath());
        commonPadding = this.insertBeforeItem(context, lookupString, commonPadding, insertionMarkup);
        insertionMarkup.insertStringAndCaret(context.getEditor(), commonPadding);
    }

    @NotNull
    protected abstract YamlMetaType.YamlInsertionMarkup computeInsertionMarkup(@NotNull InsertionContext var1, @NotNull YamlMetaType.ForcedCompletionPath var2);

    @NotNull
    protected abstract String getReplacement();

    private static boolean needsColon(@NotNull InsertionContext context) {
        String tail = YamlKeyInsertHandler.getTailString(context);
        for (int i = 0; i < tail.length(); ++i) {
            char next = tail.charAt(i);
            if (next == ':') {
                return false;
            }
            if (!YamlKeyInsertHandler.isCRLF(next)) continue;
            return true;
        }
        return true;
    }

    protected String insertBeforeItem(@NotNull InsertionContext context, @NotNull String lookupString, @NotNull String commonPadding_, @NotNull YamlMetaType.YamlInsertionMarkup markup) {
        String COLON = ":";
        String ITEM_MARK = "- ";
        String sameLineBeforeItem = YamlKeyInsertHandler.getHeadStringOnCurrentLine(context, lookupString);
        StringBuilder toBeInserted = new StringBuilder();
        StringBuilder toBeRemoved = new StringBuilder();
        StringBuilder totalPadding = new StringBuilder(commonPadding_);
        if (sameLineBeforeItem.contains(":")) {
            String afterColonBeforeItem = StringUtil.substringAfterLast((String)sameLineBeforeItem, (String)":");
            if (StringUtil.isEmptyOrSpaces((String)afterColonBeforeItem)) {
                toBeRemoved.append(afterColonBeforeItem);
            }
            totalPadding.append(markup.getTabSymbol());
            toBeInserted.append('\n').append((CharSequence)totalPadding);
            sameLineBeforeItem = totalPadding.toString();
        }
        if (this.myNeedsSequenceItem && !sameLineBeforeItem.endsWith("- ")) {
            toBeInserted.append("- ");
            totalPadding.append(StringUtil.repeat((String)" ", (int)"- ".length()));
        }
        if (toBeInserted.length() != 0) {
            Editor editor = context.getEditor();
            int currentOffset = editor.getCaretModel().getOffset();
            int insertedItemStart = currentOffset - lookupString.length();
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                Document document = editor.getDocument();
                document.replaceString(insertedItemStart - toBeRemoved.length(), insertedItemStart, (CharSequence)toBeInserted);
                editor.getCaretModel().moveToOffset(currentOffset + toBeInserted.length() - toBeRemoved.length());
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
            }));
        }
        return totalPadding.toString();
    }

    @NotNull
    private static String getTailString(@NotNull InsertionContext context) {
        return context.getDocument().getText().substring(context.getTailOffset());
    }

    @NotNull
    private static String getHeadString(@NotNull InsertionContext context, @NotNull String lookupString) {
        return context.getDocument().getText().substring(0, context.getTailOffset() - lookupString.length());
    }

    @NotNull
    private static String getHeadStringOnCurrentLine(InsertionContext context, @NotNull String lookupString) {
        String head = YamlKeyInsertHandler.getHeadString(context, lookupString);
        int lineStart = -1;
        for (int idx = head.length() - 1; idx >= 0; --idx) {
            char next = head.charAt(idx);
            if (!YamlKeyInsertHandler.isCRLF(next)) continue;
            lineStart = idx;
            break;
        }
        return head.substring(lineStart + 1);
    }

    @NotNull
    private static String getIndentation(InsertionContext context, @NotNull String lookupString) {
        String currentLineHead = YamlKeyInsertHandler.getHeadStringOnCurrentLine(context, lookupString);
        String spaces = YamlKeyInsertHandler.getLeadingSpacesStartingFrom(currentLineHead, 0);
        int spacesLength = spaces.length();
        if (spacesLength < currentLineHead.length() && currentLineHead.charAt(spacesLength) == '-') {
            spaces = spaces + " " + YamlKeyInsertHandler.getLeadingSpacesStartingFrom(currentLineHead, spacesLength + "-".length());
        }
        return spaces;
    }

    @NotNull
    private static String getLeadingSpacesStartingFrom(String text, int startIdx) {
        int firstNotSpace = text.length();
        for (int idx = startIdx; idx < text.length(); ++idx) {
            char next = text.charAt(idx);
            if (Character.isWhitespace(next)) continue;
            firstNotSpace = idx;
            break;
        }
        return text.substring(startIdx, firstNotSpace);
    }

    private static boolean isCRLF(char c) {
        return c == '\n' || c == '\r';
    }
}

