/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

public class YAMLDuplicatedKeysInspection
extends LocalInspectionTool {
    @NotNull
    public final PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new YamlPsiElementVisitor(){

            @Override
            public void visitMapping(@NotNull YAMLMapping mapping) {
                MultiMap occurrences = new MultiMap();
                for (YAMLKeyValue keyValue : mapping.getKeyValues()) {
                    String keyName = keyValue.getKeyText().trim();
                    if (keyName.equals("<<") || keyName.isEmpty()) continue;
                    occurrences.putValue((Object)keyName, (Object)keyValue);
                }
                for (Map.Entry entry : occurrences.entrySet()) {
                    if (((Collection)entry.getValue()).size() <= 1) continue;
                    ((Collection)entry.getValue()).forEach(duplicatedKey -> {
                        assert (duplicatedKey.getKey() != null);
                        assert (duplicatedKey.getParentMapping() != null) : "This key is gotten from mapping";
                        holder.registerProblem(duplicatedKey.getKey(), YAMLBundle.message("YAMLDuplicatedKeysInspection.duplicated.key", entry.getKey()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveDuplicatedKeyQuickFix((YAMLKeyValue)duplicatedKey)});
                    });
                }
            }
        };
    }

    private static class RemoveDuplicatedKeyQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<YAMLKeyValue> myKeyValueHolder;

        RemoveDuplicatedKeyQuickFix(@NotNull YAMLKeyValue keyValue) {
            this.myKeyValueHolder = SmartPointerManager.getInstance((Project)keyValue.getProject()).createSmartPsiElementPointer((PsiElement)keyValue);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return YAMLBundle.message("YAMLDuplicatedKeysInspection.remove.key.quickfix.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            YAMLKeyValue keyVal = (YAMLKeyValue)this.myKeyValueHolder.getElement();
            if (keyVal == null || keyVal.getParentMapping() == null) {
                return;
            }
            keyVal.getParentMapping().deleteKeyValue(keyVal);
        }
    }
}

