/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding.decoder;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.decoder.ByteBuffer;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.transport.Transport;

public class RichCursorDecoder
extends Decoder {
    @Override
    public void decode(Transport transport, Renderer renderer, FramebufferUpdateRectangle rect) throws TransportException {
        int bytesPerPixel = renderer.getBytesPerPixel();
        int length = rect.width * rect.height * bytesPerPixel;
        if (0 == length) {
            return;
        }
        byte[] buffer = ByteBuffer.getInstance().getBuffer(length);
        transport.readBytes(buffer, 0, length);
        StringBuilder sb = new StringBuilder(" ");
        for (int i = 0; i < length; ++i) {
            sb.append(Integer.toHexString(buffer[i] & 0xFF)).append(" ");
        }
        int scanLine = (rect.width + 7) / 8;
        byte[] bitmask = new byte[scanLine * rect.height];
        transport.readBytes(bitmask, 0, bitmask.length);
        sb = new StringBuilder(" ");
        for (byte aBitmask : bitmask) {
            sb.append(Integer.toHexString(aBitmask & 0xFF)).append(" ");
        }
        int[] cursorPixels = new int[rect.width * rect.height];
        for (int y = 0; y < rect.height; ++y) {
            for (int x = 0; x < rect.width; ++x) {
                int offset = y * rect.width + x;
                cursorPixels[offset] = this.isBitSet(bitmask[y * scanLine + x / 8], x % 8) ? 0xFF000000 | renderer.getPixelColor(buffer, offset * bytesPerPixel) : 0;
            }
        }
        renderer.createCursor(cursorPixels, rect);
    }

    private boolean isBitSet(byte aByte, int index) {
        return (aByte & 1 << 7 - index) > 0;
    }
}

