/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import org.jcodings.specific.NonStrictUTF8Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.regex.TextMateRange;

public class RegexUtil {
    private RegexUtil() {
    }

    public static int codePointOffsetByByteOffset(byte[] stringBytes, int byteOffset) {
        if (byteOffset <= 0) {
            return 0;
        }
        return NonStrictUTF8Encoding.INSTANCE.strLength(stringBytes, 0, byteOffset);
    }

    public static int byteOffsetByCharOffset(@NotNull CharSequence charSequence, int charOffset) {
        if (charOffset <= 0) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < charOffset; ++i) {
            result += UTF8Encoding.INSTANCE.codeToMbcLength((int)charSequence.charAt(i));
        }
        return result;
    }

    @NotNull
    public static TextMateRange codePointsRangeByByteRange(byte[] bytes, @NotNull TextMateRange byteRange) {
        int startOffset = RegexUtil.codePointOffsetByByteOffset(bytes, byteRange.start);
        int endOffset = RegexUtil.codePointOffsetByByteOffset(bytes, byteRange.end);
        return new TextMateRange(startOffset, endOffset);
    }
}

