/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public class TextMateSelectorCachingWeigher
implements TextMateSelectorWeigher {
    @NotNull
    private final TextMateSelectorWeigher myOriginalWeigher;
    @NotNull
    private final ConcurrentMap<CacheKey, TextMateWeigh> myCache;

    public TextMateSelectorCachingWeigher(@NotNull TextMateSelectorWeigher originalWeigher) {
        this.myOriginalWeigher = originalWeigher;
        this.myCache = ContainerUtil.createConcurrentSoftKeySoftValueMap();
    }

    @Override
    public TextMateWeigh weigh(@NotNull CharSequence scopeSelector, @NotNull CharSequence scope) {
        return this.myCache.computeIfAbsent(new CacheKey(scopeSelector, scope), this::weigh);
    }

    private TextMateWeigh weigh(@NotNull CacheKey pair) {
        return this.myOriginalWeigher.weigh(pair.selector, pair.scope);
    }

    private static class CacheKey {
        final CharSequence selector;
        final CharSequence scope;

        private CacheKey(CharSequence selector, CharSequence scope) {
            this.selector = selector;
            this.scope = scope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey key = (CacheKey)o;
            return this.selector.equals(key.selector) && this.scope.equals(key.scope);
        }

        public int hashCode() {
            return Objects.hash(this.selector, this.scope);
        }
    }
}

