/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.StringWithId;

public class TextMateLexerState {
    private final int hashcode;
    @NotNull
    public final SyntaxNodeDescriptor syntaxRule;
    @NotNull
    public final MatchData matchData;
    @NotNull
    public final TextMateWeigh.Priority priorityMatch;
    @Nullable
    public final StringWithId string;

    TextMateLexerState(@NotNull SyntaxNodeDescriptor syntaxRule, @NotNull MatchData matchData, @NotNull TextMateWeigh.Priority priority, @Nullable StringWithId line) {
        this.syntaxRule = syntaxRule;
        this.matchData = matchData;
        this.priorityMatch = priority;
        this.string = matchData.matched() ? line : null;
        this.hashcode = Objects.hash(new Object[]{syntaxRule, matchData, this.priorityMatch, this.stringId()});
    }

    public static TextMateLexerState notMatched(@NotNull SyntaxNodeDescriptor syntaxRule) {
        return new TextMateLexerState(syntaxRule, MatchData.NOT_MATCHED, TextMateWeigh.Priority.NORMAL, null);
    }

    @NotNull
    public String toString() {
        return "TextMateLexerState{syntaxRule=" + this.syntaxRule + ", matchData=" + this.matchData + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMateLexerState state = (TextMateLexerState)o;
        return this.syntaxRule.equals(state.syntaxRule) && this.matchData.equals(state.matchData) && this.priorityMatch == state.priorityMatch && this.stringId() == state.stringId();
    }

    public int hashCode() {
        return this.hashcode;
    }

    @Nullable
    private Object stringId() {
        return this.string != null ? this.string.id : null;
    }
}

