/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import gnu.trove.TIntObjectHashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;

abstract class SyntaxProxyDescriptor
implements SyntaxNodeDescriptor {
    private final SyntaxNodeDescriptor myParentNode;
    private SyntaxNodeDescriptor myTargetNode;

    SyntaxProxyDescriptor(@NotNull SyntaxNodeDescriptor parentNode) {
        this.myParentNode = parentNode;
    }

    @Override
    @Nullable
    public CharSequence getStringAttribute(@NotNull Constants.StringKey key) {
        return this.getTargetNode().getStringAttribute(key);
    }

    @Override
    @Nullable
    public TIntObjectHashMap<CharSequence> getCaptures(@NotNull Constants.CaptureKey key) {
        return this.getTargetNode().getCaptures(key);
    }

    @Override
    @NotNull
    public List<SyntaxNodeDescriptor> getChildren() {
        return this.getTargetNode().getChildren();
    }

    @Override
    @NotNull
    public List<InjectionNodeDescriptor> getInjections() {
        return this.getTargetNode().getInjections();
    }

    @Override
    @NotNull
    public SyntaxNodeDescriptor findInRepository(int ruleId) {
        return this.getTargetNode().findInRepository(ruleId);
    }

    @Override
    @NotNull
    public CharSequence getScopeName() {
        return this.getTargetNode().getScopeName();
    }

    @Override
    @NotNull
    public SyntaxNodeDescriptor getParentNode() {
        return this.myParentNode;
    }

    @NotNull
    private SyntaxNodeDescriptor getTargetNode() {
        if (this.myTargetNode == null) {
            HashSet<SyntaxNodeDescriptor> visitedNodes = new HashSet<SyntaxNodeDescriptor>();
            visitedNodes.add(this);
            SyntaxNodeDescriptor targetNode = this.computeTargetNode();
            while (targetNode instanceof SyntaxProxyDescriptor) {
                if (!visitedNodes.add(targetNode)) {
                    targetNode = EMPTY_NODE;
                    break;
                }
                targetNode = ((SyntaxProxyDescriptor)targetNode).computeTargetNode();
            }
            this.myTargetNode = targetNode;
        }
        return this.myTargetNode;
    }

    protected abstract SyntaxNodeDescriptor computeTargetNode();
}

