/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import gnu.trove.TIntHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.plist.Plist;

public class PreferencesRegistry {
    @NotNull
    private final Set<Preferences> myPreferences = new HashSet<Preferences>();
    @NotNull
    private final TIntHashSet myLeftHighlightingBraces = new TIntHashSet();
    @NotNull
    private final TIntHashSet myRightHighlightingBraces = new TIntHashSet();
    @NotNull
    private final TIntHashSet myLeftSmartTypingBraces = new TIntHashSet();
    @NotNull
    private final TIntHashSet myRightSmartTypingBraces = new TIntHashSet();

    public PreferencesRegistry() {
        this.fillHighlightingBraces(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        this.fillSmartTypingBraces(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    public void fillFromPList(@NotNull CharSequence scopeName, @NotNull Plist plist) {
        Set<TextMateBracePair> highlightingPairs = PreferencesReadUtil.readPairs(plist.getPlistValue("highlightingPairs"));
        Set<TextMateBracePair> smartTypingPairs = PreferencesReadUtil.readPairs(plist.getPlistValue("smartTypingPairs"));
        this.fillHighlightingBraces(highlightingPairs);
        this.fillSmartTypingBraces(smartTypingPairs);
        if (highlightingPairs != null || smartTypingPairs != null) {
            this.myPreferences.add(new Preferences(scopeName, highlightingPairs, smartTypingPairs));
        }
    }

    public void fillHighlightingBraces(Collection<TextMateBracePair> highlightingPairs) {
        if (highlightingPairs != null) {
            for (TextMateBracePair pair : highlightingPairs) {
                this.myLeftHighlightingBraces.add((int)pair.leftChar);
                this.myRightHighlightingBraces.add((int)pair.rightChar);
            }
        }
    }

    public void fillSmartTypingBraces(Collection<TextMateBracePair> smartTypingPairs) {
        if (smartTypingPairs != null) {
            for (TextMateBracePair pair : smartTypingPairs) {
                this.myLeftSmartTypingBraces.add((int)pair.leftChar);
                this.myRightSmartTypingBraces.add((int)pair.rightChar);
            }
        }
    }

    public boolean isPossibleLeftHighlightingBrace(char c) {
        return this.myLeftHighlightingBraces.contains((int)c) || this.myLeftSmartTypingBraces.contains((int)c);
    }

    public boolean isPossibleRightHighlightingBrace(char c) {
        return this.myRightHighlightingBraces.contains((int)c) || this.myRightSmartTypingBraces.contains((int)c);
    }

    public boolean isPossibleLeftSmartTypingBrace(char c) {
        return this.myLeftSmartTypingBraces.contains((int)c);
    }

    public boolean isPossibleRightSmartTypingBrace(char c) {
        return this.myRightSmartTypingBraces.contains((int)c);
    }

    @NotNull
    public List<Preferences> getPreferences(@NotNull CharSequence scopeSelector) {
        return new TextMateScopeComparator<Preferences>(scopeSelector, Preferences::getScopeSelector).sortAndFilter(this.myPreferences);
    }

    public void clear() {
        this.myPreferences.clear();
        this.myLeftHighlightingBraces.clear();
        this.myRightHighlightingBraces.clear();
        this.fillHighlightingBraces(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        this.myLeftSmartTypingBraces.clear();
        this.myRightSmartTypingBraces.clear();
        this.fillSmartTypingBraces(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }
}

