/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.bundles.BundleType;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;

public class Bundle {
    private static final FileFilter SYNTAX_FILES_FILTER = new BundleFilesFilter("tmlanguage", "plist", "tmlanguage.json");
    private static final FileFilter PREFERENCE_FILES_FILTER = new BundleFilesFilter("tmpreferences", "plist");
    protected final String myName;
    protected final File bundleFile;
    protected final BundleType myType;

    public Bundle(@NotNull String name, @NotNull String bundle, @NotNull BundleType type) {
        this.myName = name;
        this.bundleFile = new File(bundle);
        this.myType = type;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public Collection<File> getGrammarFiles() {
        return this.getFilesInBundle(this.myType.getSyntaxesPath(), SYNTAX_FILES_FILTER);
    }

    @NotNull
    public Collection<File> getPreferenceFiles() {
        return this.getFilesInBundle(this.myType.getPreferencesPath(), PREFERENCE_FILES_FILTER);
    }

    @NotNull
    public Collection<File> getSnippetFiles() {
        return this.getFilesInBundle(this.myType.getSnippetsPath(), new BundleFilesFilter(this.myType.getSnippetFileExtensions()));
    }

    @NotNull
    public BundleType getType() {
        return this.myType;
    }

    @NotNull
    private Collection<File> getFilesInBundle(@NotNull String path, @Nullable FileFilter filter) {
        File directory = new File(this.bundleFile, path);
        File[] files = null;
        try {
            files = directory.listFiles(filter);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return files != null && files.length > 0 ? new HashSet<File>(Arrays.asList(files)) : Collections.emptySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bundle bundle = (Bundle)o;
        return FileUtil.filesEqual((File)this.bundleFile, (File)bundle.bundleFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.bundleFile);
    }

    public String toString() {
        return "Bundle{name='" + this.myName + '\'' + ", path='" + this.bundleFile + '\'' + ", type=" + (Object)((Object)this.myType) + '}';
    }

    public Collection<String> getExtensions(@NotNull File file, @NotNull Plist plist) {
        return plist.getPlistValue("fileTypes", Collections.emptyList()).getStringArray();
    }

    public List<Map.Entry<String, Plist>> loadPreferenceFile(@NotNull File file, @NotNull PlistReader plistReader) throws IOException {
        return Collections.singletonList(PreferencesReadUtil.retrieveSettingsPlist(plistReader.read(file)));
    }

    public static class BundleFilesFilter
    implements FileFilter {
        private final Set<String> myExtensions;

        public BundleFilesFilter(String ... extensions) {
            this.myExtensions = new HashSet<String>(Arrays.asList(extensions));
        }

        @Override
        public boolean accept(@NotNull File path) {
            return this.myExtensions.contains(FileUtilRt.getExtension((String)path.getName()).toLowerCase(Locale.US));
        }
    }
}

