/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringKt;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsCredentialsStore;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.git.InputStreamWrapper;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u00b0\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a2\u0010\b\u001a\u00020\u00022\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\f\u001a\u00020\u000b\u001a2\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00072\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0007\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0000\u001a:\u0010#\u001a\u00020$*\u00020\u00022\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010'\u001a\n\u0010)\u001a\u00020**\u00020\u0002\u001a\n\u0010+\u001a\u00020\u0002*\u00020\u0002\u001a,\u0010,\u001a\u0004\u0018\u00010\u0019*\u00020\u00022\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010/2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a\n\u00100\u001a\u000201*\u00020\u0002\u001a\n\u00102\u001a\u00020\u0001*\u000203\u001aq\u00104\u001a\u00020 *\u00020\u00022\u0006\u00105\u001a\u00020\u00012%\b\u0002\u00106\u001a\u001f\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(9\u0012\u0004\u0012\u00020\u000b\u0018\u00010726\u0010:\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(9\u0012\u0013\u0012\u00110<\u00a2\u0006\f\b8\u0012\b\b9\u0012\u0004\b\b(=\u0012\u0004\u0012\u00020\u000b0;\u001a\u0014\u0010>\u001a\u0004\u0018\u00010<*\u00020\u00022\u0006\u00105\u001a\u00020\u0001\u001a\n\u0010?\u001a\u00020@*\u00020\u0002\u001a\u001c\u0010A\u001a\u00020B*\u00020\u00022\b\u0010C\u001a\u0004\u0018\u00010\u00012\u0006\u0010D\u001a\u00020\u0001\u001a6\u0010E\u001a\u0002HF\"\b\b\u0000\u0010G*\u00020H\"\u0004\b\u0001\u0010F*\u0002HG2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u0002HG\u0012\u0004\u0012\u0002HF07H\u0086\b\u00a2\u0006\u0002\u0010J\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006K"}, d2={"upstream", "", "Lorg/eclipse/jgit/lib/Repository;", "getUpstream", "(Lorg/eclipse/jgit/lib/Repository;)Ljava/lang/String;", "buildBareRepository", "gitDir", "Ljava/nio/file/Path;", "buildRepository", "workTree", "bare", "", "mustExists", "cloneBare", "uri", "dir", "credentialsStore", "Lkotlin/Lazy;", "Lorg/jetbrains/settingsRepository/IcsCredentialsStore;", "progressMonitor", "Lorg/eclipse/jgit/lib/ProgressMonitor;", "createBareRepository", "findBranchToCheckout", "Lorg/eclipse/jgit/lib/Ref;", "result", "Lorg/eclipse/jgit/transport/FetchResult;", "getDefaultBranch", "credentialsProvider", "Lorg/jetbrains/settingsRepository/git/JGitCredentialsProvider;", "isAuthFailedMessage", "message", "wrapIfNeedAndReThrow", "", "e", "Lorg/eclipse/jgit/errors/TransportException;", "commit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "reflogComment", "author", "Lorg/eclipse/jgit/lib/PersonIdent;", "committer", "computeIndexDiff", "Lorg/eclipse/jgit/lib/IndexDiff;", "disableAutoCrLf", "fetch", "remoteConfig", "Lorg/eclipse/jgit/transport/RemoteConfig;", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "getAheadCommitsCount", "", "getRemoteBranchFullName", "Lorg/eclipse/jgit/lib/Config;", "processChildren", "path", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "inputStream", "read", "resetHard", "Lorg/eclipse/jgit/dircache/DirCacheCheckout;", "setUpstream", "Lorg/eclipse/jgit/lib/StoredConfig;", "url", "remoteBranchName", "use", "R", "T", "Ljava/lang/AutoCloseable;", "block", "(Ljava/lang/AutoCloseable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.settingsRepository"})
public final class GitExKt {
    public static final void wrapIfNeedAndReThrow(@NotNull TransportException e) {
        if (e instanceof org.eclipse.jgit.errors.NoRemoteRepositoryException || e.getStatus() == TransportException.Status.CANNOT_RESOLVE_REPO) {
            throw (Throwable)new NoRemoteRepositoryException(e);
        }
        String message = e.getMessage();
        if (e.getStatus() == TransportException.Status.NOT_AUTHORIZED || e.getStatus() == TransportException.Status.NOT_PERMITTED || message != null && GitExKt.isAuthFailedMessage(message)) {
            throw (Throwable)new AuthenticationException(e);
        }
        if (e.getStatus() == TransportException.Status.CANCELLED || Intrinsics.areEqual((Object)message, (Object)"Download cancelled")) {
            throw (Throwable)new ProcessCanceledException();
        }
        throw (Throwable)e;
    }

    private static final boolean isAuthFailedMessage(String message) {
        return StringsKt.contains$default((CharSequence)message, (CharSequence)JGitText.get().notAuthorized, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"Auth cancel", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"Auth fail", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)": reject HostKey:", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final FetchResult fetch(@NotNull Repository $this$fetch, @NotNull RemoteConfig remoteConfig, @Nullable CredentialsProvider credentialsProvider2, @Nullable ProgressMonitor progressMonitor) {
        try {
            FetchResult fetchResult;
            AutoCloseable $this$use$iv = (AutoCloseable)Transport.open((Repository)$this$fetch, (RemoteConfig)remoteConfig);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                Transport transport = (Transport)$this$use$iv;
                boolean bl = false;
                transport.setCredentialsProvider(credentialsProvider2);
                transport.setRemoveDeletedRefs(true);
                ProgressMonitor progressMonitor2 = progressMonitor;
                if (progressMonitor2 == null) {
                    progressMonitor2 = (ProgressMonitor)NullProgressMonitor.INSTANCE;
                }
                fetchResult = transport.fetch(progressMonitor2, null);
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        $this$use$iv.close();
                    }
                    catch (Exception closeException$iv) {
                        Exception exception = e$iv;
                        if (exception == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                        }
                        ((Throwable)exception).addSuppressed(closeException$iv);
                    }
                    throw (Throwable)e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $this$use$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
            return fetchResult;
        }
        catch (TransportException e) {
            String string = e.getMessage();
            if (string != null) {
                if (StringsKt.startsWith$default((String)string, (String)"Remote does not have ", (boolean)false, (int)2, null)) {
                    IcsManagerKt.getLOG().warn(e.getMessage());
                    return null;
                }
            }
            GitExKt.wrapIfNeedAndReThrow(e);
            return null;
        }
    }

    public static /* synthetic */ FetchResult fetch$default(Repository repository2, RemoteConfig remoteConfig, CredentialsProvider credentialsProvider2, ProgressMonitor progressMonitor, int n, Object object) {
        if ((n & 2) != 0) {
            credentialsProvider2 = null;
        }
        if ((n & 4) != 0) {
            progressMonitor = null;
        }
        return GitExKt.fetch(repository2, remoteConfig, credentialsProvider2, progressMonitor);
    }

    @NotNull
    public static final Repository disableAutoCrLf(@NotNull Repository $this$disableAutoCrLf) {
        StoredConfig config = $this$disableAutoCrLf.getConfig();
        config.setString("core", null, "autocrlf", "false");
        config.save();
        return $this$disableAutoCrLf;
    }

    @NotNull
    public static final RevCommit commit(@NotNull Repository $this$commit, @Nullable String message, @Nullable String reflogComment, @Nullable PersonIdent author, @Nullable PersonIdent committer) {
        CommitCommand commitCommand = new CommitCommand($this$commit).setAuthor(author).setCommitter(committer);
        if (message != null) {
            commitCommand.setMessage(message);
        }
        if (reflogComment != null) {
            commitCommand.setReflogComment(reflogComment);
        }
        return commitCommand.call();
    }

    public static /* synthetic */ RevCommit commit$default(Repository repository2, String string, String string2, PersonIdent personIdent, PersonIdent personIdent2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            personIdent = null;
        }
        if ((n & 8) != 0) {
            personIdent2 = null;
        }
        return GitExKt.commit(repository2, string, string2, personIdent, personIdent2);
    }

    @NotNull
    public static final DirCacheCheckout resetHard(@NotNull Repository $this$resetHard) {
        ResetCommand resetCommand = new ResetCommand($this$resetHard).setMode(ResetCommand.ResetType.HARD);
        resetCommand.call();
        DirCacheCheckout dirCacheCheckout = resetCommand.getDirCacheCheckout();
        if (dirCacheCheckout == null) {
            Intrinsics.throwNpe();
        }
        return dirCacheCheckout;
    }

    @NotNull
    public static final String getRemoteBranchFullName(@NotNull Config $this$getRemoteBranchFullName) {
        String name = $this$getRemoteBranchFullName.getString("branch", "master", "merge");
        if (StringUtil.isEmpty((String)name)) {
            throw (Throwable)new IllegalStateException("branch.master.merge refspec must be specified");
        }
        String string = name;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Nullable
    public static final String getUpstream(@NotNull Repository $this$upstream) {
        return StringKt.nullize$default((String)$this$upstream.getConfig().getString("remote", "origin", "url"), (boolean)false, (int)1, null);
    }

    @NotNull
    public static final StoredConfig setUpstream(@NotNull Repository $this$setUpstream, @Nullable String url, @NotNull String remoteBranchName) {
        String localBranchName = "master";
        StoredConfig config = $this$setUpstream.getConfig();
        String remoteName = "origin";
        CharSequence charSequence = url;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            IcsManagerKt.getLOG().debug("Unset remote");
            config.unsetSection("remote", remoteName);
            config.unsetSection("branch", localBranchName);
        } else {
            IcsManagerKt.getLOG().debug("Set remote " + url);
            config.setString("remote", remoteName, "url", url);
            char c = '+';
            String string = "refs/heads/";
            bl2 = false;
            config.setString("remote", remoteName, "fetch", String.valueOf(c) + string + remoteBranchName + ':' + "refs/remotes/" + remoteName + '/' + remoteBranchName);
            config.setString("branch", localBranchName, "remote", remoteName);
            config.setString("branch", localBranchName, "merge", "refs/heads/" + remoteBranchName);
        }
        config.save();
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final IndexDiff computeIndexDiff(@NotNull Repository $this$computeIndexDiff) {
        FileTreeIterator workingTreeIterator = new FileTreeIterator($this$computeIndexDiff);
        try {
            IndexDiff indexDiff = new IndexDiff($this$computeIndexDiff, "HEAD", (WorkingTreeIterator)workingTreeIterator);
            return indexDiff;
        }
        finally {
            workingTreeIterator.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Repository cloneBare(@NotNull String uri, @NotNull Path dir, @Nullable Lazy<IcsCredentialsStore> credentialsStore2, @NotNull ProgressMonitor progressMonitor) {
        RevWalk it;
        Repository repository2 = GitExKt.createBareRepository(dir);
        JGitCredentialsProvider credentialsProvider2 = credentialsStore2 == null ? null : new JGitCredentialsProvider(credentialsStore2, repository2);
        String string = GitExKt.getDefaultBranch(uri, credentialsProvider2);
        if (string == null) {
            string = "master";
        }
        StoredConfig config = GitExKt.setUpstream(repository2, uri, string);
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, "origin");
        FetchResult fetchResult = GitExKt.fetch(repository2, remoteConfig, credentialsProvider2, progressMonitor);
        if (fetchResult == null) {
            return repository2;
        }
        FetchResult result = fetchResult;
        Ref head = GitExKt.findBranchToCheckout(result);
        if (head == null) {
            Ref ref;
            String branch = "HEAD";
            Ref ref2 = result.getAdvertisedRef(branch);
            if (ref2 == null) {
                ref2 = ref = result.getAdvertisedRef("refs/heads/" + branch);
            }
            if (ref2 == null) {
                ref = head = result.getAdvertisedRef("refs/tags/" + branch);
            }
        }
        if (head == null || head.getObjectId() == null) {
            return repository2;
        }
        if (StringsKt.startsWith$default((String)head.getName(), (String)"refs/heads/", (boolean)false, (int)2, null)) {
            RefUpdate newHead = repository2.updateRef("HEAD");
            newHead.disableRefLog();
            newHead.link(head.getName());
            String branchName = Repository.shortenRefName((String)head.getName());
            config.setString("branch", branchName, "remote", "origin");
            config.setString("branch", branchName, "merge", head.getName());
            String autoSetupRebase = config.getString("branch", null, "autosetuprebase");
            if (Intrinsics.areEqual((Object)"always", (Object)autoSetupRebase) || Intrinsics.areEqual((Object)"remote", (Object)autoSetupRebase)) {
                config.setBoolean("branch", branchName, "rebase", true);
            }
            config.save();
        }
        AutoCloseable $this$use$iv = (AutoCloseable)new RevWalk(repository2);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            it = (RevWalk)$this$use$iv;
            boolean bl = false;
            it = it.parseCommit((AnyObjectId)head.getObjectId());
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $this$use$iv.close();
                }
                catch (Exception closeException$iv) {
                    Exception exception = e$iv;
                    if (exception == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)exception).addSuppressed(closeException$iv);
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $this$use$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        RevWalk commit2 = it;
        RefUpdate u = repository2.updateRef("HEAD", !StringsKt.startsWith$default((String)head.getName(), (String)"refs/heads/", (boolean)false, (int)2, null));
        u.setNewObjectId((AnyObjectId)commit2.getId());
        u.forceUpdate();
        return repository2;
    }

    public static /* synthetic */ Repository cloneBare$default(String string, Path path, Lazy lazy, ProgressMonitor progressMonitor, int n, Object object) {
        if ((n & 4) != 0) {
            lazy = null;
        }
        if ((n & 8) != 0) {
            progressMonitor = (ProgressMonitor)NullProgressMonitor.INSTANCE;
        }
        return GitExKt.cloneBare(string, path, (Lazy<IcsCredentialsStore>)lazy, progressMonitor);
    }

    /*
     * WARNING - void declaration
     */
    private static final String getDefaultBranch(String uri, JGitCredentialsProvider credentialsProvider2) {
        Map remoteRefs = ((LsRemoteCommand)new LsRemoteCommand(null).setRemote(uri).setTags(false).setCredentialsProvider((CredentialsProvider)credentialsProvider2)).callAsMap();
        Ref remoteHeadRef = (Ref)remoteRefs.get("HEAD");
        if (remoteHeadRef != null) {
            Object object = remoteRefs;
            boolean bl = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void refName;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = (String)entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Ref ref = (Ref)entry2.getValue();
                if (ref == remoteHeadRef || !Intrinsics.areEqual((Object)ref.getObjectId(), (Object)remoteHeadRef.getObjectId())) continue;
                return StringsKt.removePrefix((String)refName, (CharSequence)"refs/heads/");
            }
        }
        return null;
    }

    private static final Ref findBranchToCheckout(FetchResult result) {
        Object v1;
        block3: {
            Ref ref = result.getAdvertisedRef("HEAD");
            if (ref == null) {
                return null;
            }
            Ref idHead = ref;
            Ref master = result.getAdvertisedRef("refs/heads/master");
            if (master != null && Intrinsics.areEqual((Object)master.getObjectId(), (Object)idHead.getObjectId())) {
                return master;
            }
            Iterable $this$firstOrNull$iv = result.getAdvertisedRefs();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Ref it = (Ref)element$iv;
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it.getName(), (String)"refs/heads/", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)it.getObjectId(), (Object)idHead.getObjectId()))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void processChildren(@NotNull Repository $this$processChildren, @NotNull String path, @Nullable Function1<? super String, Boolean> filter, @NotNull Function2<? super String, ? super InputStream, Boolean> processor) {
        TreeWalk rootTreeWalk;
        ObjectReader reader;
        boolean closed$iv;
        AutoCloseable $this$use$iv;
        block23: {
            block21: {
                block22: {
                    ObjectId objectId = $this$processChildren.resolve("FETCH_HEAD");
                    if (objectId == null) {
                        return;
                    }
                    ObjectId lastCommitId = objectId;
                    $this$use$iv = (AutoCloseable)$this$processChildren.newObjectReader();
                    boolean $i$f$use = false;
                    closed$iv = false;
                    reader = (ObjectReader)$this$use$iv;
                    boolean bl = false;
                    rootTreeWalk = TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])new AnyObjectId[]{(AnyObjectId)new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()});
                    if (rootTreeWalk != null) break block21;
                    Logger $this$debug$iv = IcsManagerKt.getLOG();
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if (!$this$debug$iv.isDebugEnabled()) break block22;
                    Logger logger = $this$debug$iv;
                    boolean bl2 = false;
                    String string = path + " not found";
                    logger.debug(string, (Throwable)e$iv);
                }
                $this$use$iv.close();
                return;
            }
            if (rootTreeWalk.isSubtree()) break block23;
            IcsManagerKt.getLOG().warn("File " + path + " is not a directory");
            $this$use$iv.close();
            return;
        }
        try {
            TreeWalk treeWalk = new TreeWalk($this$processChildren);
            treeWalk.addTree((AnyObjectId)rootTreeWalk.getObjectId(0));
            treeWalk.setRecursive(false);
            while (treeWalk.next()) {
                boolean bl;
                FileMode fileMode = treeWalk.getFileMode(0);
                if (!Intrinsics.areEqual((Object)fileMode, (Object)FileMode.REGULAR_FILE) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.SYMLINK) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.EXECUTABLE_FILE)) continue;
                String fileName = treeWalk.getNameString();
                if (filter != null && !((Boolean)filter.invoke((Object)fileName)).booleanValue()) continue;
                ObjectLoader objectLoader = reader.open((AnyObjectId)treeWalk.getObjectId(0), 3);
                if (objectLoader.getSize() == 0L) {
                    IcsManagerKt.getLOG().warn("File " + path + " skipped because empty (length 0)");
                    continue;
                }
                AutoCloseable $this$use$iv2 = (AutoCloseable)objectLoader.openStream();
                boolean $i$f$use = false;
                boolean closed$iv2 = false;
                try {
                    ObjectStream it = (ObjectStream)$this$use$iv2;
                    boolean bl3 = false;
                    bl = (Boolean)processor.invoke((Object)fileName, (Object)it);
                }
                catch (Exception e$iv) {
                    try {
                        closed$iv2 = true;
                        try {
                            $this$use$iv2.close();
                        }
                        catch (Exception closeException$iv) {
                            Exception exception = e$iv;
                            if (exception == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                            }
                            ((Throwable)exception).addSuppressed(closeException$iv);
                        }
                        throw (Throwable)e$iv;
                    }
                    catch (Throwable throwable) {
                        if (!closed$iv2) {
                            $this$use$iv2.close();
                        }
                        throw throwable;
                    }
                }
                $this$use$iv2.close();
                if (bl) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $this$use$iv.close();
                }
                catch (Exception closeException$iv) {
                    Exception exception = e$iv;
                    if (exception == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)exception).addSuppressed(closeException$iv);
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $this$use$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
    }

    public static /* synthetic */ void processChildren$default(Repository repository2, String string, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        GitExKt.processChildren(repository2, string, (Function1<? super String, Boolean>)function1, (Function2<? super String, ? super InputStream, Boolean>)function2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final InputStream read(@NotNull Repository $this$read, @NotNull String path) {
        ObjectStream input;
        ObjectReader reader;
        block7: {
            TreeWalk treeWalk;
            boolean releaseReader;
            block6: {
                InputStream inputStream;
                ObjectId lastCommitId = $this$read.resolve("HEAD");
                if (lastCommitId == null) {
                    IcsManagerKt.getLOG().warn("Repository " + $this$read.getDirectory().getName() + " doesn't have HEAD");
                    return null;
                }
                reader = $this$read.newObjectReader();
                releaseReader = true;
                try {
                    if (TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])new AnyObjectId[]{(AnyObjectId)new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId).getTree()}) != null) break block6;
                    inputStream = null;
                }
                catch (Throwable throwable) {
                    if (releaseReader) {
                        reader.close();
                    }
                    throw throwable;
                }
                reader.close();
                return inputStream;
            }
            TreeWalk treeWalk2 = treeWalk;
            ObjectLoader objectLoader = reader.open((AnyObjectId)treeWalk2.getObjectId(0), 3);
            input = objectLoader.openStream();
            if (!objectLoader.isLarge()) break block7;
            releaseReader = false;
            InputStream inputStream = new InputStreamWrapper((InputStream)input, reader);
            return inputStream;
        }
        InputStream inputStream = (InputStream)input;
        reader.close();
        return inputStream;
    }

    public static final int getAheadCommitsCount(@NotNull Repository $this$getAheadCommitsCount) {
        RevCommit revCommit;
        StoredConfig config = $this$getAheadCommitsCount.getConfig();
        String shortBranchName = Repository.shortenRefName((String)GitExKt.getRemoteBranchFullName((Config)config));
        String string = new BranchConfig((Config)config, shortBranchName).getTrackingBranch();
        if (string == null) {
            return -1;
        }
        String trackingBranch = string;
        Ref ref = $this$getAheadCommitsCount.exactRef("refs/heads/" + shortBranchName);
        if (ref == null) {
            return -1;
        }
        Ref local = ref;
        RevWalk walk = new RevWalk($this$getAheadCommitsCount);
        RevCommit localCommit = walk.parseCommit((AnyObjectId)local.getObjectId());
        Ref ref2 = $this$getAheadCommitsCount.findRef(trackingBranch);
        if (ref2 != null) {
            Ref ref3 = ref2;
            boolean bl = false;
            boolean bl2 = false;
            Ref it = ref3;
            boolean bl3 = false;
            revCommit = walk.parseCommit((AnyObjectId)it.getObjectId());
        } else {
            revCommit = null;
        }
        RevCommit trackingCommit = revCommit;
        walk.setRevFilter(RevFilter.MERGE_BASE);
        if (trackingCommit == null) {
            walk.markStart(localCommit);
            walk.sort(RevSort.REVERSE);
        } else {
            walk.markStart(localCommit);
            walk.markStart(trackingCommit);
            RevCommit mergeBase = walk.next();
            walk.reset();
            walk.markStart(localCommit);
            walk.markUninteresting(mergeBase);
        }
        walk.setRevFilter(RevFilter.ALL);
        return CollectionsKt.count((Iterable)((Iterable)walk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends AutoCloseable, R> R use(@NotNull T $this$use, @NotNull Function1<? super T, ? extends R> block) {
        Object object;
        int $i$f$use = 0;
        boolean closed = false;
        try {
            object = block.invoke($this$use);
        }
        catch (Exception e) {
            try {
                closed = true;
                try {
                    $this$use.close();
                }
                catch (Exception closeException) {
                    Exception exception = e;
                    if (exception == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)exception).addSuppressed(closeException);
                }
                throw (Throwable)e;
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                if (!closed) {
                    $this$use.close();
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart((int)1);
        $this$use.close();
        InlineMarker.finallyEnd((int)1);
        return (R)object;
    }

    @NotNull
    public static final Repository buildRepository(@Nullable Path workTree, boolean bare, @Nullable Path gitDir, boolean mustExists) {
        Path it;
        boolean bl;
        boolean bl2;
        Path path;
        BaseRepositoryBuilder baseRepositoryBuilder = new FileRepositoryBuilder().setUseSystemConfig(false);
        boolean bl3 = false;
        boolean bl4 = false;
        FileRepositoryBuilder $this$with = (FileRepositoryBuilder)baseRepositoryBuilder;
        boolean bl5 = false;
        if (bare) {
            $this$with.setBare();
        } else {
            Path path2 = workTree;
            if (path2 != null) {
                path = path2;
                bl2 = false;
                bl = false;
                it = path;
                boolean bl6 = false;
                FileRepositoryBuilder cfr_ignored_0 = (FileRepositoryBuilder)$this$with.setWorkTree(it.toFile());
            }
        }
        Path path3 = gitDir;
        if (path3 != null) {
            path = path3;
            bl2 = false;
            bl = false;
            it = path;
            boolean bl7 = false;
            FileRepositoryBuilder cfr_ignored_1 = (FileRepositoryBuilder)$this$with.setGitDir(gitDir.toFile());
        }
        $this$with.setMustExist(mustExists);
        return $this$with.build();
    }

    public static /* synthetic */ Repository buildRepository$default(Path path, boolean bl, Path path2, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            path = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            path2 = null;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return GitExKt.buildRepository(path, bl, path2, bl2);
    }

    @NotNull
    public static final Repository buildBareRepository(@NotNull Path gitDir) {
        return GitExKt.buildRepository$default(null, true, gitDir, false, 9, null);
    }

    @NotNull
    public static final Repository createBareRepository(@NotNull Path dir) {
        Repository repository2 = GitExKt.buildRepository$default(null, true, dir, false, 9, null);
        repository2.create(true);
        return repository2;
    }
}

