/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils.stream;

import com.jetbrains.sourceglider.utils.FileHelper;
import com.jetbrains.sourceglider.utils.stream.RSAKey;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class RSAInputStream
extends InputStream {
    private InputStream stream;
    private RSAKey key;
    private BigInteger code;
    private int pos;
    private int[] buffer;

    public RSAInputStream(InputStream stream, RSAKey key) throws IOException {
        this.stream = stream;
        this.key = key;
        this.pos = 0;
        this.buffer = new int[key.blockSize];
    }

    @Override
    public int read() throws IOException {
        if (this.pos == 0) {
            this.code = FileHelper.readBigIntFromStream(this.stream);
            this.code = this.code.modPow(this.key.exponent, this.key.modulus);
            this.pos = this.key.blockSize;
            for (int i2 = 0; i2 < this.pos; ++i2) {
                this.buffer[i2] = this.code.mod(BigInteger.valueOf(256L)).intValue();
                this.code = this.code.divide(BigInteger.valueOf(256L));
            }
        }
        return this.buffer[--this.pos] - 128 & 0xFF;
    }
}

