/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

import com.intellij.util.ArrayUtil;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.ui.Messages;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ArrayHelper {
    public static <T> T[] castArray(Object[] array, Class<T> type) {
        Object[] result2 = ArrayUtil.newArray(type, (int)array.length);
        System.arraycopy(array, 0, result2, 0, array.length);
        return result2;
    }

    public static String[] castStringArray(Object[] array) {
        String[] result2 = (String[])ArrayUtil.newArray(String.class, (int)array.length);
        System.arraycopy(array, 0, result2, 0, array.length);
        return result2;
    }

    public static int[] castIntArray(Object[] array) {
        int[] result2 = new int[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result2[i2] = (Integer)array[i2];
        }
        return result2;
    }

    public static Object[] toArray(Collection<?> collection, Class<?> type) {
        Object[] array = collection.toArray();
        return ArrayHelper.castArray(array, type);
    }

    public static int searchElement(Object[] array, Object element) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (!array[i2].equals(element)) continue;
            return i2;
        }
        return -1;
    }

    public static boolean containsElement(Object[] array, Object element) {
        return ArrayHelper.searchElement(array, element) != -1;
    }

    public static boolean haveCommonElements(Object[] array1, Object[] array2) {
        for (Object anArray1 : array1) {
            for (Object anArray2 : array2) {
                if (!anArray1.equals(anArray2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean haveSameElems(int[] array) {
        int[] copy2 = new int[array.length];
        System.arraycopy(array, 0, copy2, 0, array.length);
        Arrays.sort(copy2);
        for (int i2 = 0; i2 < copy2.length - 1; ++i2) {
            if (copy2[i2] != copy2[i2 + 1]) continue;
            return true;
        }
        return false;
    }

    public static Object[][] removeColumn(Object[][] array, int index, Class<Attribute> clazz) {
        if (array.length == 0) {
            return array;
        }
        Object[][] result2 = (Object[][])Array.newInstance(clazz, array.length, array[0].length - 1);
        for (int i2 = 0; i2 < array.length; ++i2) {
            for (int j = 0; j < array[i2].length; ++j) {
                if (j < index) {
                    result2[i2][j] = array[i2][j];
                    continue;
                }
                if (j <= index) continue;
                result2[i2][j - 1] = array[i2][j];
            }
        }
        return result2;
    }

    public static Object[][] swapColumns(Object[][] array, int index1, int index2, Class<Attribute> clazz) {
        if (array.length == 0) {
            return array;
        }
        Object[][] result2 = (Object[][])Array.newInstance(clazz, array.length, array[0].length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            System.arraycopy(array[i2], 0, result2[i2], 0, array[i2].length);
            result2[i2][index1] = array[i2][index2];
            result2[i2][index2] = array[i2][index1];
        }
        return result2;
    }

    public static Object[] deleteElement(Object[] array, int index, Class<Domain> type) {
        Object[] result2 = ArrayUtil.newArray(type, (int)(array.length - 1));
        System.arraycopy(array, 0, result2, 0, index);
        System.arraycopy(array, index + 1, result2, index, array.length - index - 1);
        return result2;
    }

    public static <T> T[] deleteElement(T[] array, Object element, Class<T> type) {
        Object[] result2 = ArrayUtil.newArray(type, (int)(array.length - 1));
        int index = ArrayHelper.searchElement(array, element);
        if (index == -1) {
            throw new IllegalArgumentException(Messages.getString(ArrayHelper.class.getName() + "-0"));
        }
        System.arraycopy(array, 0, result2, 0, index);
        System.arraycopy(array, index + 1, result2, index, array.length - index - 1);
        return result2;
    }

    public static Object[] mergeArrays(Object[] array1, Object[] array2, Class<?> type) {
        Object[] result2 = ArrayUtil.newArray(type, (int)(array1.length + array2.length));
        System.arraycopy(array1, 0, result2, 0, array1.length);
        System.arraycopy(array2, 0, result2, array1.length, array2.length);
        return result2;
    }

    public static Object[] uniteArrays(Object[] array1, Object[] array2, Class<Domain> type) {
        HashSet<Object> set = new HashSet<Object>();
        Object[] cat = new Object[array1.length + array2.length];
        int len = 0;
        for (Object anArray1 : array1) {
            cat[len++] = anArray1;
            set.add(anArray1);
        }
        for (Object anArray2 : array2) {
            if (set.contains(anArray2)) continue;
            cat[len++] = anArray2;
        }
        Object[] result2 = ArrayUtil.newArray(type, (int)len);
        System.arraycopy(cat, 0, result2, 0, len);
        return result2;
    }

    public static boolean setEqual(Object[] array1, Object[] array2) {
        HashSet set = new HashSet();
        Collections.addAll(set, array1);
        for (Object anArray2 : array2) {
            if (!set.contains(anArray2)) {
                return false;
            }
            set.remove(anArray2);
        }
        for (Object anArray1 : array1) {
            if (!set.contains(anArray1)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i2 = 0; i2 < array1.length; ++i2) {
            if (array1[i2].equals(array2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] array1, byte[] array2, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            if (array1[i2] == array2[i2]) continue;
            return false;
        }
        return true;
    }

    public static Object[] getIthRow(Object[][] matrix, int row, Class<?> clazz) {
        Object[] result2 = ArrayUtil.newArray(clazz, (int)matrix.length);
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            result2[i2] = matrix[i2][row];
        }
        return result2;
    }

    public static List<Integer> getFirstRow(List<int[]> matrix) {
        ArrayList<Integer> result2 = new ArrayList<Integer>();
        for (int[] aMatrix : matrix) {
            result2.add(new Integer(aMatrix[0]));
        }
        return result2;
    }

    public static Object[] getFirstRow(Object[][] matrix, Class<?> clazz) {
        Object[] result2 = ArrayUtil.newArray(clazz, (int)matrix.length);
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            result2[i2] = matrix[i2][0];
        }
        return result2;
    }

    public static int[] getFirstRow(int[][] matrix) {
        int[] result2 = new int[matrix.length];
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            result2[i2] = matrix[i2][0];
        }
        return result2;
    }

    public static int[] resizeIntArray(int[] array, int length) {
        int[] newArray = new int[length];
        System.arraycopy(array, 0, newArray, 0, length);
        return newArray;
    }

    public static Object[] copyArray(Object[] array, Class<?> clazz) {
        Object[] result2 = ArrayUtil.newArray(clazz, (int)array.length);
        System.arraycopy(array, 0, result2, 0, array.length);
        return result2;
    }

    public static Object[] flipArray(Object[] array, Class<?> clazz) {
        Object[] result2 = ArrayUtil.newArray(clazz, (int)array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            result2[i2] = array[array.length - 1 - i2];
        }
        return result2;
    }
}

