/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.ui.console;

import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.PrettyNameFormatter;
import com.jetbrains.sourceglider.ui.console.Console;
import com.jetbrains.sourceglider.utils.SortedArrayHelper;

public class RelationsConsole {
    private final Console console;
    private int[] metrics;
    protected Domain[] domains;
    protected Attribute[][] attributes;
    private PrettyNameFormatter prettyNameFormatter = new PrettyNameFormatter();
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    public static final int DEFAULT_MAX_TUPLES = 100;

    public RelationsConsole(Console console) {
        this.console = console;
    }

    public void print(IRelation relation, String preHeader, Attribute revealableHeader, String postHeader, SymbolTable symbolTable) {
        Console console = this.console;
        console.print(Messages.getString(RelationsConsole.class.getName() + "-0") + preHeader);
        console.printAttribute(revealableHeader);
        console.print(postHeader + "\":\n");
        this.print(relation, 100, SortedArrayHelper.getIDPerm(relation.getDomains().length), symbolTable, false);
    }

    public void print(IRelation relation, String header, SymbolTable symbolTable) {
        this.console.print(Messages.getString(RelationsConsole.class.getName() + "-1") + header + "\":\n");
        this.print(relation, 100, SortedArrayHelper.getIDPerm(relation.getDomains().length), symbolTable, false);
    }

    public void print(IRelation relation, String header, int maxAttributes, int[] permutation, SymbolTable symbolTable, boolean printBddNodes) {
        this.console.print(Messages.getString(RelationsConsole.class.getName() + "-2") + header + "\":\n");
        this.print(relation, maxAttributes, permutation, symbolTable, printBddNodes);
    }

    private void print(IRelation relation, int maxAttributes, int[] permutation, SymbolTable symbolTable, boolean printBddNodes) {
        if (maxAttributes == -1) {
            maxAttributes = 100;
        }
        this.domains = relation.getDomains();
        this.attributes = relation.getAttributes(maxAttributes, symbolTable);
        long totalAttributes = relation.getNumOfTuples();
        long bddNodesCnt = relation.getNumOfBDDNodes();
        this.printNumOfTuples(totalAttributes);
        if (printBddNodes) {
            this.printNumOfBDDNodes(bddNodesCnt);
        }
        if (totalAttributes > (long)maxAttributes) {
            this.console.print(Messages.getString(RelationsConsole.class.getName() + "-3") + maxAttributes + Messages.getString(RelationsConsole.class.getName() + "-4"));
        }
        SortedArrayHelper.sortAscending((Object[])this.attributes, (arg0, arg1) -> {
            Attribute[] str1 = (Attribute[])arg0;
            Attribute[] str2 = (Attribute[])arg1;
            for (int i2 = 0; i2 < str1.length; ++i2) {
                int cmp = str1[permutation[i2]].compareTo(str2[permutation[i2]]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        });
        this.printRelation();
    }

    protected void printRelation() {
        this.metrics = new int[this.domains.length];
        for (int i2 = 0; i2 < this.domains.length; ++i2) {
            this.metrics[i2] = this.domains[i2].getType().getName().length();
        }
        for (Attribute[] tuple : this.attributes) {
            for (int j = 0; j < tuple.length; ++j) {
                int len = this.prettyNameFormatter.formatDefault(tuple[j].getPrettyName()).getMarked().length();
                if (len <= this.metrics[j]) continue;
                this.metrics[j] = len;
            }
        }
        this.console.println();
        this.printHeader();
        for (Attribute[] attribute : this.attributes) {
            this.printTuple(attribute);
        }
        this.console.println();
    }

    private void printHeader() {
        int i2;
        int max = this.domains.length - 1;
        Console console = this.console;
        for (i2 = 0; i2 <= max; ++i2) {
            String name = this.domains[i2].getType().getName();
            console.print(" " + name);
            if (i2 >= max) continue;
            this.separateFileds(i2, name.length());
        }
        console.println();
        for (i2 = 0; i2 < this.metrics.length; ++i2) {
            if (i2 > 0) {
                console.print(PLUS);
            }
            console.print(MINUS);
            for (int j = 0; j <= this.metrics[i2]; ++j) {
                console.print(MINUS);
            }
        }
        console.println();
    }

    protected void printNumOfTuples(long numOfTuples) {
        this.console.println(Messages.getString(RelationsConsole.class.getName() + "-5") + numOfTuples);
    }

    protected void printNumOfBDDNodes(long numOfBDDNodes) {
        this.console.println(Messages.getString(RelationsConsole.class.getName() + "-6") + numOfBDDNodes);
    }

    private void printTuple(Attribute[] tuple) {
        int max = tuple.length - 1;
        Console console = this.console;
        for (int i2 = 0; i2 <= max; ++i2) {
            Attribute attr = tuple[i2];
            console.print(" ");
            console.printAttribute(attr);
            if (i2 >= max) continue;
            this.separateFileds(i2, this.prettyNameFormatter.formatDefault(attr.getPrettyName()).getMarked().length());
        }
        console.println();
    }

    private void separateFileds(int idx, int len) {
        StringBuilder delimStr = new StringBuilder();
        for (int i2 = len; i2 < this.metrics[idx]; ++i2) {
            delimStr.append(' ');
        }
        delimStr.append(" |");
        this.console.print(delimStr.toString());
    }
}

