/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtPrint;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.StatementComplexPrint;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import java.util.ArrayList;
import java.util.List;

public class StatementPrint
extends Nonterm {
    public Stmt stmt;
    public StatementComplexPrint complex;
    private List printValues = new ArrayList();
    private List<Integer> printTypes = new ArrayList<Integer>();
    private boolean isPrintln;

    public StatementPrint(Context context2) {
        super(context2);
    }

    public void print(TokenInfo token) {
        this.isPrintln = false;
    }

    public void println(TokenInfo token) {
        this.isPrintln = true;
    }

    public void relvar(TokenInfo token) {
        this.printValues.add(token.getString());
        this.printTypes.add(new Integer(1));
    }

    public void size(TokenInfo token) {
        this.printValues.add(token.getString());
        this.printTypes.add(new Integer(6));
    }

    public void numvar(TokenInfo token) {
        this.printValues.add(token.getString());
        if (this.context.variablesManager.getVariableType(token.getString()) == 1) {
            this.printTypes.add(new Integer(3));
        } else {
            this.printTypes.add(new Integer(4));
        }
    }

    public void number(TokenInfo token) {
        this.printValues.add(Integer.toString(token.getValue()));
        this.printTypes.add(new Integer(2));
    }

    public void strConst(TokenInfo token) {
        this.printValues.add(token.getString());
        this.printTypes.add(new Integer(2));
    }

    public void regexp(TokenInfo token) {
        this.printValues.add(token.getString());
        this.printTypes.add(new Integer(5));
    }

    public void endl(TokenInfo token) {
        this.printValues.add("\n");
        this.printTypes.add(new Integer(2));
    }

    public void complex() {
        this.printValues.add(this.complex.getBundle());
        this.printTypes.add(new Integer(0));
    }

    public void finish() {
        if (this.isPrintln) {
            this.printValues.add("\n");
            this.printTypes.add(new Integer(2));
        }
        this.stmt = new StmtPrint(this.printTypes, this.printValues, this.context);
    }
}

