/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.util.List;
import java.util.Map;

public class RelExprSingleAttribute
extends RelExpr {
    private String domain;
    private String attribute;
    private boolean equ;

    public RelExprSingleAttribute(String domainType, String attribute, boolean equ, Context context2) {
        super(context2);
        this.domain = domainType;
        this.attribute = attribute;
        this.equ = equ;
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        IRelation result2;
        Domain dom = variablesManager.getDomain(this.domain);
        int value = symbolTable.findAttributeInt(dom.getType(), this.attribute);
        if (value == -1) {
            uiInstancesProvider.getConsole().println(Messages.getString(RelExprSingleAttribute.class.getName() + "-0") + this.attribute + Messages.getString(RelExprSingleAttribute.class.getName() + "-1"));
            result2 = relationsManager.makeEmptyRelation(new Domain[]{dom});
        } else {
            result2 = relationsManager.makeSingleTuple(dom, value);
        }
        if (!this.equ) {
            IRelation oldResult = result2;
            result2 = result2.complement(threadCallback);
            oldResult.kill();
        }
        return result2;
    }

    @Override
    public void collectDomainConstraints(Map<String, List> constraints, VariablesManager variablesManager) {
    }
}

