/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts;

import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.scripts.Script;
import com.jetbrains.sourceglider.scripts.rml.RMLParseErrorCallback;
import com.jetbrains.sourceglider.scripts.rml.RMLScript;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import com.jetbrains.sourceglider.utils.Formatter;
import com.jetbrains.sourceglider.utils.StringHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ScriptManager {
    public static String KEY_SCRIPT_TIME = "ScriptTime";
    private final Map<String, Script> nameToScript = new HashMap<String, Script>();

    public Script[] getAvailableScripts() {
        return ArrayHelper.castArray(this.nameToScript.values().toArray(), Script.class);
    }

    public void addScript(Script script) {
        if (script != null) {
            this.nameToScript.put(script.getName(), script);
        }
    }

    public Script getScript(String name) {
        return this.nameToScript.get(name);
    }

    public void deleteScript(String name) {
        this.nameToScript.remove(name);
    }

    public String[] getMissingRelations(Script script, RelationsRepository repository) {
        RelationSignature[] inputRelations;
        HashSet<String> relations = new HashSet<String>();
        for (RelationSignature inputRelation : inputRelations = script.getInputRelations()) {
            relations.add(inputRelation.getName());
        }
        relations.removeAll(Arrays.asList(repository.getAvailableRelations()));
        return ArrayHelper.castStringArray(relations.toArray());
    }

    public void run(Script script, Map options2, RelationsRepository repository, ThreadCallback threadCallback, UIInstancesProvider uiInstancesProvider) {
        String[] missingRelations = this.getMissingRelations(script, repository);
        if (missingRelations.length > 0) {
            uiInstancesProvider.getUICallback().showError(Messages.getString(ScriptManager.class.getName() + "-0") + StringHelper.makeCommaList(missingRelations) + Messages.getString(ScriptManager.class.getName() + "-1"), false);
            return;
        }
        uiInstancesProvider.getConsole().println(Messages.getString(ScriptManager.class.getName() + "-2") + script.getName() + "\"...");
        long time = System.currentTimeMillis();
        script.run(repository, options2, threadCallback, uiInstancesProvider.getConsole());
        time = System.currentTimeMillis() - time;
        String scriptTime = Formatter.formatTime((int)time);
        options2.put(KEY_SCRIPT_TIME, scriptTime);
        uiInstancesProvider.getConsole().println(Messages.getString(ScriptManager.class.getName() + "-4") + script.getName() + (threadCallback.checkCancelled() ? Messages.getString(ScriptManager.class.getName() + "-7") : Messages.getString(ScriptManager.class.getName() + "-5")) + scriptTime);
    }

    public boolean refresh(RMLParseErrorCallback rmlCallback) {
        String[] names;
        for (String name : names = ArrayHelper.castStringArray(this.nameToScript.keySet().toArray())) {
            if (!(this.nameToScript.get(name) instanceof RMLScript)) continue;
            RMLScript script = (RMLScript)this.nameToScript.get(name);
            rmlCallback.setScriptURL(script.getURL());
            if (script.getURL() != null && script.compile(rmlCallback)) {
                this.nameToScript.remove(name);
                this.nameToScript.put(script.getName(), script);
                continue;
            }
            return false;
        }
        return true;
    }
}

