/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider;

import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.relations.dump.Dump;
import com.jetbrains.sourceglider.relations.dump.RelationsTextDump;
import com.jetbrains.sourceglider.scripts.rml.RMLParseErrorCallback;
import com.jetbrains.sourceglider.ui.ConsoleUI;
import com.jetbrains.sourceglider.ui.DummyThreadCallback;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.Task;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UICallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.ui.console.ConsoleCommandProcessor;
import com.jetbrains.sourceglider.ui.console.RelationsConsole;
import com.jetbrains.sourceglider.visitors.Visitor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ConsoleMain {
    private static UICallback ui;

    public static void main(String[] args) {
        final UIInstancesProvider provider2 = new UIInstancesProvider();
        provider2.setRelationsConsole(new RelationsConsole(provider2.getConsole()));
        ui = new ConsoleUI();
        provider2.setUICallback(ui);
        final ManagerInstancesProvider managerInstancesProvider = new ManagerInstancesProvider(){

            @Override
            protected void registerVisitors() {
                String loadFile = provider2.getConfigs().getValue("DumpLocation", Messages.getString(ConsoleMain.class.getName() + "-3"), "");
                final RelationsTextDump dump2 = new RelationsTextDump(loadFile, this);
                ui.runAsyncThread(new Task(Messages.getString(ConsoleMain.class.getName() + "-4")){

                    @Override
                    public void run(ThreadCallback threadCallback) {
                        this.getSymbolTable().setAllowDomainsResize(true);
                        dump2.readDomainsFromDump(threadCallback, this.getSymbolTable());
                    }
                });
                this.visitorsManager.addVisitor(new Visitor(){

                    @Override
                    public String getName() {
                        return Messages.getString(ConsoleMain.class.getName() + "-5");
                    }

                    @Override
                    public String getDescription() {
                        return null;
                    }

                    @Override
                    public RelationSignature[] getOutputRelations() {
                        return dump2.getSignatures();
                    }

                    @Override
                    public String getMetaInfo(String key) {
                        return null;
                    }

                    @Override
                    public Map<String, String> getMetaInfos(String relation) {
                        return new HashMap<String, String>();
                    }

                    @Override
                    public void initRelations(Dump dump22) {
                    }

                    @Override
                    public void init() {
                    }

                    @Override
                    public void run(Map options2, ThreadCallback threadCallback) {
                    }
                });
            }
        };
        try {
            managerInstancesProvider.startInit(new HashMap<Object, Object>());
            ConsoleCommandProcessor.loadDump(null, new DummyThreadCallback(), managerInstancesProvider);
            ui.showMessage(Messages.getString(ConsoleMain.class.getName() + "-8"));
            int paramCnt = 2;
            while (true) {
                String command;
                if (ui.isTaskRunning()) {
                    Thread.sleep(100L);
                    continue;
                }
                String string = command = paramCnt < args.length ? args[paramCnt++] : ui.input("", "");
                if (!command.equals("quit")) {
                    provider2.getUICallback().runAsyncThread(new Task(Messages.getString(ConsoleMain.class.getName() + "-9")){

                        @Override
                        public void run(ThreadCallback threadCallback) {
                            managerInstancesProvider.runConsoleCommand(command, new RMLParseErrorCallback(){

                                @Override
                                public void error(int startPos, int endPos, int line, int offset, String message) {
                                    ui.showErrorMessage(message + Messages.getString(ConsoleMain.class.getName() + "-10") + line + ":" + offset + ": \"" + command.substring(startPos, endPos) + "\"", false);
                                }

                                @Override
                                public void setScriptURL(URL url) {
                                }
                            }, threadCallback, true);
                        }
                    });
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            ui.showException(e, true);
        }
    }
}

