/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.search;

import com.intellij.lang.cacheBuilder.DefaultWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lexer.Lexer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.jetbrains.cmake.CMakeBundle;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommandNameMixin;
import com.jetbrains.cmake.psi.CMakeElementTypes;
import com.jetbrains.cmake.psi.CMakeLexer;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeFindUsagesProvider
implements FindUsagesProvider {
    @Nullable
    public WordsScanner getWordsScanner() {
        return new DollarSignSplittingScanner((Lexer)new CMakeLexer(), CMakeElementTypes.IDENTIFIERS, CMakeElementTypes.COMMENTS, CMakeElementTypes.LITERALS);
    }

    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        return psiElement instanceof PsiNamedElement || psiElement.getNode().getElementType() == CMakeTokenTypes.ID || psiElement.getNode().getElementType() == CMakeTokenTypes.LITERAL;
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement psiElement) {
        return "reference.dialogs.findUsages.other";
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element instanceof CMakeCommandNameMixin) {
            return CMakeBundle.message("cmake.command.name", new Object[0]);
        }
        if (element instanceof CMakeArgument) {
            return CMakeBundle.message("cmake.argument.command.name", new Object[0]);
        }
        return CMakeBundle.message("cmake.search.element", new Object[0]);
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        String name;
        if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
            return '\'' + name + '\'';
        }
        return '\'' + element.getText() + '\'';
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        return this.getDescriptiveName(element);
    }

    private static class DollarSignSplittingScanner
    extends DefaultWordsScanner {
        DollarSignSplittingScanner(Lexer lexer, TokenSet identifiers, TokenSet comments, TokenSet literals) {
            this(lexer, identifiers, comments, literals, TokenSet.EMPTY);
        }

        DollarSignSplittingScanner(Lexer lexer, TokenSet identifiers, TokenSet comments, TokenSet literals, TokenSet skipCodeContext) {
            super(lexer, identifiers, comments, literals, skipCodeContext);
        }

        public void processWords(@NotNull CharSequence fileText, @NotNull Processor<? super WordOccurrence> processor2) {
            super.processWords(fileText, occurrence -> {
                CharSequence currentWord = occurrence.getBaseText().subSequence(occurrence.getStart(), occurrence.getEnd());
                if (!processor2.process(occurrence)) {
                    return false;
                }
                int start = occurrence.getStart();
                for (int i2 = 0; i2 < currentWord.length(); ++i2) {
                    WordOccurrence wordOccurrence;
                    char nextChar = currentWord.charAt(i2);
                    if (nextChar != '$') continue;
                    if (occurrence.getBaseText().subSequence(start, occurrence.getStart() + i2).length() > 0 && !processor2.process((Object)(wordOccurrence = new WordOccurrence(occurrence.getBaseText(), start, occurrence.getStart() + i2, occurrence.getKind())))) {
                        return false;
                    }
                    start = i2 + 1;
                }
                if (start != occurrence.getStart() && occurrence.getBaseText().subSequence(occurrence.getStart() + start, occurrence.getEnd()).length() > 0) {
                    return processor2.process((Object)new WordOccurrence(occurrence.getBaseText(), occurrence.getStart() + start, occurrence.getEnd(), occurrence.getKind()));
                }
                return true;
            });
        }
    }
}

