/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cmake.CMakeLanguage;
import com.jetbrains.cmake.CMakeListsFileType;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeArgumentManipulator;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeFile;
import org.jetbrains.annotations.NotNull;

public class CMakeElementFactory {
    private static final Logger LOG = Logger.getInstance((String)("#" + CMakeElementFactory.class.getPackage().getName()));

    @NotNull
    public static CMakeFile createFile(@NotNull Project project2, @NotNull CharSequence text) {
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        String filename = "dummy." + CMakeListsFileType.INSTANCE.getDefaultExtension();
        LightVirtualFile virtualFile = new LightVirtualFile(filename, CMakeListsFileType.INSTANCE, text);
        virtualFile.setLanguage((Language)CMakeLanguage.INSTANCE);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)virtualFile);
        CMakeLanguage lang = CMakeLanguage.getInstance();
        PsiFile psiFile = ((PsiFileFactoryImpl)factory).trySetupPsiForFile(virtualFile, (Language)lang, false, true);
        if (psiFile == null) {
            FileViewProviderFactory viewFactory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage((Language)lang);
            ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)lang);
            throw new AssertionError((Object)("trySetupPsiForFile returned null\n\tviewFactory=" + viewFactory + "\n\tparserDefinition=" + parser));
        }
        return (CMakeFile)psiFile;
    }

    @NotNull
    public static CMakeArgument createArgument(@NotNull Project project2, @NotNull CharSequence text) {
        String value = CMakeArgumentManipulator.getCMakeLiteralFromValue(text.toString());
        return CMakeElementFactory.createArgumentRaw(project2, value);
    }

    @NotNull
    public static CMakeArgument createArgumentRaw(@NotNull Project project2, @NotNull CharSequence text) {
        LOG.assertTrue(!StringUtil.isEmpty((CharSequence)text), (Object)"empty arguments are not allowed");
        PsiElement arg = CMakeElementFactory.createFile(project2, "foo(" + text + ")").findElementAt(4);
        while (!(arg instanceof CMakeArgument)) {
            assert (arg != null);
            arg = arg.getParent();
        }
        return (CMakeArgument)arg;
    }

    @NotNull
    public static CMakeCommandName createCommandName(@NotNull Project project2, @NotNull CharSequence newCommandName) {
        CMakeFile psiFile = CMakeElementFactory.createFile(project2, newCommandName + "()\n");
        return ((CMakeCommand)psiFile.getFirstChild()).getCMakeCommandName();
    }

    @NotNull
    public static PsiElement createWhitespace(@NotNull Project project2) {
        PsiElement result2 = CMakeElementFactory.createFile(project2, " ").findElementAt(0);
        assert (result2 != null);
        return result2;
    }
}

