/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.ui;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointPropertiesPanel;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.ui.OCFieldAdapterForSymbolName;
import com.jetbrains.cidr.lang.ui.OCTextFieldCompletionProvider;
import com.jetbrains.cidr.lang.ui.OCTextFieldWithSymbolAutoCompletion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolicBreakpointPropertiesPanel
extends CidrSymbolicBreakpointPropertiesPanel {
    private static final Pattern OBJC_METHOD_PATTERN = Pattern.compile("[-+]?(\\[(\\w*)( ([\\w:]*))?]?)");

    public OCSymbolicBreakpointPropertiesPanel(@NotNull Project project2) {
        super(project2);
    }

    @Override
    @NotNull
    protected TextFieldWithAutoCompletion createSymbolNameField() {
        return new OCTextFieldWithSymbolAutoCompletion<OCSymbolNavigationItem>(this.myProject, new ClassSymbolsProvider(this.myProject));
    }

    private static class OCClassLookupElementInsertHandler
    extends LookupElementInsertHandler {
        private OCClassLookupElementInsertHandler() {
            super(' ');
        }

        @Override
        public void handleInsert(@NotNull InsertionContext c, @NotNull LookupElement item) {
            CharSequence sequence = c.getDocument().getCharsSequence();
            if (c.getStartOffset() == 0 || sequence.length() > 0 && sequence.charAt(c.getStartOffset() - 1) != '[') {
                c.getDocument().insertString(c.getStartOffset(), (CharSequence)String.valueOf('['));
            }
            super.handleInsert(c, item);
            OCClassLookupElementInsertHandler.reInvokeCompletion(c);
        }
    }

    private static class LookupElementInsertHandler
    implements InsertHandler<LookupElement> {
        private final char myChar;
        private final Condition<InsertionContext> myCondition;

        private LookupElementInsertHandler() {
            this(' ');
        }

        private LookupElementInsertHandler(char aChar) {
            this(aChar, (Condition<InsertionContext>)null);
        }

        private LookupElementInsertHandler(char aChar, @Nullable Condition<InsertionContext> condition) {
            this.myChar = aChar;
            this.myCondition = condition;
        }

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            CharSequence text;
            int offset;
            if (context2.getCompletionChar() != this.myChar && (this.myCondition == null || this.myCondition.value((Object)context2)) && (offset = context2.getTailOffset()) == (text = context2.getDocument().getCharsSequence()).length()) {
                LookupElementInsertHandler.addCompletionString(context2, offset, String.valueOf(this.myChar));
            }
        }

        protected static void addCompletionString(@NotNull InsertionContext context2, int offset, @NotNull String string) {
            context2.getDocument().insertString(offset, (CharSequence)string);
            context2.getEditor().getCaretModel().moveCaretRelatively(string.length(), 0, false, false, true);
        }

        protected static void reInvokeCompletion(@NotNull InsertionContext context2) {
            context2.setLaterRunnable(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(context2.getProject(), context2.getEditor()));
        }
    }

    private static class CppLookupElementInsertHandler
    extends LookupElementInsertHandler {
        private CppLookupElementInsertHandler() {
        }

        @Override
        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            if (!(item.getObject() instanceof OCSymbolNavigationItem)) {
                return;
            }
            OCSymbolNavigationItem symbolItem = (OCSymbolNavigationItem)item.getObject();
            if (symbolItem.getSymbol() instanceof OCSymbolWithQualifiedName) {
                OCResolveContext resolveContext;
                OCSymbolWithQualifiedName symbol = (OCSymbolWithQualifiedName)symbolItem.getSymbol();
                OCQualifiedName qualifiedName = symbol.getResolvedQualifiedName(resolveContext = OCResolveContext.forSymbol(symbol, context2.getProject()));
                if (qualifiedName != null) {
                    String text = qualifiedName.getFullName(resolveContext);
                    if (symbol instanceof OCFunctionSymbol) {
                        text = text + "(" + StringUtil.join((Collection)ContainerUtil.map(((OCFunctionSymbol)symbol).getParameterSymbols(), symbol1 -> {
                            String canonicalName = symbol1.getResolvedType(resolveContext).getCanonicalName(resolveContext);
                            canonicalName = StringUtil.trimStart((String)canonicalName, (String)"::");
                            canonicalName = canonicalName.replace(" *", "*");
                            return canonicalName;
                        }), (String)", ") + ")";
                        if (symbol.isConst()) {
                            text = text + " const";
                        }
                    }
                    context2.getDocument().replaceString(0, context2.getTailOffset(), (CharSequence)text.substring(2));
                }
                if (!(symbolItem.getSymbol() instanceof OCFunctionSymbol)) {
                    CppLookupElementInsertHandler.addCompletionString(context2, context2.getDocument().getTextLength(), "::");
                    CppLookupElementInsertHandler.reInvokeCompletion(context2);
                }
            }
        }
    }

    private static class ClassSymbolsProvider
    extends OCTextFieldCompletionProvider<OCSymbolNavigationItem> {
        @NotNull
        private final Project myProject;

        private ClassSymbolsProvider(final @NotNull Project project2) {
            super(new OCFieldAdapterForSymbolName(){

                @Override
                @NotNull
                public String getReadableName(@NotNull OCSymbolNavigationItem item) {
                    OCSymbol symbol = item.getSymbol();
                    OCResolveContext context2 = OCResolveContext.forSymbol(symbol, project2);
                    if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).getResolvedOwner(context2) != null) {
                        return ((OCFunctionSymbol)symbol).getSignatureWithoutParamNames(true, false, context2);
                    }
                    return symbol.getPresentableName();
                }
            });
            this.myProject = project2;
        }

        @NotNull
        public Collection<OCSymbolNavigationItem> getItems(@Nullable String prefix, boolean cached, @NotNull CompletionParameters parameters) {
            OCLog.LOG.assertTrue(ProgressManager.getInstance().getProgressIndicator() != null, (Object)"No progress for completion!");
            return (Collection)ReadAction.compute(() -> {
                Collection<OCSymbolNavigationItem> items;
                String text = parameters.getOriginalFile().getText();
                if (cached || prefix == null || text.isEmpty()) {
                    return Collections.emptyList();
                }
                Matcher m = OBJC_METHOD_PATTERN.matcher(text);
                if (m.matches()) {
                    items = m.group(4) != null ? this.collectMethodsForClass(m.group(2)) : this.collectAllClasses();
                } else {
                    PrefixMatcher prefixMatcher = this.createPrefixMatcher(prefix);
                    items = this.collectFunctions(text, prefixMatcher, OCResolveContext.forPsi(parameters.getPosition()));
                    if (!text.contains("::")) {
                        items.addAll(this.collectMatchingMethods(prefixMatcher));
                        items.addAll(this.collectAllClasses());
                    }
                }
                ArrayList<OCSymbolNavigationItem> list = new ArrayList<OCSymbolNavigationItem>(items);
                list.sort((Comparator<OCSymbolNavigationItem>)((Object)this));
                return list;
            });
        }

        @NotNull
        private Collection<OCSymbolNavigationItem> collectMethodsForClass(@Nullable String className) {
            HashSet set = new HashSet();
            ArrayList<OCSymbolNavigationItem> results = new ArrayList<OCSymbolNavigationItem>();
            final Processor methodSymbolCollector = method -> {
                if (set.add(method.getPresentableName())) {
                    results.add(new OCSymbolNavigationItem((OCSymbol)method, this.myProject));
                }
                return true;
            };
            Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){

                @Contract(value="null -> true")
                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCClassSymbol) {
                        ((OCClassSymbol)symbol).processMembersInAllCategories(null, OCMethodSymbol.class, methodSymbolCollector, myProject);
                        for (String protocolName : ((OCClassSymbol)symbol).getProtocolNames()) {
                            if (protocolName.equals(symbol.getName())) continue;
                            OCGlobalProjectSymbolsCache.processTopLevelSymbols(myProject, this, protocolName);
                        }
                    }
                    return true;
                }
            };
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(this.myProject, (Processor<? super OCSymbol>)processor2, className);
            return results;
        }

        @NotNull
        private Collection<OCSymbolNavigationItem> collectAllClasses() {
            return this.collectValuesFromProject(this.myProject, item -> (item.getSymbol() instanceof OCImplementationSymbol || item.getSymbol() instanceof OCInterfaceSymbol) && ((OCClassSymbol)item.getSymbol()).getCategoryName() == null);
        }

        @NotNull
        private Collection<OCSymbolNavigationItem> collectFunctions(final @NotNull String text, final @NotNull PrefixMatcher prefixMatcher, final @NotNull OCResolveContext context2) {
            final HashSet set = new HashSet();
            String[] strings = text.split("::", -1);
            String parentName = strings.length >= 2 ? strings[strings.length - 2] : null;
            final ArrayList<OCSymbolNavigationItem> results = new ArrayList<OCSymbolNavigationItem>();
            Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){

                private boolean accept(OCSymbol symbol) {
                    OCQualifiedName qualifiedName;
                    String nameWithParent;
                    if ((symbol instanceof OCFunctionSymbol || ClassSymbolsProvider.isValidNamespace(symbol)) && prefixMatcher.prefixMatches(nameWithParent = ((OCSymbolWithQualifiedName)symbol).getNameWithParent(context2)) && (qualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(context2)) != null) {
                        String canonicalName = qualifiedName.getFullName(context2);
                        return this.createPrefixMatcher(text).prefixMatches(canonicalName) && set.add(canonicalName);
                    }
                    return false;
                }

                public boolean process(OCSymbol symbol) {
                    if (this.accept(symbol)) {
                        results.add(new OCSymbolNavigationItem(symbol, myProject));
                    }
                    return true;
                }
            };
            ReadAction.run(() -> this.lambda$collectFunctions$4(parentName, (Processor)processor2, results));
            return results;
        }

        private static boolean isValidNamespace(OCSymbol symbol) {
            boolean validNamespace;
            boolean bl = validNamespace = symbol instanceof OCNamespaceSymbol && symbol.getKind() != OCSymbolKind.ENUM;
            if (validNamespace) {
                CommonProcessors.FindFirstProcessor<OCSymbol> findFirstProcessor = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                    protected boolean accept(OCSymbol symbol) {
                        return symbol instanceof OCFunctionSymbol || symbol instanceof OCNamespaceSymbol;
                    }
                };
                ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<? super OCSymbol>)findFirstProcessor);
                validNamespace = findFirstProcessor.isFound();
            }
            return validNamespace;
        }

        private Collection<OCSymbolNavigationItem> collectMatchingMethods(PrefixMatcher prefixMatcher) {
            HashSet set = new HashSet();
            ArrayList<OCSymbolNavigationItem> results = new ArrayList<OCSymbolNavigationItem>();
            Processor objCProcessor = symbol -> {
                if (symbol instanceof OCMethodSymbol && prefixMatcher.prefixMatches(symbol.getPresentableName()) && set.add(symbol.getPresentableName())) {
                    results.add(new OCSymbolNavigationItem((OCSymbol)symbol, this.myProject));
                }
                return true;
            };
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, (Processor<? super OCSymbol>)objCProcessor, null);
            return results;
        }

        @Nullable
        protected InsertHandler<LookupElement> createInsertHandler(@NotNull OCSymbolNavigationItem item) {
            if (item.getSymbol() instanceof OCMethodSymbol) {
                return new LookupElementInsertHandler(']', c -> c.getDocument().getText(TextRange.create((int)0, (int)c.getTailOffset())).contains("["));
            }
            if (item.getSymbol() instanceof OCNamespaceSymbol || item.getSymbol() instanceof OCFunctionSymbol) {
                return new CppLookupElementInsertHandler();
            }
            if (item.getSymbol() instanceof OCClassSymbol) {
                return new OCClassLookupElementInsertHandler();
            }
            return new LookupElementInsertHandler(' ');
        }

        @Nullable
        public String getPrefix(@NotNull String text, int offset) {
            Matcher m = OBJC_METHOD_PATTERN.matcher(text);
            if (m.matches()) {
                String prefix = ClassSymbolsProvider.getCurrentToken(text, m, offset, 4);
                if (prefix != null) {
                    return prefix;
                }
                return ClassSymbolsProvider.getCurrentToken(text, m, offset, 2);
            }
            int i2 = (text = text.substring(0, offset)).lastIndexOf("::");
            if (i2 != -1) {
                return text.substring(i2 + 2);
            }
            return text;
        }

        private static String getCurrentToken(@NotNull String text, @NotNull Matcher m, int pos, int groupIndex) {
            return m.start(groupIndex) <= pos && pos <= m.end(groupIndex) ? text.substring(m.start(groupIndex), pos) : null;
        }

        private /* synthetic */ void lambda$collectFunctions$4(String parentName, Processor processor2, ArrayList results) throws RuntimeException {
            boolean topLevelOnly = false;
            if (parentName != null) {
                if (parentName.isEmpty()) {
                    topLevelOnly = true;
                } else {
                    OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, (Processor<? super OCSymbol>)((Processor)symbol -> {
                        if (symbol instanceof OCNamespaceSymbol) {
                            ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<? super OCSymbol>)processor2);
                        }
                        return true;
                    }), parentName);
                }
            }
            if (results.isEmpty()) {
                OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, (Processor<? super OCSymbol>)processor2, null, topLevelOnly);
            }
        }
    }
}

