/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestingFrameworkUsagesCollector
extends ProjectUsagesCollector {
    public static final String GROUP_ID = "cidr.testingFrameworks";

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project2) {
        TObjectIntHashMap data = new TObjectIntHashMap();
        List configurationsList = RunManager.getInstance((Project)project2).getAllConfigurationsList();
        for (RunConfiguration runConfiguration : configurationsList) {
            ProgressManager.checkCanceled();
            String name = CidrTestingFrameworkUsagesCollector.getFrameworkId(runConfiguration);
            if (name == null) continue;
            if (!data.containsKey((Object)name)) {
                data.put((Object)name, 0);
            }
            data.increment((Object)name);
        }
        return ContainerUtil.map2Set((Object[])data.keys(), o -> {
            String key = (String)o;
            FeatureUsageData eventData = new FeatureUsageData().addData("framework_id", key);
            return MetricEventFactoryKt.newCounterMetric((String)"test.run.configuration", (int)data.get((Object)key), (FeatureUsageData)eventData);
        });
    }

    @Nullable
    public static String getFrameworkId(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration instanceof CidrTestRunConfiguration) {
            return (String)ReadAction.compute(() -> {
                CidrTestRunConfigurationData testData = ((CidrTestRunConfiguration)runConfiguration).getTestData();
                boolean canReportID = PluginInfoDetectorKt.getPluginInfo(testData.getClass()).isDevelopedByJetBrains();
                return canReportID ? testData.getTestingFrameworkId() : "third.party";
            });
        }
        return null;
    }

    @NotNull
    public String getGroupId() {
        return GROUP_ID;
    }

    public int getVersion() {
        return 2;
    }
}

