/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapRealFrameworkPathResolver;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapAwareHeadersSearchRoot;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RealFramework
extends AppleFramework
implements ModuleMapAwareHeadersSearchRoot {
    @Nullable
    private final PsiFileSystemItem myParent;
    @NotNull
    private final VirtualFile myBaseFile;
    @Nullable
    private final String myResolveConfigurationId;

    public RealFramework(@NotNull Project project2, @NotNull VirtualFile baseFile, @Nullable PsiFileSystemItem parentSdkOrFramework) {
        this(project2, null, baseFile, parentSdkOrFramework);
    }

    public RealFramework(@NotNull Project project2, @Nullable String resolveConfigurationId, @NotNull VirtualFile baseFile, @Nullable PsiFileSystemItem parentSdkOrFramework) {
        super(project2, baseFile.getNameWithoutExtension());
        this.myParent = parentSdkOrFramework;
        this.myBaseFile = baseFile;
        this.myResolveConfigurationId = resolveConfigurationId;
    }

    @Override
    @Nullable
    public PsiFileSystemItem getParent() {
        return this.myBaseFile.isValid() ? this.myManager.findDirectory(this.myBaseFile) : null;
    }

    @Override
    @NotNull
    public ModuleMapPathResolver createModuleMapPathResolver() {
        return new ModuleMapRealFrameworkPathResolver(this.myBaseFile);
    }

    @Override
    @Nullable
    public VirtualFile findModuleMapVirtualFile() {
        VirtualFile moduleMapFile;
        if (!this.myBaseFile.isValid()) {
            OCLog.LOG.error("Invalid base file for RealFramework" + this.getName());
            return null;
        }
        VirtualFile modulesDir = this.myBaseFile.findChild("Modules");
        if (modulesDir != null && modulesDir.isDirectory() && ModuleMapUtil.checkModuleMapFile(moduleMapFile = modulesDir.findChild("module.modulemap"))) {
            return moduleMapFile;
        }
        VirtualFile legacyFile = this.myBaseFile.findChild("module.map");
        if (ModuleMapUtil.checkModuleMapFile(legacyFile)) {
            return legacyFile;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiFileSystemItem getParentSdkOrFrameworkItem() {
        return this.myParent;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myBaseFile;
    }

    @Override
    public boolean isValid() {
        return this.myBaseFile.isValid();
    }

    @Override
    public boolean containsHeader(@Nullable VirtualFile file2) {
        OCResolveConfiguration configuration;
        if (file2 == null) {
            return false;
        }
        if (this.myResolveConfigurationId != null) {
            OCWorkspace workspace = OCWorkspace.getInstance(this.myProject);
            configuration = workspace.getConfigurationById(this.myResolveConfigurationId);
        } else {
            configuration = null;
        }
        ModuleMapSymbol module2 = ModuleMapUtil.getMainFrameworkModule(this, configuration);
        if (module2 == null) {
            return false;
        }
        return module2.getPathResolver().containsHeader(file2);
    }

    @Override
    protected boolean processFrameworkChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        if (this.myBaseFile.isValid()) {
            for (String eachDir : HEADERS_DIR_NAMES) {
                if (RealFramework.processUnder(processor2, this.myBaseFile.findChild(eachDir), false, this.myProject)) continue;
                return false;
            }
            if (!RealFramework.processUnder(processor2, this.myBaseFile.findChild("Modules"), false, this.myProject)) {
                return false;
            }
            if (!FrameworksSearchRoot.processFrameworksUnder((PsiFileSystemItem)this, this.myBaseFile.findChild("Frameworks"), processor2, (Set<String>)new THashSet())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealFramework framework = (RealFramework)o;
        return this.myBaseFile.equals(framework.myBaseFile);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myBaseFile.hashCode();
        return result2;
    }

    @Override
    public String toString() {
        return "AppleFramework: [" + this.getName() + ": " + this.myBaseFile.getPath() + "]";
    }

    public boolean hasModuleMap() {
        return this.findModuleMapVirtualFile() != null;
    }
}

