/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.jetbrains.cidr.PathTree;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadersSearchPathTree
extends PathTree<HeadersSearchPathTree, HeadersSearchPath> {
    @Nullable
    private final HeadersSearchPathTree myParent;
    @NotNull
    private final List<HeadersSearchPath> myCompactedPaths = new ArrayList<HeadersSearchPath>();

    public HeadersSearchPathTree() {
        this(null);
    }

    private HeadersSearchPathTree(@Nullable HeadersSearchPathTree parent) {
        this.myParent = parent;
    }

    @Override
    @NotNull
    protected HeadersSearchPathTree createNewTree(@Nullable HeadersSearchPathTree parent) {
        return new HeadersSearchPathTree(parent);
    }

    public void addSearchPathCompacting(@NotNull HeadersSearchPath path) {
        String filePath = path.getPath();
        HeadersSearchPathTree visitedAncestorTree = (HeadersSearchPathTree)this.getSubTree(filePath, PathTree.SearchStrategy.DEEPEST_EXISTING_PREFIX);
        while (visitedAncestorTree != null) {
            for (HeadersSearchPath visitedPath : visitedAncestorTree.getItems()) {
                if (path.getKind() != visitedPath.getKind() || path.isFrameworksSearchPath() != visitedPath.isFrameworksSearchPath() || !visitedPath.isRecursive() && !path.equals(visitedPath)) continue;
                return;
            }
            visitedAncestorTree = visitedAncestorTree.myParent;
        }
        this.addItem(filePath, path);
        this.myCompactedPaths.add(path);
    }

    public void addSearchPathsCompacting(@NotNull Collection<HeadersSearchPath> paths) {
        for (HeadersSearchPath path : paths) {
            this.addSearchPathCompacting(path);
        }
    }

    @NotNull
    public List<HeadersSearchPath> getCompactedPaths() {
        return Collections.unmodifiableList(this.myCompactedPaths);
    }
}

