/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.modulemap.resolve.FrameworkRootModuleMapCollector;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapLocationProvider;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworksSearchRoot
extends FrameworksRoot
implements ModuleMapLocationProvider {
    @NotNull
    public static FrameworksSearchRoot create(@NotNull Project project2, @NotNull VirtualFile file2) {
        return new Transient(project2, file2);
    }

    @NotNull
    public static FrameworksSearchRoot create(@NotNull Project project2, @NotNull VirtualFilePointer pointer) {
        return new Pointer(project2, pointer);
    }

    private FrameworksSearchRoot(@NotNull Project project2) {
        super(project2);
    }

    @NotNull
    public abstract String getUrl();

    @NotNull
    public String getName() {
        return "Frameworks Search Root";
    }

    @Override
    public boolean processFrameworks(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed, boolean includeSdkFrameworks) {
        return FrameworksSearchRoot.processFrameworksUnder((PsiFileSystemItem)this, this.getVirtualFile(), processor2, processed);
    }

    public static boolean processFrameworksUnder(@NotNull PsiFileSystemItem parentSdkOrFramework, @Nullable VirtualFile root, @NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed) {
        Project project2 = parentSdkOrFramework.getProject();
        if (root != null && root.isValid() && root.isDirectory() && !project2.isDisposed()) {
            for (VirtualFile frameworkPath : root.getChildren()) {
                RealFramework framework;
                if (!AppleFramework.isFrameworkRoot(frameworkPath) || (framework = new RealFramework(project2, frameworkPath, parentSdkOrFramework)).process(processor2, processed)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<? extends HeadersSearchRoot> getPossibleModuleMapLocations() {
        ArrayList<HeadersSearchRoot> roots2 = new ArrayList<HeadersSearchRoot>();
        this.processChildren(new FrameworkRootModuleMapCollector(this.myProject, roots2));
        return roots2;
    }

    public String toString() {
        return "FrameworksSearchRoot: " + this.getUrl();
    }

    private static class Pointer
    extends FrameworksSearchRoot {
        @NotNull
        private final VirtualFilePointer myRootPointer;

        private Pointer(@NotNull Project project2, @NotNull VirtualFilePointer root) {
            super(project2);
            this.myRootPointer = root;
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myRootPointer.getFile();
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.myRootPointer.getUrl();
        }

        @Override
        public boolean isValid() {
            return this.myRootPointer.isValid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pointer pointer = (Pointer)o;
            return this.myRootPointer.equals(pointer.myRootPointer);
        }

        public int hashCode() {
            return Objects.hash(this.myRootPointer);
        }
    }

    private static class Transient
    extends FrameworksSearchRoot {
        @NotNull
        private final VirtualFile myRoot;

        private Transient(@NotNull Project project2, @NotNull VirtualFile root) {
            super(project2);
            this.myRoot = root;
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myRoot;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.myRoot.getUrl();
        }

        @Override
        public boolean isValid() {
            return this.myRoot.isValid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.myRoot.equals(((Transient)o).myRoot);
        }

        public int hashCode() {
            return Objects.hash(this.myRoot);
        }
    }
}

